Esto es CLISP, una implementacin de Common Lisp.


 Qu es LISP ?
---------------

LISP es un lenguaje de programacin inventado por J. McCarthy en
1959. Aunque ha habido muchos dialectos de l, actualmente se ha
estandarizado y difundido ampliamente gracias al estandar industrial
COMMON LISP. Hay aplicaciones en los dominios del procesamiento del
conocimiento simblico (IA), clculo numrico (MACLISP generaba cdigo
tan bueno como el de FORTRAN), y en programas ampliamente utilizados
como editores (EMACS) y CAD (AUTOCAD). Si lo desea, puede consultar la
introduccin al lenguaje LISP:

  Sheila Hughes: Lisp. Pitman Publishing Limited, London 1986.
  107 pages.

Despus de un rato, necesitar el texto estandar que contiene la
definicin del lenguaje:

Guy L. Steele Jr.: Common Lisp - The Language. Digital Press.
  1. edition 1984, 465 pages.
  2. edition 1990, 1032 pages.

Este libro est disponible en formato HTML via FTP en:
  ftp.cs.cmu.edu:/user/ai/lang/lisp/doc/cltl/cltl_ht.tgz

y puede consultarse a travs de WWW en:

  http://www.cs.cmu.edu:8001/Web/Groups/AI/html/cltl/cltl2.html o	
  http://www.cs.cmu.edu:8001/afs/cs/project/ai-repository/ai/html/cltl/cltl2.html .

Nota para los expertos: Este texto estandar se ha convertido en un
estndar ANSI, que puede obtenerse <<<exceptionally>>> sin cargo alguno en:

  http://www.harlequin.com/books/HyperSpec/

LISP se ejecuta en un entorno interactivo. Usted introduce formas, que
sern evaluadas de inmediato. Por lo tanto, puede inspeccionar
variables, invocar funciones con unos argumentos concretos o definir
sus propias funciones.


Contenidos:
-----------

Consta de los siguientes ficheros:

#ifdef UNIX
#ifndef UNIX_BINARY_DISTRIB
   base/lisp.a            programa principal, listo para ser enlazado
#endif
#ifdef UNIX_BINARY_DISTRIB
   base/lisp.run          programa principal
#endif
   base/lispinit.mem      imagen de memoria necesaria para la inicializacin
   doc/clisp.1            manual en formato man de Unix
   doc/clisp.man          manual
   doc/clisp.html         manual en format HTML
   doc/impnotes.html      notas de la implementacin
#ifdef GNU_READLINE
   doc/clreadline.3       manual de edicin de lnea en formato man de Unix
   doc/clreadline.man     manual de edicin de lnea
#endif
   doc/LISP-tutorial.txt  tutorial de LISP para aprendices
   doc/CLOS-guide.txt     breve gua de CLOS
   README                 este texto
   SUMMARY                pequea descripcin de CLISP
   ANNOUNCE               declaracin
   NEWS                   lista de modificaciones desde la ltima versin
   COPYRIGHT              derechos de autor <<<copyright>>>
   GNU-GPL                licencia de software libre
#ifdef GNU_READLINE
   doc/readline.dvi       documentacin de la librera GNU readline
                          en formato DVI
#endif
   doc/editors.txt        Lista de editores que soportan Lisp
   emacs/*.el             personalizacin de Emacs, vase doc/editors.txt
#ifndef UNIX_BINARY_DISTRIB
   src/clisp.c            fuentes del programa
#endif
   src/config.lsp         configuracin dependiente del lugar

y - cuando le apetezca, si le gusta leer cdigo fuente -

   src/*.lsp              el cdigo fuente de lispinit.mem
   src/*.fas              los mismos ficheros, una vez compilados
#if !defined(UNIX_BINARY_DISTRIB) && defined(GNU_READLINE)

Para crear el ejecutable, tambin necesitar:

   base/libreadline.a     librera GNU readline

o

   base/libnoreadline.a   sustituto ficticio de la librera GNU readline
#endif
#else /* !defined(UNIX) */
#ifdef AMIGAOS
      lisp.run           programa principal
#endif
#ifdef MSDOS
      lisp.exe           programa principal
#ifndef OS2
      lisp_1mb.exe       programa principal, utilice ste si slo 
                         dispone de 1 o 2 MB de RAM
#endif
#endif
#ifdef RISCOS
      lisp               programa principal
#endif
      lispinit.mem       imagen de memoria necesaria para la inicializacin
#ifdef GNU_GETTEXT
      locale/*/LC_MESSAGES/clisp.mo  <<<localized messages databases>>>
#endif
      clisp.1            manual en formato `man' de Unix
#ifdef AMIGAOS
      clisp.doc          manual
#else
      clisp.man          manual
#endif
      clisp.html         manual en format HTML
#ifdef MSDOS
      clisp.dvi          manual en formato DVI
#endif
      impnotes.html      notas de la implementacin
#ifdef GNU_READLINE
      clreadline.3       manual de edicin de lnea en formato `man' de Unix
      clreadline.man     manual de edicin de lnea
      clreadline.html    manual de edicin de lnea en format HTML
#ifdef MSDOS
      clreadline.dvi     manual de edicin de lnea en formato DVI
#endif
#endif
      LISP-tutorial.txt  tutorial de LISP para aprendices
      CLOS-guide.txt     breve gua de CLOS
      editors.txt        <<<some words about text editors for Lisp>>>
#ifdef EMUNIX
      emx.exe            extensor DOS rsx para ejecutar clisp bajo DOS o OS/2
      emx-user.doc       gua del usuario de aplicaciones emx
      emx-faq.doc        preguntas frecuentes sobre las aplicaciones emx
#ifdef EMUNIX_PORTABEL
      emx.dll            librera de enlazamiento dinmico de OS/2 que contiene emx
      emxlibc.dll        librera de enlazamiento dinmico de OS/2 que contiene emx libc
#endif
      termcap.dat        base de datos del terminal 
#endif
#if defined(MSDOS) && !defined(OS2)
      rsx.exe            extensor DOS rsx para ejecutar clisp bajo Windows
      rsx-read.txt       descripcin general de rsx
      rsx.hlp            <<<general documentation for rsx>>>
      delay.exe          programa auxiliar para ejecutar clisp bajo Windows
#endif
#ifdef RISCOS
      !Run               fichero de ejecucin para CLISP
      !Sprites           icono de CLISP
#endif
      README             este texto
      SUMMARY            pequea descripcin de CLISP
      ANNOUNCE           declaracin
      NEWS               lista de modificaciones desde la ltima versin
      COPYRIGHT          derechos de autor
      GNU-GPL            licencia de software libre
#ifdef GNU_READLINE
      readline.dvi	 documentacin de la librera GNU readline en formato DVI
#endif
      config.lsp         configuracin dependiente del lugar
#if !(defined(UNIX) || defined(WIN32))
      timezone.lsp       zona horaria dependiente del lugar
#endif

y - cuando le apetezca, si le gusta leer cdigo fuente -

      *.lsp              el cdigo fuente de lispinit.mem
#if !defined(MSDOS)
      *.fas              los mismos ficheros, una vez compilados
#endif
#endif

#ifdef MSDOS

Requisitos Hardware:
--------------------

#ifndef OS2
La versin para DOS de CLISP necesita una CPU 80386 (SX o DX) o un 80486
con, al menos, 1 MB de RAM.
#else
La versin para OS/2 de CLISP necesita una CPU 80386 (SX o DX) o un 80486,
ejecutando OS/2 2.0.
#endif
Tambin se ejecuta en un Pentium; los resultados que produce CLISP no
estn afectados por el error de divisin del Pentium de Intel.

#endif
#ifdef AMIGAOS

Requisitos Hardware:
--------------------

Esta versin para Amiga de CLISP requiere, al menos, 1.5 MB de RAM. La
versin denominada CLISP-LOW se ejecuta en mquinas sin ms memoria
que la que puede direccionarse en un rango de 24 bits: en el 68000,
A2620 y A2630. La versin denominada CLISP-HIGH se ejecuta en memorias
que se direccionan con 27 bits (en el rango de direcciones de
#x00000000 to #x07FFFFFF), pero slo en las CPUs 68020/030/040(/060?):
en A3000 y A4000 sin placas de memoria Zorro-III. La versin
denominada CLISP-00 se ejecuta nicamente en una CPU 68000/010, pero
es ms rpida que CLISP-LOW. La versin denominada CLISP-WIDE utiliza
enteros de 64 bits y se ejecuta sobre cualquier memoria en un
procesador 68020 o superior: sobre A4000 con VMM. El esfuerzo
adicional para el tratamiento de nmeros enteros de 64 bits hace que
CLISP-WIDE sea ms lento que CLISP-HIGH.

#endif
#ifdef RISCOS

Requisitos Hardware:
--------------------

Esta versin de CLISP requiere un PC Acorn Archimedes o Acorn RISC
con, al menos, 4 MB de Ram y RISC OS 3.0 o superior. Ms adelante se
explica como crear una versin de CLISP que se ejecute con solo 2 MB.

#endif
#if defined(SINGLEMAP_MEMORY) && (defined(UNIX_LINUX) || !defined(HAVE_MMAP_ANON))

Requisitos Software:
--------------------

#ifdef UNIX_LINUX
#ifdef GENERATIONAL_GC
#ifdef IMMUTABLE
Esta versin de CLISP necesita Linux 1.2.2 o ms reciente.
#else
Esta versin de CLISP necesita Linux 1.1.52 o ms reciente.
#endif
#else
Esta versin de CLISP necesita Linux 0.99.7 o ms reciente.
#endif
#endif
#if !defined(HAVE_MACH_VM) && !defined(HAVE_MMAP_ANON) /* impliziert HAVE_MMAP_DEVZERO */
/dev/zero debe ser legible por cualquiera. Para ello, debe ejecutar el
comando "chmod a+r /dev/zero".
#endif

#endif
#ifdef AMIGAOS

Requisitos Software:
--------------------

Esta versin de CLISP necesita OS 2.04 (V37) o ms reciente.

#endif

Instalacin:
------------

#ifdef OS2
Antes que nada, instale emx.dll y emxlibc.dll en un directorio aparte,
por ejemplo c:\emx\dll. Aada c:\emx\dll (asegrese de colocar la
unidad de disco correcta) a la sentencia LIBPATH de su fichero
config.sys. Reinicie su ordenador, de modo que se active la nueva
instruccin LIBPATH y las nuevas variables de entorno.

#endif
#ifdef EMUNIX

Para que las lneas de entrada demasiado largas puedan mostrarse de
una manera elegante, es necesario que tenga una linea del tipo:

    DEVICE=ANSI.SYS

en su fichero CONFIG.SYS. Ms an, la variable de entorno TERM debe
estar definida, y la variable de entorno TERMCAP debe contener el
nombre del fichero (con la ruta completa) de la base de datos
TERMCAP.DAT, con la definicin de las capacidades del terminal. Es una
buena idea, aadir estas instrucciones en el fichero CLISP.BAT que se
construye ms adelante. Si lo desea, puede instalar el fichero
TERMCAP.DAT en un directorio aparte, por ejemplo c:\emx\etc.

#endif
#if defined(UNIX) || defined(WIN32)
#if defined(UNIX) && !defined(UNIX_BINARY_DISTRIB)
Teclee

         make

#if 0 /* def GNU_READLINE - man mu Makefile verndern */
Si desea renunciar a las capacidades de edicin de lectura de la
librera GNU readline, debera haber reemplazado "libreadline.a" en la
lnea LIBS del fichero BASE/MAKEVARS por "libnoreadline.a".

#endif
#endif
Cambie las cadenas en SRC/CONFIG.LSP, empleando para ello un editor de
textos.
#else
Edite el fichero CONFIG.LSP y modifquelo adecuadamente para su
estacin, con especial atencin a las definiciones de short-site-name
y long-site-name. Si lo desea, tambin puede modificar la definicin
de la zona horaria al final del fichero TIMEZONE.LSP.
#endif
Luego ejecute

#if defined(MSDOS) || defined(WIN32_NATIVE)
         lisp.exe -M lispinit.mem
#endif
#ifdef AMIGAOS
         lisp.run -M lispinit.mem
#endif
#ifdef UNIX
         base/lisp.run -M base/lispinit.mem
#endif
#ifdef RISCOS
         lisp -M mem.lispinit

o haga doble click sobre el directorio !Clisp.
#endif

Cuando aparezca el inductor de comandos

      > _

teclee

#ifdef RISCOS
        (cd "<clisp$path>.")

para asegurarse de que el directorio !Clisp es el que est actualmente
seleccionado. Luego

#endif
#if defined(UNIX) || defined(WIN32)
        (compile-file "src/config.lsp")
        (load "src/config.fas")
#else
        (compile-file "config.lsp")
        (load "config.fas")

y - si modific el fichero TIMEZONE.LSP -

        (compile-file "timezone.lsp")
        (load "timezone.fas")
#endif

y luego

#ifdef UNIX
        (cd "base/")
#endif
        (saveinitmem)

para sobreescribir el fichero LISPINIT.MEM con su configuracin. A
continuacin

        (exit)

#ifdef UNIX
El resto se hace simplemente con

        make install

En vez de esto, puede hacerlo usted mismo, paso por paso:

#endif
#ifndef RISCOS
Luego cree un directorio, y ponga en l el ejecutable con la imagen de
memoria.
#endif
#ifdef UNIX
Le recomiendo /usr/local/lib/lisp :

   mkdir /usr/local/lib/lisp
   mv base/lisp.run /usr/local/lib/lisp
   mv base/lispinit.mem /usr/local/lib/lisp
#endif
#if defined(MSDOS) || defined(WIN32_NATIVE)
Suponiendo D:\LIB\LISP :

   mkdir d:\lib\lisp
   copy lisp.exe d:\lib\lisp
   copy lispinit.mem d:\lib\lisp
#endif

#if defined(MSDOS) || defined(WIN32_NATIVE)
Y cree un fichero de ejecucin por lotes que ejecute lisp:

#ifndef OS2
   copy con c:\bat\clisp.bat
#else
   copy con c:\cmd\clisp.cmd
#endif
#ifdef EMUNIX
   set TERM=ansi
   set TERMCAP=c:/emx/etc/termcap.dat
#endif
   d:\lib\lisp\lisp.exe -M d:\lib\lisp\lispinit.mem -B d:\lib\lisp\ %1 %2 %3 %4 %5 %6 %7 %8 %9
   [Ctrl-Z]
#endif
#ifdef UNIX
Y cree el programa que ejeute lisp:

#ifdef UNIX_BINARY_DISTRIB
   cc -O -DLISPLIBDIR='"/usr/local/lib/lisp"' \
         -DLOCALEDIR='"/usr/local/share/locale"' \
      src/clisp.c -o /usr/local/bin/clisp
#else
   ./hardcode -DLISPLIBDIR='/usr/local/lib/lisp' \
              -DLOCALEDIR='/usr/local/share/locale' \
              clisp /usr/local/bin/clisp
#endif

#ifdef GNU_READLINE
Ahora, instale las pginas de man.
#else
Ahora, instale la pgina man.
#endif

   mv doc/clisp.1 /usr/local/man/man1/clisp.1
#ifdef GNU_READLINE
   mv doc/clreadline.3 /usr/local/man/man3/clreadline.3
#endif

and try

   man clisp
#endif

#if defined(MSDOS) && !defined(OS2)

Instalacin en Microsoft Windows:
---------------------------------

CLISP tambin se ejecuta en una ventana de DOS bajo Microsoft Windows
3.1. Para ello, es necesario llevar a cabo los siguientes pasos:

1. Consiga e instale
     ftp://clisp.cons.org/pub/lisp/clisp/binaries/dos/clisp.zip
   tal y como se describe ms arriba.

2. Si RSX.EXE no est ya en el fichero CLISP.ZIP, consiga e instlelo
   en, por ejemplo, C:\RSX. 
     ftp://ftp.uni-bielefeld.de/pub/systems/msdos/misc/rsx510b.zip

3. Ejecute el editor de PIF e introduzca lo siguiente:

   Programa:                c:\rsx\bin\rsx.exe
   Nombre del programa:     COMMON LISP
   Parmetros del programa: -Ra c:\lib\lisp\lisp.exe -M c:\lib\lisp\lispinit.mem -B c:\lib\lisp\
                            (tal vez despus de -Ra deba aadir tambin -Rs1024)
   Directorio de inicio:    e:\lisp  (o donde corresponda)
   Pantalla:                Texto
   Requisitos de memoria:   requiere:  500      mximo:  640
   Memoria EMS:             requiere:    0      mximo:    0
   Memoria XMS:             requiere: 1024      mximo:   -1
   Display:                 [como quiera]
   Quit_closes_window:      [como quiera]
   Ejecucin:               [como quiera]
   other_options:           [como quiera]

   (Probablemente eligir como directorio de inicio, aqul que
   contiene sus programas lisp, en vez de e:\lisp.)

   Guardelo con el nombre WINCLISP.PIF.

4. En el administrador de programas, en un grupo adecuado:

   Men "File" -> "New" -> "Program", ventana "Propiedades del programa".
   Introduzca ah :

   Descripcin:            COMMON LISP
   Lnea de comandos:      winclisp.pif
   Directorio de inicio:   e:\lisp
   Combinacin de teclas:  Ctrl+Alt+Shift+L      [como ms le guste]

Presionando con el ratn en el grupo recin creado o pulsando la
combinacin de teclas indicada anteriormente, ejecutar CLISP.

Notas:

* Copiar y Pegar en las ventanas de DOS (via el men "Edit" -> "Mark"
  resp. men "Edit" -> "Insert") inserta un <Enter> al final. Por eso,
  no es posible volver a editar una lnea copiada.

* Pero las facilidades de edicin mencionadas en CLISP.MAN y
  READLINE.DVI s que funcionan.

#endif
#ifdef AMIGAOS

Nota:
-----

Puede ejecutar CLISP desde Workbench(tm). Los siguientes Tooltypes son
reconocidos en el icono Tool:

   WINDOW=<ventana o especificacin de `pipe'>
   ARGS=<argumentos del tipo CLI>

Por ejemplo,

   WINDOW=CON:0/11/640/200/CLISP-Listener/CLOSE
   ARGS=-M lispinit.mem

#endif
#ifdef RISCOS

Corto de memoria?
------------------

Si slo dispone de 2 MB de RAM, puede crear un CLISP "desmontado" que
requiere menos memoria, pero que no dispondr de algunas partes
definidas en CLtL2, dpANS-LOOP, CLOS, Condiciones y flujos genricos:
Reemplace DEFS2.FAS, LOOP.FAS, CLOS.FAS, CONDITIO.FAS, DEFS3.FAS,
GSTREAM.FAS por ficheros vacos y ejecute:

   lisp
   > (load "init.fas")
   > (saveinitmem)
   > (exit)

Esto sobreescribir el fichero LISPINIT.MEM por otro ms pequeo.

#endif

Cuando encuentre problemas:
---------------------------

#ifdef EMUNIX
Si clisp no se ejecuta de ninguna manera, consulte
EMX-USER.DOC. LISP.EXE es una aplicacin EMX, de modo que todo lo que
se menciona ah, se aplica a LISP.EXE.

#endif
Despus de un error, se encontrar en el depurador:

     1. Break> _

En l, usted puede evaluar formas como siempre. Ms an:

     Help
               invoca la ayuda
     Abort     o
     Unwind
               retrocede hasta el bucle de entrada ms reciente
     Backtrace
               muestra los contenidos de la pila, til para la depuracin

Y puede consultar el valor de las variables de las funciones donde se
produjo el error.

#ifdef UNIX
Cuando los problemas sean mayores, por ejemplo `core dumps', por favor
#endif
#ifdef AMIGAOS
Cuando los problemas sean mayor, por ejemplo "guru"s, por favor
#endif
#ifdef MSDOS
Cuando los problemas sean mayor, por ejemplo "register dumps", por favor
#endif
#ifdef RISCOS
Cuando los problemas sean mayores, por ejemplo, "stack dumps", por favor
#endif
enve una descripcin del error y una descripcin de cmo reproducir
el error a los autores o al "mantenedor". Por favor, acompae su mensaje
de la versin de CLISP que puede obtener invocando la funcin
(lisp-implementation-version).


Cdigo fuente:
--------------

El cdigo fuente de CLISP est disponible en
     ftp://clisp.cons.org/pub/lisp/clisp/source/clispsrc*
#ifdef UNIX_LINUX
La ltima distribucin binaria de CLISP para Linux tiene su propio
cdigo fuente en
     ftp://sunsite.unc.edu/pub/Linux/devel/lang/lisp/clisp-source.tar.gz
#endif


#if 0
<<<Mailing lists:>>>
#endif
Lista de correo:
----------------

#if 0
Hay una lista de correo para los usuarios de CLISP. se es el foro
adecuado para cualquier cuestin relacionada con CLISP, problemas de
instalacin, errores, paquetes de aplicaciones, etc.
#endif
<<<There are three mailing lists for users of CLISP. You find subscription
information and archives on the homepage http://clisp.cons.org/.>>>


Agradecimientos:
----------------

#ifdef MSDOS
Si le parece que CLISP es rpido y sin errores y le gusta utilizarlo,
le agradeceremos una donacin de $25 (o cualquier cantidad que usted
considere oportuna). La mayor parte del software para DOS cuesta algo
de modo que, probablemente, ya estar acostumbrado a pagar.

En otro caso, envenos tantas sugerencias como considere para
mejorarlo. O chele un ojo a CLISP, mejrelo usted mismo y envenos
los parches.

#endif
Estamos muy agradecidos a 
  * Guy L. Steele y otros muchos por la especificacin de Common Lisp.
#ifdef UNIX
  * El proyecto GNU de Richard Stallman para el GCC, Autoconf y la librera
    readline.
#else
#ifdef GNU_READLINE
  * El proyecto GNU de Richard Stallman para el GCC y la librera readline.
#else
#ifdef GNU
  * El proyecto GNU de Richard Stallman para el GCC.
#endif
#endif
#endif
#ifdef EMUNIX
  * Eberhard Mattes por EMX.
#endif


Autores:
--------

        Bruno Haible
        Michael Stoll

Email: clisp-list@lists.sourceforge.net
#ifdef AMIGAOS

Migracin a Amiga por:
----------------------

        Jrg Hhle

Email: Joerg.Hoehle@gmd.de
#endif
#ifdef RISCOS

Migracin a Acorn RISC OS por:
------------------------------

        Peter Burwood

Email: clisp@arcangel.dircon.co.uk
#endif

"Mantenedor":
-------------

        Marcus Daniels

Email: marcus@sysc.pdx.edu
