/************************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>

/************************************************************/
/**** external function from diolib */
long	getpos();

/************************************************************/
/**** external function from supprt */
TEXT	*itob1(),*itob2(),*ltob3(),*ltob4();


/************************************************************/
/***** entry points */
long	proplist(),list(),text();
int	endlist(),endplist(),index(),integer(),name(),endtext();


/************************************************************/
/* This file contains routines to create the elementary data types of
the MM protocol (see RFC 767). There is one routine for each 
data type */
/* SOME DATA TYPES HAVE NOT BEEN IMPLEMENTED. THEY
SHOULD BE EASY TO CODE */

/************************************************************/
/* array containing type values for each type */
/* used to write out the type field on the output file. */
TINY	typtab[] = { TNOP,TPAD,TBOOL,TINDEX,TINT,TEXINT,TBITSTR,
		TNAME,TTEXT,TLIST,TPLIST,TELIST };

TEXT	zeros[]	=	{0,0,0,0,0};
TEXT	junk[]	=	{0,0,0,0,0};

/************************************************************/
/* creates proplist header. Count fields are set to zero. returns
address of begginning of data field */

long	proplist(fd)
FILE	fd;

{
dwrite(fd,typtab+TPLIST,1);
dwrite(fd,zeros,4);
return(getpos(fd));
}

/**************************************************/
/* creates list header. Count fields are set to zero. returns
address of begginning of data field */
long	list(fd)
FILE	fd;

{
dwrite(fd,typtab+TLIST,1);
dwrite(fd,zeros,5);
return(getpos(fd));
}

/**************************************************/
/* creates endlist element. Byte count and itemcnt fields
of the list are updated using bgnaddr, the address
of the data field of this list */

endlist(fd,bgnadr,itemcnt)
FILE	fd;
long	bgnadr;
int	itemcnt;

{
long	n,octcnt;

dwrite(fd,typtab+TELIST,1);
if (itemcnt > 0) {
	n=getpos(fd);
	octcnt=n-bgnadr+2;
	dlseek(fd,bgnadr-5,SEEKABS);
	dwrite(fd,ltob3(octcnt,junk),3);
	dwrite(fd,itob2(itemcnt,junk),2);
	dlseek(fd,n,SEEKABS);
	}
}

/**************************************************/
/* creates endlist element. Byte count and itemcnt fields
of the proplist are updated using bgnaddr, the address
of the data field of this proplist */

endplist(fd,bgnadr,pairs)
FILE	fd;
long	bgnadr;
int	pairs;

{
long	n,octcnt;

dwrite(fd,typtab+TELIST,1);
if ( pairs > 0) {
	n=getpos(fd);
	octcnt=n-bgnadr+1;
	dlseek(fd,bgnadr-4,SEEKABS);
	dwrite(fd,ltob3(octcnt,junk),3);
	dwrite(fd,itob1(pairs,junk),1);
	dlseek(fd,n,SEEKABS);
	}
}

/**************************************************/
/* creates index element of value n */

index(fd,n)
FILE	fd;
int	n;
{
dwrite(fd,typtab+TINDEX,1);
dwrite(fd,itob2(n,junk),2);
}

/**************************************************/
/* creates integer element of value (long) n */

integer(fd,n)
long	n;
FILE	fd;
{
dwrite(fd,typtab+TINT,1);
dwrite(fd,ltob4(n,junk),4);
}

/**************************************************/
/* creates name element with string s */
name(fd,s)
FILE	fd;
TEXT	*s;
{
int	n;

dwrite(fd,typtab+TNAME,1);
n = lenstr(s);
dwrite(fd,itob1(n,junk),1);
dwrite(fd,s,n);
}

/**************************************************/
/* creates text element header. returns address of
data field */

long	text(fd)
FILE	fd;
{
dwrite(fd,typtab+TTEXT,1);
dwrite(fd,zeros,3);

return(getpos(fd));
}

/**************************************************/
/* updates count field of text element at bgnaddr */

endtext(fd,bgnadr)
long	bgnadr;
FILE	fd;
{
long	n,octcnt;

n=getpos(fd);
octcnt=n-bgnadr;
dlseek(fd,bgnadr-3,SEEKABS);
dwrite(fd,ltob3(octcnt,junk),3);
dlseek(fd,n,SEEKABS);
}

/**************************************************/
/* creates header of bitstr element. returns address of
data field */

long	bitstr(fd)
FILE	fd;
{
dwrite(fd,typtab+TBITSTR,1);
dwrite(fd,zeros,3);
return(getpos(fd));
}

/**************************************************/
/* updates count field of bitstr starting at bgnadr */
endbitstr(fd,bgnadr)
long	bgnadr;
FILE	fd;
{
long	n,octcnt;

n=getpos(fd);
octcnt=n-bgnadr;
octcnt = octcnt * (long) 8;
dlseek(fd,bgnadr-3,SEEKABS);
dwrite(fd,ltob3(octcnt,junk),3);
dlseek(fd,n,SEEKABS);
}
                                                                                                     