/*********************************************************/
#include	<std.h>
#include	<rt11.h>
#include	<mmmhdr.h>


/************************************************************/
long	getpos();

/************************************************************/
/**** external functions from supprt */
int	b1toi(),b2toi();
long	b3tol(),b4tol();
int	putdec(),putldec();

/************************************************************/
/**** entry points */
int	intprnt();
int	gproplist(),glist(),gindex();
long	gint(),gtext(),gbitstr();
int	getitem();
TEXT	*gname();

/************************************************************/
TEXT	*typnamtab[]=
	{"nop:",
	"padding:",
	"bool:",
	"index:",
	"int:",
	"exint:",
	"bitstr:",
	"name:",
	"text:",
	"list:(",
	"proplist:(",
	")endlist," }

int	tabsiz = 0;
int	tabflag = 0;
int	dumpflag ;
TEXT	junk[];
TEXT	linbuf[];

/************************************************************/
intprnt()
{
tabflag=0;
tabsiz= -2;
}

/************************************************************/
gproplist(fd,octcnt)
FILE	fd;
long	*octcnt;

{
int	count;

dread(fd,junk,3);
*octcnt=b3tol(junk);
dread(fd,junk,1);
count = b1toi(junk) ;

if ( dumpflag ) {
	putstr(STDOUT,"{",NULL);
	putldec(*octcnt,",");
	putdec(count,"}");
}

return( count );
}

/**************************************************/
glist(fd,octcnt)
FILE	fd;
long	*octcnt;

{
int	count;

dread(fd,junk,3);
*octcnt=b3tol(junk);
dread(fd,junk,2);
count = b2toi(junk) ;

if ( dumpflag ) {
	putstr(STDOUT,"{",NULL);
	putldec(*octcnt,",");
	putdec(count,"}");
	}

return( count);
}

/**************************************************/
gindex(fd)
FILE	fd;
{
int	n;
dread(fd,junk,2);
n = b2toi(junk);
if ( dumpflag ) putdec(n,",");
return(n);
}

/**************************************************/
long	gint(fd)
FILE	fd;
{
long	n;

dread(fd,junk,4);
n = b4tol(junk);
if ( dumpflag ) putldec(n,",");
return(n);
}

/**************************************************/
getitem(fd)
FILE	fd;
{
int	n;
TEXT	c;

dread(fd,&c,1);
n=(int) c;

if ( dumpflag ) {
	if( (n == 9) || (n == 10) ){
		tabsiz += 2;
		puttab();
		putstr(STDOUT,typnamtab[n],NULL);
		tabsiz += 2;
		tabflag=0;
		}
	else if (n == 11) {
		tabsiz -= 2;
		puttab();
		putstr(STDOUT,typnamtab[n],NULL);
		tabsiz -= 2;
		tabflag=0;
		}
	else {
		if (tabflag == 0) {
			puttab();
			tabflag=1;
			}
		else	tabflag=0;
		putstr(STDOUT,typnamtab[n],NULL);
		}
	}

return(n);
}

/**************************************************/
TEXT	*gname(fd,s)
FILE	fd;
TEXT	*s;
{
int	n;

dread(fd,junk,1);
n = b1toi(junk);
dread(fd,s, n);
*(s+ n ) = NULL;
if ( dumpflag ) putstr(STDOUT, "'", s, "'", ",", NULL);
return(s);
}

/************************************************************/
long	gtext(fd,adr)
long	*adr;
FILE	fd;
{
long	n;
int	x;

dread(fd,junk,3);
n = b3tol(junk);
*adr = getpos(fd);

if ( dumpflag) {
	putldec(n,",");
	putstr(STDOUT, "'", NULL);
	}
for (x = (int) n; x > 0 ; x -= 50 ){
	if ( x >= 50 ) {
		dread(fd,linbuf,50);
		linbuf[50] = NULL;
		}
	else	{
		dread(fd,linbuf,x);
		linbuf[x] = NULL;
		}
	if ( dumpflag) putstr(STDOUT, linbuf, NULL);
	}

if ( dumpflag) putstr(STDOUT, "'", ",", NULL);
tabflag=0;
return(n);
}


/************************************************************/
long	gbitstr(fd,adr)
long	*adr;
FILE	fd;
{
long	nbits,nbyts,rem;

dread(fd,junk,3);
nbits = b3tol(junk);
*adr = getpos(fd);

rem = nbits % (long) 8;
nbyts = nbits / (long) 8;
if (rem > (long) 0) nbyts += (long) 1;

dlseek(fd,nbyts,SEEKREL);

if ( dumpflag) {
	putldec(nbits,",");
	tabflag=0;
	}
return(nbits);
}

/************************************************/
puttab()
{
TEXT	blankb[80];

putstr(STDOUT,"\n",flblank(tabsiz,blankb),NULL);
}
                                                                                                                                                                                  