(in-package "LAPIDARY" :use '("LISP" "KR"))

(defvar *test-p* NIL)

(defun draw-fct-do-go ()
  (draw-fct-do-stop)
(create-instance 'DRAW-FCT-WIN1 inter:interactor-window
   (:visible nil)
   (:title "draw functions")
   (:left (first *draw-fct-menu-dimensions*))
   (:top (second *draw-fct-menu-dimensions*))
   (:width (o-formula (+ 12 (gvl :aggregate :width))))
   (:height (fourth *draw-fct-menu-dimensions*)))
(s-value DRAW-FCT-WIN1 :aggregate (create-instance 'DRAW-FCT-AGG1 opal:aggregate))

(create-instance 'DRAW-FCT-PANEL1 garnet-gadgets:text-button-panel
   (:left 10) (:top 10)
   (:shadow-offset 5) (:gray-width 3)
   (:other-button (o-formula (car (last (g-value (gvl :text-button-list)
						    :components)))))
   (:items '(:copy :xor :and :or "other..."))
   (:width (formula `(+ (gvl :text-button-list :width)
			(gv DRAW-FCT-ARROW :width))))
   (:selection-function #'draw-fct-handler)
   (:parts
    `((:text-button-list
       :modify
       (:selected ,(o-formula 
		    (let ((value (gv (kr-path 0 :parent) :value)))
		      (if value
			  (nth (or (position value (gvl :items) :test #'equal)
				   4)
			       (g-value (gv :self) :components)))))))
      :final-feedback))
   (:interactors
    `((:text-button-press
        :modify
	(:start-action
	 (lambda (interactor obj)
	   (call-prototype-method interactor obj)
	   (inter:start-interactor (g-value DRAW-FCT-PANEL2 :text-button-press))
	   (when (equal obj (g-value DRAW-FCT-PANEL1 :other-button))
	     (s-value DRAW-FCT-WIN2 :visible T))))
	(:running-action
	 (lambda (interactor prev-obj new-obj)
;	   (format t "new-obj = ~S~%" new-obj)
	   (call-prototype-method interactor prev-obj new-obj)
	   (if (g-value DRAW-FCT-PANEL1 :other-button :interim-selected)
	       (s-value DRAW-FCT-WIN2 :visible T)
	       (s-value DRAW-FCT-WIN2 :visible NIL))))
	(:outside-action
	 (lambda (interactor outside-control prev-obj)
	   (if (equal prev-obj (g-value DRAW-FCT-PANEL1 :other-button))
	       (call-prototype-method interactor :last prev-obj)
	       (call-prototype-method interactor outside-control prev-obj))))
	(:back-inside-action
	 (lambda (interactor outside-control prev-obj new-obj)
	   (call-prototype-method interactor outside-control
				  prev-obj new-obj)))
	(:stop-action
	 (lambda (interactor final-obj)
	   (call-prototype-method interactor final-obj)
	   (s-value (g-value DRAW-FCT-PANEL1 :other-button) :interim-selected NIL)
	   (inter:abort-interactor (g-value DRAW-FCT-PANEL2 :text-button-press))))
	(:abort-action
	 (lambda (interactor final-obj)
	   (s-value DRAW-FCT-WIN2 :visible NIL)
	   (s-value (g-value DRAW-FCT-PANEL1 :other-button) :interim-selected NIL)
	   (inter:abort-interactor interactor)))))))
	   

(create-instance 'DRAW-FCT-ARROW opal:aggregadget
   (:other-button (o-formula (gv DRAW-FCT-PANEL1 :other-button)))
   (:from-x (o-formula (opal:gv-right (gvl :other-button))))
   (:width 20)
   (:height (o-formula (gvl :other-button :height)))
   (:max-text-width-thus-far (o-formula (gvl :prev-visible
					     :max-text-width-thus-far)))
   (:parts
    `((:arrowhead ,opal:arrowhead
		  (:from-x ,(o-formula (gvl :parent :from-x)))
		  (:from-y ,(o-formula (opal:gv-center-y
					(gvl :parent :other-button))))
		  (:head-x ,(o-formula (+ (gvl :from-x) 15)))
		  (:head-y ,(o-formula (gvl :from-y)))
		  (:filling-style ,opal:black-fill))
      (:rect ,opal:rectangle
	     (:left ,(o-formula (gvl :parent :from-x)))
	     (:top ,(o-formula (gvl :parent :other-button :top)))
	     (:width ,(o-formula (gvl :parent :width)))
	     (:height ,(o-formula (gvl :parent :height)))
	     (:line-style NIL)))))

;; make the initial selection be copy. first we must force the formula
;; in :value to be evaluated so that dependencies are set up
(g-value draw-fct-panel1 :value)
(s-value draw-fct-panel1 :value :copy)

(opal:add-components DRAW-FCT-AGG1 DRAW-FCT-PANEL1 DRAW-FCT-ARROW)
(opal:update DRAW-FCT-WIN1)

(create-instance 'DRAW-FCT-WIN2 inter:interactor-window
   (:left (o-formula (+ (gv DRAW-FCT-WIN1 :left) (gv DRAW-FCT-WIN1 :width))))
   (:top (o-formula (+ (gv DRAW-FCT-WIN1 :top)
		       (gv DRAW-FCT-PANEL1 :other-button :top))))
   (:width 133)
   (:height 495)
   (:visible NIL))

(s-value DRAW-FCT-WIN2 :aggregate (create-instance 'DRAW-FCT-AGG2 opal:aggregate))

(create-instance 'DRAW-FCT-PANEL2 garnet-gadgets:text-button-panel
   (:left 10) (:top 10)
   (:shadow-offset 5) (:gray-width 3)
   (:final-feedback-p t)
   (:items '(:clear :set :no-op :copy-inverted :invert :equiv :nand :nor
	     :and-inverted :and-reverse :or-inverted :or-reverse))
   (:selection-function #'draw-fct-handler)
   (:interactors
    `((:text-button-press
        :modify
	(:window (,DRAW-FCT-WIN1 ,DRAW-FCT-WIN2))
	(:abort-action
	 (lambda (interactor obj-over)
	   (call-prototype-method interactor obj-over)
	   (s-value DRAW-FCT-WIN2 :visible NIL)))
	(:stop-action
	 (lambda (interactor final-obj)
	   (let ((DRAW-FCT-PANEL1-inter (g-value DRAW-FCT-PANEL1 :text-button-press)))
	     (call-prototype-method interactor final-obj)
	     (s-value DRAW-FCT-WIN2 :visible NIL)
	     (kr-send DRAW-FCT-PANEL1-inter :final-function DRAW-FCT-PANEL1-inter final-obj)
	     (inter:abort-interactor DRAW-FCT-PANEL1-inter))))))))

(opal:add-component DRAW-FCT-AGG2 DRAW-FCT-PANEL2)
(opal:update DRAW-FCT-WIN2)

;; bind the menu items to global variables
(do ((buttons (g-value (g-value draw-fct-panel1 :components) :components)
	      (cdr buttons))
     (variables '(*df-copy* *df-xor* *df-and* *df-or* *df-other*)
		(cdr variables)))
    ((null buttons))
  (set (car variables) (car buttons)))

(do ((buttons (g-value (g-value draw-fct-panel2 :components) :components)
	      (cdr buttons))
     (variables '(*df-clear* *df-set* *df-no-op* *df-copy-inverted* *df-invert*
		  *df-equiv* *df-nand* *df-nor* *df-and-inverted* *df-and-reverse*
		  *df-or-inverted* *df-or-reverse*)
		(cdr variables)))
    ((null buttons))
  (set (car variables) (car buttons)))

)

(defun draw-fct-do-stop ()		  
  (when (boundp 'DRAW-FCT-WIN1) (opal:destroy DRAW-FCT-WIN1))
  (when (boundp 'DRAW-FCT-WIN2) (opal:destroy DRAW-FCT-WIN2)))
