#include "PixelShader.hpp"

#include "Vector.hpp"
#include "Point.hpp"
#include "Matrix.hpp"
#include "Error.hpp"

namespace swShader
{
	float4 PixelShader::c[32];

	void PixelShader::setFloatConstant(int index, const float value[4])
	{
		if(index < 0 || index >= 32) throw Error("Constant register index out of [0, 31] range: %d", index);

		c[index][0] = value[0];
		c[index][1] = value[1];
		c[index][2] = value[2];
		c[index][3] = value[3];
	}

	void PixelShader::setFloatConstant(int index, const Point &P)
	{
		if(index < 0 || index >= 32) throw Error("Constant register index out of [0, 31] range: %d", index);

		c[index][0] = P.x;
		c[index][1] = P.y;
		c[index][2] = P.z;
		c[index][3] = 1;
	}

	void PixelShader::setFloatConstant(int index, const Vector &V)
	{
		if(index < 0 || index >= 32) throw Error("Constant register index out of [0, 31] range: %d", index);

		c[index][0] = V.x;
		c[index][1] = V.y;
		c[index][2] = V.z;
		c[index][3] = 0;
	}

	void PixelShader::setFloatConstant(int index, const Matrix &M)
	{
		setFloatConstant(index + 0, M[0]);
		setFloatConstant(index + 1, M[1]);
		setFloatConstant(index + 2, M[2]);
		setFloatConstant(index + 3, M[3]);
	}
}