/* copyright 1989 by Phil Andrews, Pittsburgh Supercomputing Center */
/* all rights reserved */
#include <stdio.h>
#include "hload.h"
#include "defs.h"
#define END_FLAG 0

/* show a character */
static show_char(font_no, char_no)
int font_no, char_no;
{
int c_index, first_shift, second_shift, start_index;

	if (font_no >= NO_HF) return(0);

	printf("font %s, character %d\n", h_used[font_no], char_no);
	start_index = c_index = h_array[font_no][char_no];
	if (c_index < 0) return(0);

	while ((hf_array[c_index] != END_FLAG) ||
	    (hf_array[c_index+1] != END_FLAG)) {
	    printf("%d,", hf_array[c_index++]);
	    printf("%d,", hf_array[c_index++]);
	}
	first_shift = - (hf_array[start_index] - 128);
	second_shift = hf_array[start_index + 1] - 128;
	return(1);
}/* just a callable routine to tell CGM what to expect */
hl_check(font_size)
int *font_size;
{
	*font_size = 24;	/* this many pixels */
	return(PL_EMULATION);
}
/* set a text string as a series of polylines */
hl_text(x, y, instr, pline_call, a2, a5, no_chars,
capable, font_list, mag)
int x, y, (*pline_call)(), no_chars;
char *instr, *font_list;
long capable;
struct pic_d_struct *a2;	/* class 2 elements */
struct attrib_struct *a5;	/* class 5 elements */
double mag;
{
int i, char_no, font_no, c_index, str_height, str_width, xdelta, ydelta, x1,
y1;
double ctheta1, ctheta2, stheta1, stheta2;

	/* get font_no first */
	font_no = (a5->t_f_index - 1) % NO_HF;

	/* get the string height and width */
	dim_str(&str_height, &str_width, instr, no_chars, 
	    a5->text_path, a5->c_exp_fac, a5->c_space, font_no, mag);

	/* now figure out the angle for the baseline etc of the string */
	/* first establish defaults */
	ctheta1 = stheta2 = 1.0;
	stheta1 = ctheta2 = 0.0;
	/* now make the calls */
	angle_str(&ctheta1, &stheta1, a5->c_orient.y_base,a5->c_orient.x_base); 
	angle_str(&ctheta2, &stheta2, a5->c_orient.y_up, a5->c_orient.x_up); 

	/* now get the offset we will need */
	get_offsets(&xdelta, &ydelta, ctheta1, stheta1, ctheta2, stheta2,
	    &(a5->text_align), str_height, str_width, a5->text_path);

	/* add in the offsets */
	x += xdelta;
	y += ydelta;

	/* get the initial (small) offsets */
	xdelta = 0;
	ydelta = 0;
/* note bug in ULTRIX compiler; x1 = x += xdelta; is a no-op */

	for (i=0; i<no_chars; ++i) {
	    char_no = (int) instr[i];
	    /* now figure out how much we move */
	    /* first add in the character expansion factor and add. space */
	    xdelta = (int) (xdelta * a5->c_exp_fac) + a5->c_space;
	    /* now the geometric factors */
	    switch (a5->text_path) {
    case right :
		x += xdelta * ctheta1;
		x1 = x;
		y += xdelta * stheta1;
		y1 = y;
		break;
    case left :
		x -= xdelta * ctheta1;
		x1 = x;
		y -= xdelta * stheta1;
		y1 = y;
		break;
    case up :
		x += ydelta * ctheta2;
		x1 = x;
		y += ydelta * stheta2;
		y1 = y;
		break;
    case down :
		x -= ydelta * ctheta2;
		x1 = x;
		y -= ydelta * stheta2;
		y1 = y;
		break;
    default : fprintf(stderr, "illegal value (%d) for path\n", 
		(int) a5->text_path);
		x1 = x;
		y1 = y;
	    	break;
	    }
	    c_index = h_array[font_no][char_no];
	    if (c_index >= 0) 
		do_vecs(x1, y1, &xdelta, &ydelta, hf_array + c_index, 
		    pline_call, mag, ctheta1, stheta1, ctheta2, stheta2);
	}
	return(1);
}
/* read in the set of vectors, step forward right amount */
/* NOTE VAXC COMPILER BUG WITH EXPLICIT CASTS !!!! */
static do_vecs(x, y, xdelta, ydelta, hptr, pcall, mag, ctheta1, stheta1,
	ctheta2, stheta2)
int x, y, *xdelta, *ydelta;
unsigned char *hptr;
int (*pcall)();
double mag, ctheta1, stheta1, ctheta2, stheta2;
{
int first_shift, second_shift;
#define MAX_VECS 255	/* max no. of vectors */
int xvec[MAX_VECS], yvec[MAX_VECS], no_vecs;

	first_shift = 128 - *hptr++;
	first_shift *= mag;
	second_shift = *hptr++ - 128;
	second_shift *= mag;

	*ydelta = *xdelta = first_shift + second_shift;
	no_vecs = 0;
	if ((*hptr == END_FLAG) && (hptr[1] == END_FLAG)) return(0);

	/* get first point */
	xvec[no_vecs] = *hptr++ - 128;
	xvec[no_vecs] *= mag;
	xvec[no_vecs] += x + first_shift;

	yvec[no_vecs] = 128 - *hptr++;
	yvec[no_vecs] *= mag;
	yvec[no_vecs] += y;
/****	This screws up !
	yvec[no_vecs] = (int) (y - mag * (*hptr++ - 128));
****/
	++no_vecs;
	while ((*hptr != END_FLAG) || (hptr[1] != END_FLAG)) {
	    if ((*hptr == 0) && (hptr[1] == 128)) { /* pen coming up */
		if (no_vecs) send_vecs(no_vecs, xvec, yvec, x, y, 
		    pcall, ctheta1, stheta1, ctheta2, stheta2);
		hptr += 2;
		no_vecs = 0;
	    }
	    xvec[no_vecs] = *hptr++ - 128;
	    xvec[no_vecs] *= mag;
	    xvec[no_vecs] += x + first_shift;

	    yvec[no_vecs] = 128 - *hptr++;
	    yvec[no_vecs] *= mag;
	    yvec[no_vecs] += y;
	    ++no_vecs;
	}
	/* get the last one */
	if (no_vecs) send_vecs(no_vecs, xvec, yvec, x, y, 
	    pcall, ctheta1, stheta1, ctheta2, stheta2);

	return(1);
}
/* actually send the vectors out */
static send_vecs(no_vecs, xvec, yvec, x, y, pcall, ctheta1, stheta1, ctheta2,
    stheta2)
int no_vecs, *xvec, *yvec, x, y;
int (*pcall)();
double ctheta1, stheta1, ctheta2, stheta2;
{
int i, tvec;
	/* do any necessary rotations, about (x, y) */
	for (i=0; i<no_vecs; ++i) {
	    /* x component first */
	    tvec = xvec[i];
	    xvec[i] = x + (xvec[i] - x) * ctheta1 + (yvec[i] - y) * ctheta2;
	    yvec[i] = y + (yvec[i] - y) * stheta2 + (tvec - x) * stheta1;
	}
	(*pcall)(no_vecs, xvec, yvec);
	return(1);
}
/* function to figure out string dimension */
static dim_str(ht, wd, instr, no_chars, path, exp_fac, c_space, font_no, mag)
int *ht, *wd, no_chars;
char *instr;
enum path_enum path;
float exp_fac, c_space;
double mag;
{
int char_no, i, dw, first_shift, second_shift, tot_shift, c_index;
unsigned char *hptr;

	*ht = 0;
	*wd = 0;
	if (no_chars <= 0) return(1);

	    switch (path) {
case right:
case left:	
	    for (i=0; i < no_chars; ++i) {
	    	char_no = (int) *(instr + i) & 127;
		c_index = h_array[font_no][char_no];
		hptr = hf_array + c_index;
		first_shift = - (*hptr++ - 128);
		second_shift = *hptr++ - 128;
		*wd += (int) (mag * (first_shift + second_shift));
	    }
	    *ht = *wd / no_chars;	/* arbitrary */
	    break;
case up:
case down:
	    for (i=0; i < no_chars; ++i) {
	    	char_no = (int) *(instr + i) & 127;
		c_index = h_array[font_no][char_no];
		hptr = hf_array + c_index;
		first_shift = - (*hptr++ - 128);
		second_shift = *hptr++ - 128;
		tot_shift = (int) (mag * (first_shift + second_shift));
		if (*wd < tot_shift) *wd = tot_shift;
	    }
	    *ht = *wd * no_chars;	/* arbitrary */
	    break;
	}
	return(1);
}
