/* initial XUI interface */
#include <stdio.h>
/* system include files */
#ifdef VMS
#include <decw$include/Xlib.h>
#include <decw$include/DwtWidget.h>
#include <decw$include/DwtAppl.h>
#else
#include <X11/Xlib.h>
#include <X11/DwtWidget.h>
#include <X11/DwtAppl.h>
#endif
#ifdef VMS
#define OLD_DW 1
#else
#define OLD_DW 1
#endif
/* default sizes */
#define DEF_HT 512
#define DEF_WD 512
/* global window stuff */
extern Display *display_ptr; /* in xl.c */
extern Window window_id; /* in xl.c */
extern Window top_window_id; /* in xl.c */
#define BINARY_DEF "*.cgm"
#define CLEAR_DEF "*.cgmc"
static char *file_def = BINARY_DEF;

/* declare the widgets */
static Widget topLevel, main_window, menu_bar, file_menu, my_file,
  new_button, new_entry, quit_button, format_menu, format_option,
  next_button, binary_button, clear_text_button, draw_window, prev_button,
  redraw_button, caution_box;

static int n; /* argument counter */
static Arg arglist[10];	/* check that we don't need more */
static XWindowAttributes window_attributes; /* use to get window attributes */
static GC gc_id; /* graphical context */
static XGCValues values_struct; 
static Pixmap my_pixmap = NULL; /* pixmap for backig store */


/* forward declaration of callbacks */
static void Quit(Widget, Opaque, DwtAnyCallbackStruct*); /* quit, close up */
static void binary_set(Widget, Opaque, DwtAnyCallbackStruct*);
static void clear_set(Widget, Opaque, DwtAnyCallbackStruct*); 
static void get_file_name(Widget, Opaque, DwtAnyCallbackStruct*);
static void next_picture(Widget, Opaque, DwtAnyCallbackStruct*);
static void redraw_picture(Widget, Opaque, DwtAnyCallbackStruct*);
static void prev_picture(Widget, Opaque, DwtAnyCallbackStruct*);
/* expose callback */
static void expose_window(Widget, Opaque, DwtWindowCallbackStruct*);
/* file selection callbacks */
static void in_file_ok(Widget, Opaque, DwtFileSelectionCallbackStruct*); 
static void in_file_cancel(Widget, Opaque, DwtFileSelectionCallbackStruct*); 
static void in_file_help(Widget, Opaque, DwtFileSelectionCallbackStruct*); 
/* a few statics */
static unsigned int old_wd = 0, old_ht = 0;
#define BINARY_FORMAT 0
#define CLEAR_FORMAT 1
static int cgm_format, file_open;
/* interface to wint.c */
extern int wint_initialise();
extern int wopen_file();
extern int wdraw_next_page();
/* interface to the device */
#ifdef incxws
/* want xws driver */
extern xws_setup();		/* in xws.c */
extern xws_end(); /* in xl.c */
#define X_SETUP xws_setup
#define X_END xws_end
#else
/* default to xl driver */
extern xl_setup();		/* in xl.c */
extern xl_end(); /* in xl.c */
#define X_SETUP xl_setup
#define X_END xl_end
#endif

/* now the main program */
main(argc, argv)
     int argc;
     char **argv;
{
  /* get things initialised */

  if (!wint_initialise(argc, argv)) exit(0);

  topLevel = XtInitialize(argv[0], "Gplot", NULL, 0, &argc, argv);
  
  make_main_window(); /* make the main window */
  
  make_draw_window(); /* make the drawing window */
  
  make_menu_system(); /* make all of the options */
  
  XtRealizeWidget(topLevel); /* realise the system */
  display_ptr = XtDisplay(draw_window); /* store window specifics */
  window_id = XtWindow(draw_window);
  top_window_id = XtWindow(topLevel);
	
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    fprintf(stderr, "couldn't get attributes\n");
    return;
  }
  old_wd = window_attributes.width;
  old_ht = window_attributes.height;
  /* get the default graphics context */
  gc_id = XCreateGC(display_ptr, window_id, 0, &values_struct);


  XtMainLoop(); /* enter main loop */
  
  return(0); /* never reached */
  
}
/* Callbacks */

/* get the new file name */
static void get_file_name(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  Widget my_file;
  
  /* create and manage the input file menu entry */
  n = 0;
  XtSetArg(arglist[n], DwtNtitle, DwtLatin1String("Input File")); ++n;
  XtSetArg(arglist[n], DwtNdirMask, DwtLatin1String(file_def)); ++n;
  XtSetArg(arglist[n], DwtNdirSpec, DwtLatin1String("/tmp")); ++n;
  my_file = DwtFileSelectionCreate(w, "my_file", arglist, n);

  /* add callbacks */
  XtAddCallback(my_file, DwtNactivateCallback, in_file_ok, 0);
  XtAddCallback(my_file, DwtNcancelCallback, in_file_cancel, 0);
  XtAddCallback(my_file, DwtNhelpCallback, in_file_help, 0);
  
  XtManageChild(my_file);
}
/* the Quit callback */
static void Quit(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  /* close up the device */
  X_END(0);
  exit(0);
}
/* the Binary callback */
static void binary_set(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  cgm_format = BINARY_FORMAT;
  file_def = BINARY_DEF;
}
/* the Clear callback */
static void clear_set(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  cgm_format = CLEAR_FORMAT;
  file_def = CLEAR_DEF;
}
/* picture callbacks */
static void next_picture(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(0);
}
static void redraw_picture(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(-1);
}
static void prev_picture(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtAnyCallbackStruct *call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(-2);
}
/* file selection callbacks */
static void in_file_ok(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtFileSelectionCallbackStruct *call_data;
{
  DwtCompStringContext context;
  char *result;
  long status, charset, direction, lang, rend;
  unsigned int win_wd, win_ht, win_depth;
  
#ifdef OLD_DW
  status = DwtInitGetSegment(&context, call_data->value);
#else
  status = DwtStringInitContext(&context, call_data->value);
#endif
  if (status != DwtSuccess) {
    fprintf(stderr, "cannot initialise context\n");
    return;
  }
  /* assume a single segment */
  status = DwtGetNextSegment(&context, &result, &charset,
			     &direction, &lang, &rend);
  
#ifndef OLD_DW
  /* free up context */
  DwtStringFreeContext(&context);
#endif
  XtUnmanageChild(w);
  file_open = wopen_file(result, cgm_format, X_SETUP);
  if (file_open) { /* must save new image */
    /* find out our size */
    if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
      fprintf(stderr, "couldn't get attributes\n");
      return;
    }
    
    win_wd = window_attributes.width;
    win_ht = window_attributes.height;
    win_depth = window_attributes.depth;    
    if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
      /* need a new pixmap */
      if (my_pixmap) XFreePixmap(display_ptr, my_pixmap);
      my_pixmap = XCreatePixmap(display_ptr, window_id,
				win_wd, win_ht, win_depth);
      old_ht = win_ht;
      old_wd = win_wd;
    }
    
    /* now copy over the image */
    if (my_pixmap) XCopyArea(display_ptr, window_id, my_pixmap, gc_id,
			     0, 0, win_wd, win_ht, 0, 0);
  }
}
static void in_file_cancel(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtFileSelectionCallbackStruct *call_data;
{
  XtUnmanageChild(w);
}
static void in_file_help(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtFileSelectionCallbackStruct *call_data;
{
}
/* the expose callback */
static void expose_window(w, tag, call_data)
     Widget w;
     Opaque tag;
     DwtWindowCallbackStruct * call_data;
{
  unsigned int win_wd, win_ht, win_depth;
  
  if (!file_open) return; /* nothing to show */

  /* see if we changed size */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    fprintf(stderr, "couldn't get attributes\n");
    return;
  }

  win_wd = window_attributes.width;
  win_ht = window_attributes.height;
  win_depth = window_attributes.depth;
  
  if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
    /* draw the picture */
    draw_picture(-1);
    old_wd = win_wd;
    old_ht = win_ht;
  } else { /* can use stored image */
    if (my_pixmap) XCopyArea(display_ptr, my_pixmap, window_id, gc_id,
			      0, 0, win_wd, win_ht, 0, 0);
  }
  
}
static int draw_picture(page_shift)
     int page_shift;
{
  unsigned int win_wd, win_ht, win_depth;
  /* find out our size */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    fprintf(stderr, "couldn't get attributes\n");
    return;
  }

  win_wd = window_attributes.width;
  win_ht = window_attributes.height;
  win_depth = window_attributes.depth;

  if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
    /* need a new pixmap */
    if (my_pixmap) XFreePixmap(display_ptr, my_pixmap);
    my_pixmap = XCreatePixmap(display_ptr, window_id,
			      win_wd, win_ht, win_depth);
    old_ht = win_ht;
    old_wd = win_wd;
  }

  wdraw_next_page(page_shift);
  /* now copy over the image */
  if (my_pixmap) XCopyArea(display_ptr, window_id, my_pixmap, gc_id,
	    0, 0, win_wd, win_ht, 0, 0);
  return(1);
}
static int make_main_window()
{
  /* create and manage the main window */
  n = 0;
  XtSetArg(arglist[n], DwtNwidth, DEF_WD); ++n;
  XtSetArg(arglist[n], DwtNheight, DEF_HT); ++n;
  main_window = DwtMainWindowCreate(topLevel, "Main Window", arglist, n);
  XtManageChild(main_window);
  return(1);
}
static int make_draw_window()
{
  /* create and manage the drawing window */
  n = 0;
  XtSetArg(arglist[n], DwtNwidth, DEF_WD); ++n;
  XtSetArg(arglist[n], DwtNheight, DEF_HT); ++n;
  draw_window = DwtWindowCreate(main_window, "Draw Window", arglist, n);
  /* add a callback */
  XtAddCallback(draw_window, DwtNexposeCallback, expose_window, 0);
  XtManageChild(draw_window);
  return(1);
}
static int make_menu_system()
{
  /* create the menu bar */
  menu_bar = DwtMenuBar(main_window, "Menu Bar", NULL, NULL);
  
  /* create the File pulldown menu */
  n = 0;
  file_menu = DwtMenuPulldownCreate(menu_bar, "File", arglist, n);
  
  /* now make it some children */
  /* add the Open File Button */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Open File")); ++n;
  new_button = DwtPushButtonCreate(file_menu, "New Button",
				   arglist, n);
  /* give it a callback */
  XtAddCallback(new_button, DwtNactivateCallback, get_file_name, 0);
  
  /* add the quit button */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Quit")); ++n;
  quit_button = DwtPushButtonCreate(file_menu, "Quit Button",
				    arglist, n);
  /* give it a callback */
  XtAddCallback(quit_button, DwtNactivateCallback, Quit, 0);
  
  /* make menu entries */
  n = 0;
  XtSetArg(arglist[n], DwtNsubMenuId, file_menu); ++n;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("File")); ++n;
  new_entry = DwtPullDownMenuEntryCreate(menu_bar, "New Entry",
					 arglist,  n);
  /* manage the children */
  XtManageChild(new_button);
  XtManageChild(quit_button);
  XtManageChild(new_entry);
  
  /* add the format options */
  /* first the menu */
  n = 0;
  format_menu = DwtMenuPulldownCreate(file_menu, "Format Menu",
				      arglist, n);
  /* now the possibilities */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Binary")); ++n;
  binary_button = DwtPushButtonCreate(format_menu, "Binary Button",
				      arglist, n);
  /* give it a callback */
  XtAddCallback(binary_button, DwtNactivateCallback, binary_set, 0);

  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Clear Text")); ++n;
  clear_text_button = DwtPushButtonCreate(format_menu, "Clear Text Button",
					  arglist, n);
  /* give it a callback */
  XtAddCallback(clear_text_button, DwtNactivateCallback, clear_set, 0);

  /* manage the children */
  XtManageChild(binary_button);
  XtManageChild(clear_text_button);
  
  /* now the options */
  n = 0;
  XtSetArg(arglist[n], DwtNsubMenuId, format_menu); ++n;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Format: ")); ++n;
  XtSetArg(arglist[n], DwtNmenuHistory, binary_button); ++n;
  format_option = DwtOptionMenuCreate(menu_bar, "Format Options",
				      arglist, n);
  XtManageChild(format_option);
  
  
  /* create and manage the next picture button */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Next Pic")); ++n;
  next_button = DwtPushButtonCreate(menu_bar, "Next Button",
				    arglist, n);
  /* add a callback */
  XtAddCallback(next_button, DwtNactivateCallback, next_picture, 0);
  XtManageChild(next_button);

  /* create and manage the redraw button */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Redraw")); ++n;
  redraw_button = DwtPushButtonCreate(menu_bar, "Redraw Button",
				    arglist, n);
  /* add a callback */
  XtAddCallback(redraw_button, DwtNactivateCallback, redraw_picture, 0);
  XtManageChild(redraw_button);

  /* create and manage the previous picture button */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String("Prev Pic")); ++n;
  prev_button = DwtPushButtonCreate(menu_bar, "Prev Button",
				    arglist, n);
  /* add a callback */
  XtAddCallback(prev_button, DwtNactivateCallback, prev_picture, 0);
  XtManageChild(prev_button);
  
  /* manage the menu bar */
  XtManageChild(menu_bar);
  return(1);
}
/* routine to handle error messages */
void info_error(instr)
char *instr;
{
  /* create and manage the caution box widget */
  n = 0;
  XtSetArg(arglist[n], DwtNlabel, DwtLatin1String(instr)); ++n;
  XtSetArg(arglist[n], DwtNyesLabel, DwtLatin1String("Acknowledged")); ++n;
  XtSetArg(arglist[n], DwtNnoLabel, DwtLatin1String("Quit")); ++n;
  XtSetArg(arglist[n], DwtNcancelLabel, DwtLatin1String("")); ++n;
  XtSetArg(arglist[n], DwtNdefaultPushbutton, DwtYesButton); ++n;
  XtSetArg(arglist[n], DwtNdefaultPosition, True); ++n;
  caution_box = DwtCautionBoxCreate(menu_bar, "Caution Box",
				    arglist, n);
  /* add a callback */
  XtAddCallback(caution_box, DwtNnoCallback, Quit, 0);
  XtManageChild(caution_box);
}
