/* test of Xtoolkit availability */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#ifdef R3_INTRINSICS	/* X11R3 specifics */
#include <X11/Label.h>
#include <X11/Command.h>
#include <X11/Box.h>
#include <X11/Shell.h>
#include <X11/Dialog.h>
#else			/* X11R4 or later */
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Shell.h>
#include <X11/Xaw/Dialog.h>
#endif

/* default sizes */
#define DEF_HT 512
#define DEF_WD 512
/* global window stuff */
extern Display *display_ptr; /* in xl.c */
extern Window window_id; /* in xl.c */
extern Window top_window_id; /* in xl.c */
/* callbacks */
static void Quit();
static void in_file_ok();
static void cancel();
static void info_cancel();
static void expose_window();
static void get_file_name();
static void change_format();
static void next_picture();
static void redraw_picture();
static void prev_picture();
/* a few statics */
static unsigned int old_wd = 0, old_ht = 0;
#define BINARY_FORMAT 0
#define CLEAR_FORMAT 1
static int cgm_format = BINARY_FORMAT, file_open, draw_picture();
/* declare the widgets */
static Widget topLevel, main_window, menu_bar, file_menu, my_file,
  new_button, new_entry, quit_button, format_button, format_option,
  next_button, binary_button, clear_text_button, draw_window, prev_button,
  redraw_button, caution_box, pshell, ishell, dialog, dialogDone,
  cancel_button, info_label, info_acknowledged, info_quit, info_box;

static int n; /* argument counter */
static Arg arglist[10];	/* check that we don't need more */
static XWindowAttributes window_attributes; /* use to get window attributes */
static GC gc_id; /* graphical context */
static XGCValues values_struct; 
static Pixmap my_pixmap = NULL; /* pixmap for backing store */
/* interface to wint.c */
extern int wint_initialise();
extern int wopen_file();
extern int wdraw_next_page();
/* interface to the device */
#ifdef incxws
/* want xws driver */
extern xws_setup();		/* in xws.c */
extern xws_end(); /* in xl.c */
#define X_SETUP xws_setup
#define X_END xws_end
#else
/* default to xl driver */
extern xl_setup();		/* in xl.c */
extern xl_end(); /* in xl.c */
#define X_SETUP xl_setup
#define X_END xl_end
#endif

/* routine to handle error messages */
void info_error(instr)
char *instr;
{
  Position x, y;
  Dimension width, height;
  /* figure out where to go */
  n = 0;
  XtSetArg(arglist[n], XtNwidth, &width); ++n;
  XtSetArg(arglist[n], XtNheight, &height); ++n;
  XtGetValues(topLevel, arglist, n);
  XtTranslateCoords(topLevel, (Position) width/4, (Position) height/2,
		    &x, &y);
  n = 0;
  XtSetArg(arglist[n], XtNx, x); ++n;
  XtSetArg(arglist[n], XtNy, y); ++n;
  XtSetValues(ishell, arglist, n);

  n = 0;
  XtSetArg(arglist[n], XtNlabel, instr); ++n;

  XtSetValues(info_label, arglist, n);

  /* pop up a label box */
  XtPopup(ishell, XtGrabNonexclusive);

}
/* main routine */
main(argc, argv)
     int argc;
     char **argv;
{
  /* get things initialised */

  if (!wint_initialise(argc, argv)) exit(0);

  n = 0;
  XtSetArg(arglist[n], XtNallowShellResize, TRUE); ++n;
  topLevel = XtInitialize(argv[0], "Gplot", arglist, n, &argc, argv);
  
  make_main_window(); /* make the main window */
  
  make_menu_system(); /* make all of the options */

  make_draw_window(); /* make the drawing window */
 
  XtRealizeWidget(topLevel); /* realise the system */
  display_ptr = XtDisplay(draw_window); /* store window specifics */
  window_id = XtWindow(draw_window);
  top_window_id = XtWindow(topLevel);

  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    info_error("couldn't get attributes");
  }
  old_wd = window_attributes.width;
  old_ht = window_attributes.height;
  /* get the default graphics context */
  gc_id = XCreateGC(display_ptr, window_id, 0, &values_struct);


  XtMainLoop();

}
  
make_main_window()
{
  /* create and manage the main window */
  n = 0;
  main_window = XtCreateManagedWidget("Main Window", formWidgetClass,
				      topLevel, arglist, n);
  return(1);
}
make_draw_window()
{
  /* create and manage the drawing window */
  n = 0;
  XtSetArg(arglist[n], XtNwidth, DEF_WD); ++n;
  XtSetArg(arglist[n], XtNheight, DEF_HT); ++n;
  draw_window = XtCreateManagedWidget("Draw Window",
				      boxWidgetClass,
				      main_window,
				      arglist, n);
  /* add the expose event handler */
  XtAddEventHandler(draw_window, ExposureMask, FALSE, expose_window,
		    (Opaque) NULL);
  return(1);
}
make_menu_system()
{
  n = 0;
  XtSetArg(arglist[n], XtNwidth, DEF_WD); ++n;
  menu_bar = XtCreateManagedWidget("Menu Bar", boxWidgetClass,
				   main_window, arglist, n);
  /* now the quit button */
  n = 0;
  quit_button = XtCreateManagedWidget("Quit", commandWidgetClass,
				      menu_bar, arglist, n);
  XtAddCallback(quit_button, XtNcallback, Quit, 0);
  n = 0;  /* now the file button */
  my_file = XtCreateManagedWidget("File", commandWidgetClass,
				      menu_bar, arglist, n);
  XtAddCallback(my_file, XtNcallback, get_file_name, 0);

  n = 0;  /* now the next picture button */
  next_button = XtCreateManagedWidget("Next Pic", commandWidgetClass,
				      menu_bar, arglist, n);
  XtAddCallback(next_button, XtNcallback, next_picture, 0);
  n = 0;  /* now the previous picture button */
  prev_button = XtCreateManagedWidget("Prev Pic", commandWidgetClass,
				      menu_bar, arglist, n);
  XtAddCallback(prev_button, XtNcallback, prev_picture, 0);
  n = 0;  /* now the redraw button */
  redraw_button = XtCreateManagedWidget("Redraw", commandWidgetClass,
				      menu_bar, arglist, n);
  XtAddCallback(redraw_button, XtNcallback, redraw_picture, 0);

  n = 0; /* prepare for popup dialogue */
  XtSetArg(arglist[n], XtNinput, TRUE); ++n;
  XtSetArg(arglist[n], XtNtitle, "Open"); ++n;
  pshell = XtCreatePopupShell("pshell", transientShellWidgetClass,
			      topLevel, arglist, n);
  n = 0; /* dialog widget */
  XtSetArg(arglist[n], XtNlabel, "File Name:           "); ++n;
  XtSetArg(arglist[n], XtNmaximumLength, 40); ++n;
  XtSetArg(arglist[n], XtNsensitive, TRUE); ++n;
  XtSetArg(arglist[n], XtNvalue, ""); ++n;
  dialog = XtCreateManagedWidget("dialog", dialogWidgetClass,
				 pshell, arglist, n);
  n = 0; /* when we're done */
  XtSetArg(arglist[n], XtNlabel, "Open "); ++n;
  dialogDone = XtCreateManagedWidget("dialogDone", commandWidgetClass,
				 dialog, arglist, n);
  /* add the callbacks */
  XtAddCallback(dialogDone, XtNcallback, in_file_ok, 0);

  n = 0; /* cancel */
  XtSetArg(arglist[n], XtNlabel, "Cancel "); ++n;
  cancel_button = XtCreateManagedWidget("Cancel Button", commandWidgetClass,
				 dialog, arglist, n);
  /* add the callbacks */
  XtAddCallback(cancel_button, XtNcallback, cancel, 0);

  n = 0; /* format button */
  XtSetArg(arglist[n], XtNlabel, "Format: Binary "); ++n;
  format_button = XtCreateManagedWidget("Format Button", commandWidgetClass,
				 dialog, arglist, n);
  /* add the callbacks */
  XtAddCallback(format_button, XtNcallback, change_format, 0);

  /* now the info_error stuff */
  n = 0; /* prepare for popup dialogue */
  XtSetArg(arglist[n], XtNtitle, "Warning"); ++n;
  ishell = XtCreatePopupShell("ishell", transientShellWidgetClass,
			      topLevel, arglist, n);  n = 0; /* box widget */
  info_box = XtCreateManagedWidget("info label", boxWidgetClass,
				 ishell, arglist, n);
  n = 0; /* label widget */
  info_label = XtCreateManagedWidget("info label", labelWidgetClass,
		 info_box, arglist, n);
  n = 0; /* when we're done */
  XtSetArg(arglist[n], XtNlabel, "Acknowledged                   "); ++n;
  info_acknowledged = XtCreateManagedWidget("Info Acknowledged",
					    commandWidgetClass,
					    info_box, arglist, n);
  /* add the callbacks */
  XtAddCallback(info_acknowledged, XtNcallback, info_cancel, 0);

  n = 0; /* when we're done */
  XtSetArg(arglist[n], XtNlabel, "Quit"); ++n;
  info_quit = XtCreateManagedWidget("Info Quit",
				    commandWidgetClass,
				    info_box, arglist, n);
  /* add the callbacks */
  XtAddCallback(info_quit, XtNcallback, Quit, 0);



  return(1);
}

/* callbacks */
/* the Quit callback */
static void Quit(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  /* close up the device */
  X_END(0);
  exit(0);
}
/* the File callback */
static void get_file_name(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  Position x, y;
  Dimension width, height;
  /* figure out where to go */
  n = 0;
  XtSetArg(arglist[n], XtNwidth, &width); ++n;
  XtSetArg(arglist[n], XtNheight, &height); ++n;
  XtGetValues(topLevel, arglist, n);
  XtTranslateCoords(topLevel, (Position) width/4, (Position) height/2,
		    &x, &y);
  n = 0;
  XtSetArg(arglist[n], XtNx, x); ++n;
  XtSetArg(arglist[n], XtNy, y); ++n;
  XtSetValues(pshell, arglist, n);
  /* pop up a dialog box */
  XtSetSensitive(my_file, FALSE);
  XtPopup(pshell, XtGrabNonexclusive);

}
/* selected a file */
static void in_file_ok(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  int win_wd, win_ht, win_depth;
  char *result;
  XtPopdown(pshell);
  XtSetSensitive(my_file, TRUE);
  /* get the file name */
#ifdef R3_INTRINSICS   
  result = XtDialogGetValueString(dialog);
#else
  result = XawDialogGetValueString(dialog);
#endif
  if (!result) {
    info_error("no file specified");
    return;
  }

  file_open = wopen_file(result, cgm_format, X_SETUP);
  if (file_open) { /* must save new image */
    /* find out our size */
    if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
      info_error("couldn't get attributes\n");
      return;
    }
    
    win_wd = window_attributes.width;
    win_ht = window_attributes.height;
    win_depth = window_attributes.depth;    
    if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
      /* need a new pixmap */
      if (my_pixmap) XFreePixmap(display_ptr, my_pixmap);
      my_pixmap = XCreatePixmap(display_ptr, window_id,
				win_wd, win_ht, win_depth);
      old_ht = win_ht;
      old_wd = win_wd;
    }
    
    /* now copy over the image */
    if (my_pixmap) XCopyArea(display_ptr, window_id, my_pixmap, gc_id,
			     0, 0, win_wd, win_ht, 0, 0);
  }
}
/* cancel selecting a file */
static void cancel(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  XtPopdown(pshell);
  XtSetSensitive(my_file, TRUE);
}
/* terminate info  */
static void info_cancel(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  XtPopdown(ishell);
}
/* the change format callback */
static void change_format(w, tag, call_data)
     Widget w;
     caddr_t tag;
{
  if (cgm_format == CLEAR_FORMAT) {
    cgm_format = BINARY_FORMAT;
    n = 0; /* format button */
    XtSetArg(arglist[n], XtNlabel, "Format: Binary "); ++n;
    XtSetValues(format_button, arglist, n);
  } else if (cgm_format == BINARY_FORMAT) {
    cgm_format = CLEAR_FORMAT;
    n = 0; /* format button */
    XtSetArg(arglist[n], XtNlabel, "Format: Clear "); ++n;
    XtSetValues(format_button, arglist, n);
  }
}
/* picture callbacks */
static void next_picture(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(0);
}
static void redraw_picture(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(-1);
}
static void prev_picture(w, tag, call_data)
     Widget w;
     caddr_t tag;
     caddr_t call_data;
{
  if (!file_open) return; /* do nothing */
  draw_picture(-2);

}
static int draw_picture(page_shift)
     int page_shift;
{
  unsigned int win_wd, win_ht, win_depth;
  /* find out our size */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    info_error("couldn't get attributes\n");
    return;
  }

  win_wd = window_attributes.width;
  win_ht = window_attributes.height;
  win_depth = window_attributes.depth;

  if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
    /* need a new pixmap */
    if (my_pixmap) XFreePixmap(display_ptr, my_pixmap);
    my_pixmap = XCreatePixmap(display_ptr, window_id,
			      win_wd, win_ht, win_depth);
    old_ht = win_ht;
    old_wd = win_wd;
  }

  wdraw_next_page(page_shift);
  /* now copy over the image */
  if (my_pixmap) XCopyArea(display_ptr, window_id, my_pixmap, gc_id,
	    0, 0, win_wd, win_ht, 0, 0);
  return(1);
}
/* the expose callback */
static void expose_window(w, event, region)
     Widget w;
     XEvent *event;
     Region region;
{
  unsigned int win_wd, win_ht, win_depth;
  
  if (!file_open) return; /* nothing to show */

  /* see if we changed size */
  if (!XGetWindowAttributes(display_ptr, window_id, &window_attributes)){
    info_error("couldn't get window attributes\n");
    return;
  }

  win_wd = window_attributes.width;
  win_ht = window_attributes.height;
  win_depth = window_attributes.depth;
  
  if ((old_wd != win_wd) || (old_ht != win_ht) || !my_pixmap) {
    /* draw the picture */
    draw_picture(-1);
    old_wd = win_wd;
    old_ht = win_ht;
  } else { /* can use stored image */
    if (my_pixmap) XCopyArea(display_ptr, my_pixmap, window_id, gc_id,
			      0, 0, win_wd, win_ht, 0, 0);
  }
  
}
