#include <stdio.h>
#include <ctype.h>
#include "defs.h"
  /* this module contains one function, dev_setup, which is called by the main
     gplot modules at startup time. It is the only existing piece of code
     which must be modified to add a new device driver */
  /* here is the common argument list for all of these routines */
#define arg_list opt, dev_info, c1, c2, c3, c5, delim, mfdesc, pdesc, mfctrl, \
  gprim, attr, escfun, extfun, ctrl, pargc, argv
  
  int dev_setup(arg_list)
struct one_opt *opt;	/* the command line options, in only */
struct info_struct *dev_info;	/* device info to fill out, out only */
struct mf_d_struct 	*c1;	/* the class 1 elements, in only */
struct pic_d_struct 	*c2;	/* the class 2 elements, in only */
struct control_struct	*c3;	/* the class 3 elements, in only */
struct attrib_struct	*c5;	/* the class 5 elements, in only */
int (*delim[])();	/* delimiter functions */
int (*mfdesc[])();	/* metafile descriptor functions */
int (*pdesc[])();	/* page descriptor functions */
int (*mfctrl[])();	/* controller functions */
int (*ctrl[])();	/* controller functions */
int (*gprim[])();	/* graphical primitives */
int (*attr[])();	/* the attribute functions */
int (*escfun[])();	/* the escape functions */
int (*extfun[])();	/* the external functions */
int *pargc;			/* pointer to argc */
char **argv;			/* the main argv */	
{
#define dev_length 20	/* maximum device name length */
  static char dev_name[dev_length + 1], buffer[dev_length + 1];
  int i;
  
  	/* first check if we are using a controller */
  if (opt[(int) tty].set || opt[(int) screen].set) {
#ifdef inctty
    tty_ctrl(ctrl, opt);
#else
    (void) fprintf(stderr, "tty controller not loaded\n");
#endif
  }
  if (opt[(int) diaquest].set) {
#ifdef incdq
    dq_ctrl(ctrl, opt);
#else
    (void) fprintf(stderr, "diaquest controller not loaded\n");
#endif

  }
  if (opt[(int) lvr].set) {
#ifdef inclvr
    lvr_ctrl(ctrl, opt);
#else
    (void) fprintf(stderr, "Laser Video (lvr) controller not loaded\n");
#endif

  }
  
  /* now see if we asked for a device */
  if (opt[(int) device].set) 
    strncpy(dev_name, opt[(int) device].val.str, dev_length);
  else if (opt[(int) screen].set) 
    if (!strlen(opt[(int) screen].val.str)) /* default to tektronix */
      strncpy(dev_name, "tek4010", dev_length);
    else strncpy(dev_name, opt[(int) screen].val.str, dev_length);
  else {		/* no device set, listing only */
    dev_info->pxl_in = 1.0;
    dev_info->ypxl_in = 1.0;
    dev_info->x_size = 3276.0;
    dev_info->y_size = 3276.0;
    dev_info->x_offset = 0.0;
    dev_info->y_offset = 0.0;
    *dev_info->out_name = '\0';	/* no output file */
    dev_info->capability = 0;
    dev_info->rec_size = 80;
    return(1);
  }
  /* so we actually have a device requested, now need to figure out who to call*/
  
  dev_name[dev_length] = '\0';	/* for safety */
  
  /* let's convert to lower case */	
  
  for (i=0; i<strlen(dev_name); ++i) 
    dev_name[i] = (isupper(dev_name[i])) ? tolower(dev_name[i]):
      dev_name[i];
  
  /* and go check to see if we know it */
  /* for compatibility with earlier versions: */
  if (dev_name[0] == '4') {	/* old tektronix form */
    strcpy(buffer, dev_name);
    sprintf(dev_name, "tek%s", buffer);
  }
  
  /* before talking to devices, we'll send all the pointers to the
     emulation package */
  em_setup(arg_list);
  
  /* first real device is postscript */
  if (0 == strncmp(dev_name, "ps", 2)) {	/* anything beginning w "ps" */
#ifdef incps
    ps_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device ps not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now tektronix */
  if (0 == strncmp(dev_name, "tek", 3)) {	/* anything beginning "tek" */
#ifdef inctek
    tek_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device tek not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  	/* now the UIS workstation software for the vms workstations */
  if (0 == strncmp(dev_name, "uis", 3)) {	/* anything beginning "uis" */
#ifdef incuis
    uis_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device uis not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* the peritek frame buffer device */
  if (0 == strncmp(dev_name, "peritek", 7)) {
#ifdef incpk
    pk_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device peritek not loaded, asked for %s\n",
		   dev_name);
    return(0);
#endif
  }
  /* now Joel's GKS stuff */
  if (0 == strncmp(dev_name, "gks", 3)) {	/* anything beginning "gks" */
#ifdef incgks
    gks_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device gks not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now QUIC (QMS) */
  if (0 == strncmp(dev_name, "qms", 3)) {	/* anything beginning w "qms" */
#ifdef incqms
    qms_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device qms not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now EXCL (TALARIS) */
  if (0 == strncmp(dev_name, "excl", 4)) {/* anything beginning excl */
#ifdef incexcl
    excl_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device excl not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now IGL (IRIS GL) */
  if (0 == strncmp(dev_name, "igl", 3)) {	/* anything beginning "igl" */
#ifdef incigl
    igl_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device igl not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now SV (SunView) */
  if (0 == strncmp(dev_name, "sv", 2)) {	/* anything beginning "sv" */
#ifdef incsv
    sv_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device sv not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now XL (XLIB) */
  if (0 == strncmp(dev_name, "xl", 2)) {	/* anything beginning "xl" */
#ifdef incxl
    xl_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device xl not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
/* now X Window system */
  if (0 == strncmp(dev_name, "x", 1)) { /* anything beginning with "x" */
#ifdef incxws
    xws_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device xws not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now Nuuja's SunCGI stuff */
  if (0 == strncmp(dev_name, "sun", 3)) {/* anything beginning "scgi" */
#ifdef incsun
    scgi_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device sun not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  
  /* now binary CGM output */
  if (0 == strncmp(dev_name, "cgmb", 4)) { /* beginning with "cgmb" */
#ifdef inccgmb
    cb_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device cgmb not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  /* now clear text CGM output */
  if (0 == strncmp(dev_name, "cgmc", 4)) { /* beginning with "cgmc" */
#ifdef inccgmc
    cc_setup(arg_list);
    return(1);
#else
    (void) fprintf(stderr, "device cgmc not loaded, asked for %s\n", dev_name);
    return(0);
#endif
  }
  
  /* if we got here, we are in unknown territory */
  (void) fprintf(stderr, "unknown device [%s]\n", dev_name);
  return(0);
}
