/* ----------------------------------------------------------------
 * MAIN PROGRAM FOR TESTING PURPOSES
 *
 * NOTE: this program should be linked with all postgres modules (except
 * MAIN.o) because it uses routines not defined in cinterface.a
 *
 * It does some initializing and then calls TestMain().
 * (this is your routine!)
 *
 * Almost all the arguments are passed to TestMain (so you can define
 * and use your own command liner options).
 *
 * The only such options used by this routine are:
 * 	"-db <data_base_name>"
 *
 * Have fun!
 *
 * $Header: RCS/testmain.c,v 1.2 90/11/19 15:04:25 sp Exp $
 * ----------------------------------------------------------------
 */

#include <stdio.h>
#include <strings.h>
#include <signal.h>
#include <tcop/tcop.h>

void	TestMain();

extern char *DBName;

main(argc, argv)
int	argc;
char	*argv[];
{
	char		*datname;
	extern	jmp_buf	Warn_restart;
	int		geteuid(), setuid();			/* uid_t */
	int		chdir(), setjmp(), fprintf();
	char		*getenv();
	extern		exitpg();
	extern		resetmmgr();
	int		i;

	datname = NULL;
	for (i=1; i<argc; i++) {
	    if (!strcmp(argv[i], "-db")) {
		i++;
		if (i >= argc) {
		    fprintf(stderr,
		    "Error: '-db' must be followed by a database name\n");
		    exitpg(1);
		}
		datname = argv[i];
	    }
	}

	if (datname == NULL) {
	    datname = getenv("USER");
	    if (datname == (char *)NULL) {
		fprintf(stderr, "failed getenv(\"USER\")");
		exitpg(1);
	    }
	}

	signal(SIGHUP, die);
	signal(SIGINT, die);
	signal(SIGTERM, die);

	DBName = datname;
	InitPostgres(datname);

	setuid(geteuid());
	signal(SIGHUP, handle_warn);

	if (setjmp(Warn_restart) != NULL) {
		AbortCurrentTransaction();
	}

	TestMain(argc, argv);

	exitpg(0);
}

