/*
 * off.c --
 *	POSTGRES disk "offset" code.
 */

#include "tmp/c.h"

RcsId("$Header: RCS/off.c,v 1.5 90/09/25 16:46:28 kemnitz Exp $");

#include "storage/itemid.h"
#include "machine.h"		/* (in port dir.) for BLCKSZ */
#include "storage/off.h"

bool
OffsetNumberIsValid(offsetNumber)
	OffsetNumber	offsetNumber;
{
	return ((bool)((offsetNumber != 0) &&
		(offsetNumber < BLCKSZ / sizeof (ItemIdData))));
}

bool
OffsetIdIsValid(offsetId)
	OffsetId	offsetId;
{
	return ((bool)(PointerIsValid(offsetId) && *offsetId != 0));
}

void
OffsetIdSet(offsetId, offsetNumber)
	OffsetId	offsetId;
	OffsetNumber	offsetNumber;
{
	*offsetId = offsetNumber;
}

OffsetNumber
OffsetIdGetOffsetNumber(offsetId)
	OffsetId	offsetId;
{
	return (*offsetId);
}
