/*
 * block.c --
 *	POSTGRES disk block code.
 */

#include "tmp/c.h"

#include "storage/block.h"

RcsId("$Header: RCS/block.c,v 1.4 90/09/25 16:45:45 kemnitz Exp $");

bool
BlockSizeIsValid(blockSize)
	BlockSize	blockSize;
{
	/* should check that this is a power of 2 */
	return (true);
}

bool
BlockNumberIsValid(blockNumber)
	BlockNumber	blockNumber;
{
	return ((bool)(blockNumber >= 0 &&
		(int32)blockNumber != InvalidBlockNumber));
}

bool
BlockIdIsValid(blockId)
	BlockId		blockId;
{
	return ((bool)(PointerIsValid(blockId) && blockId->data[0] >= 0));
}

void
BlockIdSet(blockId, blockNumber)
	BlockId		blockId;
	BlockNumber	blockNumber;
{
	Assert(PointerIsValid(blockId));
/*	Assert(BlockNumberIsValid(blockNumber));	should check >= 0 */

	blockId->data[0] = blockNumber >> 16;
	blockId->data[1] = blockNumber & 0xffff;
	/* *((BlockNumber *)blockId->data) = blockNumber; */
}

BlockNumber
BlockIdGetBlockNumber(blockId)
	BlockId	blockId;
{
	Assert(BlockIdIsValid(blockId));

	return ((blockId->data[0] << 16) + (uint16)blockId->data[1]);
	/* return (*((BlockNumber *)blockId->data)); */
}
