/* $Header: RCS/FuzzyRules.c,v 2.2 91/02/02 15:02:44 sp Exp $ */

#ifdef FUZZY
/*
 * DoParallelProofPaths
 *
 * finds all tlist entries with resnames of "u"
 * and combines their values in the way of FRIL
 *
 */

List
DoParallelProofPaths ( targetlist )
     List targetlist;
{
    List i = targetlist;
    List upper = NULL;
    List lower = NULL;
    int  dempster_length = 0;
    int  index = 0;

    while ( i != LispNil &&
	    CAR(i) != LispNil &&
	    CAR(CAR(i)) != LispNil &&
	    IsA(CAR(CAR(i)),Resdom) &&
	    strcmp ( get_resname (CAR(CAR(i))), "l" ))
      i = CDR(i);

    /* i should now point to the first "l" node */

    dempster_length = length(i);

    if ((dempster_length % 2) != 0 ) 
      elog (WARN, "uneven length of support pairs");
    
    dempster_length = dempster_length / 2;
    dempster_length = dempster_length - 1; 

    /* if only one, don't need to combine */
    if (dempster_length <= 0 )
      return targetlist;

    lispDisplay ( i , 0 );
    printf ("\n%d\n",dempster_length );

    for ( index = 0 ; index < dempster_length ; index ++ ) {
	Func udempster 	= NULL;
	Func ldempster 	= NULL;
	List l1		= CAR(i);
	List u1		= CADR(i);
	List l1_rhs 	= CADR(l1);
	List u1_rhs 	= CADR(u1);
	List l2_rhs 	= CADR(CADR(CDR(i)));
	List u2_rhs 	= CADR(CADR(CDR(CDR(i))));
	List l1_resdom 	= CAR(l1);
	List u1_resdom 	= CAR(u1);
	List u_result 	= NULL;
	List l_result 	= NULL;

	/* remove the second u,l pair from the targetlist 
	   since we already have a handle on it, this should be OK */

	CDR(CDR(i)) = CDR(CDR(CDR(CDR(i))));

	/* XXX - hacks ... should use #defines instead */

	udempster = MakeFunc ( F_FUZ_U_DEMPSTER, 701, LispNil );
	ldempster = MakeFunc ( F_FUZ_L_DEMPSTER, 701, LispNil );

	l_result = lispCons ( ldempster,
		    lispCons (  l1_rhs, 
		     lispCons ( u1_rhs,
		      lispCons ( l2_rhs,
		       lispCons ( u2_rhs,LispNil )))));

	u_result = lispCons ( udempster,
		    lispCons (  l1_rhs, 
		     lispCons ( u1_rhs,
		      lispCons ( l2_rhs,
		       lispCons ( u2_rhs,LispNil )))));
	
	CDR(l1) = lispCons(l_result,LispNil);
	CDR(u1) = lispCons(u_result,LispNil);
    }
    
    printf("\n=======> After Dempsterizing, the new targetlist is :\n");
    lispDisplay ( targetlist, 0 );
}
StickOnUpperAndLower ( user, rule )
     List user;
     List rule;
{
    List i = NULL;

    foreach ( i , rule ) {
	List entry = CAR(i);
	if ((! strcmp ( get_resname (CAR(entry)), "u") ) ||
	    (! strcmp ( get_resname (CAR(entry)), "l") )      )
	  CDR(last(user)) = lispCons ( entry, LispNil );
    }
    
}
#endif

