/*
 * fmgr.h --
 *	Definitions for using internal procedures.
 *
 * Identification:
 *	$Header: RCS/fmgr.h,v 1.50 91/11/18 16:54:01 clarsen Exp $
 */

#ifndef	FMgrIncluded		/* Include this file only once */
#define FMgrIncluded	1

/*
 *	These MUST be defined BEFORE including builtins.h
 *
 *	If you #undefine these things the probability that the system will
 *	compile and work properly is small.  At a minimum, you'll need to
 *	rat around in utils/adt and utils/fmgr.  In addition, lib/H/catalog
 *	is crawling with math and abstract data type functions that should
 *	be dynamically loaded, rather than builtin.
 */

#define	FMGR_MATH		/* include extra math functions? */
#define	FMGR_ADT		/* include extra ADTs and AMs? */


#include "utils/builtins.h"

typedef char *(*FmgrFunction)();	/* ptr to func returning (char *) */

extern char	*fmgr();

/*
 * EnableDynamicFunctionManager --
 *	Enables/disables dynamic function loading.
 *
 * Exceptions:
 */
extern
void
EnableDynamicFunctionManager ARGS((
	FmgrFunction	function
));

/*
 *	Maximum number of arguments for a builtin function.
 *	The structure gets shoved onto the stack when a function is called
 *	from the function manager.  This allows us to configure MAXFMGRARGS
 *	in one place instead of having to having a giant switch.
 */
#define	MAXFMGRARGS	8

extern char *(*DynamicFunctionManagerP)();

typedef struct {
	char	*data[MAXFMGRARGS];
} FmgrValues;


/*
 *	Flags for the builtin oprrest selectivity routines.
 */
#define	SEL_CONSTANT 	1	/* constant does not vary (not a parameter) */
#define	SEL_RIGHT	2 	/* constant appears to right of operator */


/*
 * 	Initial internal proids follow...
 */
#define	F_BOOLIN		28
#define	F_BOOLOUT		29
#define	F_BYTEAIN		30
#define	F_BYTEAOUT		31
#define	F_CHARIN		32
#define	F_CHAROUT		33
#define	F_CHAR16IN		34
#define	F_CHAR16OUT		35
#define	F_DATETIMEIN		36
#define	F_DATETIMEOUT		37
#define	F_INT2IN		38
#define	F_INT2OUT		39
#define	F_INT28IN		40
#define	F_INT28OUT		41
#define	F_INT4IN		42
#define	F_OIDIN			42
#define	F_INT4OUT		43
#define	F_OIDOUT		43
#define	F_REGPROCIN		44
#define	F_REGPROCOUT		45
#define	F_TEXTIN		46
#define	F_TEXTOUT		47
#define	F_TIDIN			48
#define	F_TIDOUT		49
#define	F_XIDIN			50
#define	F_XIDOUT		51
#define	F_CIDIN			52
#define	F_CIDOUT		53
#define	F_OID8IN		54
#define	F_OID8OUT		55
#define F_LOCKIN		56
#define F_LOCKOUT		57
#define F_STUBIN		58
#define F_STUBOUT		59

#define	F_BOOLEQ		60
#define	F_CHAREQ		61
#define	F_CHAR16EQ		62
#define	F_INT2EQ		63
#define	F_INT2LT		64
#define	F_INT4EQ		65
#define	F_INT4LT		66
#define	F_TEXTEQ		67
#define	F_XIDEQ			68
#define	F_CIDEQ			69
#define F_CHARNE		70
#define F_CHARLT		71
#define F_CHARLE		72
#define F_CHARGT		73
#define F_CHARGE		74
#define F_CHARPL		75
#define F_CHARMI		76
#define F_CHARMUL		77
#define F_CHARDIV		78
#ifdef FMGR_ADT
#define F_CHAR16REGEXEQ		79
#define F_CHAR16REGEXNE		80
#define F_TEXTREGEXEQ		81
#define F_TEXTREGEXNE		82
#endif /* FMGR_ADT */

#define	F_RTSEL			97
#define	F_RTNPAGE		98
#define	F_BTREESEL		99
#define	F_BTREENPG		100
#define	F_EQSEL			101
#define	F_NEQSEL		102
#define	F_INTLTSEL		103
#define	F_INTGTSEL		104
#define	F_EQJOINSEL		105
#define	F_NEQJOINSEL		106
#define	F_INTLTJOINSEL		107
#define	F_INTGTJOINSEL		108

#define	F_BTREEENDSCAN		109
#define	F_BTREEMARKPOS		110
#define	F_BTREERESTRPOS		111
#define	F_BTREEINSERT		112
#define	F_BTREEDELETE		113
#define	F_BTREEGETNEXT		114
#define	F_BTREEBUILD		115
#define	F_BTREERESCAN		116

/*
 *  BTBEGINSCAN is defined below -- no room for it here.
 */

#ifdef FMGR_ADT
#define	F_POINT_IN		117
#define	F_POINT_OUT		118
#define	F_LSEG_IN		119
#define	F_LSEG_OUT		120
#define	F_PATH_IN		121
#define	F_PATH_OUT		122
#define	F_BOX_IN		123
#define	F_BOX_OUT		124
#define	F_BOX_OVERLAP		125
#define	F_BOX_GE		126
#define	F_BOX_GT		127
#define	F_BOX_EQ		128
#define	F_BOX_LT		129
#define	F_BOX_LE		130
/*
 *  F_BOX_SAME is defined below -- no space here.
 */
#define	F_POINT_ABOVE		131
#define	F_POINT_LEFT		132
#define	F_POINT_RIGHT		133
#define	F_POINT_BELOW		134
#define	F_POINT_EQ		135
#define	F_ON_PB			136
#define	F_ON_PPATH		137
#define	F_BOX_CENTER		138
#define	F_AREASEL		139
#define	F_AREAJOINSEL		140
#endif /* FMGR_ADT */
#define	F_INT4MUL		141
#ifdef FMGR_MATH
#define	F_INT4FAC		142
#endif /* FMGR_MATH */
#ifdef FMGR_ADT
#define	F_POINTDIST		143
#endif /* FMGR_ADT */
#define	F_INT4NE		144
#define	F_INT2NE		145
#define	F_INT2GT		146
#define	F_INT4GT		147
#define	F_INT2LE		148
#define	F_INT4LE		149
#define	F_INT4GE		150
#define	F_INT2GE		151
#define	F_INT2MUL		152
#define	F_INT2DIV		153
#define	F_INT4DIV		154
#ifdef FMGR_MATH
#define	F_INT2MOD		155
#define	F_INT4MOD		156
#endif /* FMGR_MATH */
#define	F_TEXTNE		157
#define	F_INT24EQ		158
#define	F_INT42EQ		159
#define	F_INT24LT		160
#define	F_INT42LT		161
#define	F_INT24GT		162
#define	F_INT42GT		163
#define	F_INT24NE		164
#define	F_INT42NE		165
#define	F_INT24LE		166
#define	F_INT42LE		167
#define	F_INT24GE		168
#define	F_INT42GE		169
#define	F_INT24MUL		170
#define	F_INT42MUL		171
#define	F_INT24DIV		172
#define	F_INT42DIV		173
#define	F_INT24MOD		174
#define	F_INT42MOD		175
#define	F_INT2PL		176
#define	F_INT4PL		177
#define	F_INT24PL		178
#define	F_INT42PL		179
#define	F_INT2MI		180
#define	F_INT4MI		181
#define	F_INT24MI		182
#define	F_INT42MI		183
#define	F_OIDEQ			184
#define	F_OIDNE		       	185

#ifdef FMGR_ADT
#define	F_BOX_SAME	       	186
#define	F_BOX_CONTAIN	       	187
#define	F_BOX_LEFT	       	188
#define	F_BOX_OVERLEFT	       	189
#define	F_BOX_OVERRIGHT	       	190
#define	F_BOX_RIGHT	       	191
#define	F_BOX_CONTAINED	       	192

/* these are pg_amproc entries for rtrees on boxes */
#define F_RT_BOX_UNION		193
#define F_RT_BOX_INTER		194
#define F_RT_BOX_SIZE		195
#define F_RT_BIGBOX_SIZE	196

/* these are pg_amproc entries for rtrees on polygons */
#define F_RT_POLY_UNION		197
#define F_RT_POLY_INTER		198
#define F_RT_POLY_SIZE		199
#endif /* FMGR_ADT */

#define	F_FLOAT4IN		200
#define	F_FLOAT4OUT		201
#define	F_FLOAT4MUL		202
#define	F_FLOAT4DIV		203
#define	F_FLOAT4PL		204
#define	F_FLOAT4MI		205
#define	F_FLOAT4UM		206
#define	F_FLOAT4ABS		207
#define F_FLOAT4INC		208
#define F_FLOAT4LARGER		209
				/* 210 is taken by pg_type */
#define F_FLOAT4SMALLER		211
#define	F_FLOAT8IN		214
#define	F_FLOAT8OUT		215
#define	F_FLOAT8MUL		216
#define	F_FLOAT8DIV		217
#define	F_FLOAT8PL		218
#define	F_FLOAT8MI		219
#define	F_FLOAT8UM		220
#define	F_FLOAT8ABS		221
#define	F_FLOAT8INC		222
#define	F_FLOAT8LARGER		223
#define	F_FLOAT8SMALLER		224
#ifdef FMGR_MATH
#define	F_DROUND		228
#define	F_DTRUNC		229
#define	F_DSQRT			230
#define	F_DCBRT			231
#define	F_DPOW			232
#define	F_DEXP			233
#define	F_DLOG			234
#endif /* FMGR_MATH */
#define F_ABSTIMEIN             240
#define F_ABSTIMEOUT            241
#define F_RELTIMEIN             242
#define F_RELTIMEOUT            243
#define F_TIMEPL                244
/*
 * XXX 242 to 273 reserved for time constructs
 */
#define F_ABSTIMEEQ		251
#define F_ABSTIMENE		252
#define F_ABSTIMELT		253
#define F_ABSTIMEGT		254
#define F_ABSTIMELE		255
#define F_ABSTIMEGE		256

#ifdef FMGR_MATH
#define	F_INT2FAC		276
#define	F_FLOAT48MUL		279
#define	F_FLOAT48DIV		280
#define	F_FLOAT48PL		281
#define	F_FLOAT48MI		282
#define	F_FLOAT84MUL		283
#define	F_FLOAT84DIV		284
#define	F_FLOAT84PL		285
#define	F_FLOAT84MI		286
#define	F_FLOAT4EQ		287
#define	F_FLOAT4NE		288
#define	F_FLOAT4LT		289
#define	F_FLOAT4LE		290
#define	F_FLOAT4GT		291
#define	F_FLOAT4GE		292
#define	F_FLOAT8EQ		293
#define	F_FLOAT8NE		294
#define	F_FLOAT8LT		295
#define	F_FLOAT8LE		296
#define	F_FLOAT8GT		297
#define	F_FLOAT8GE		298
#define	F_FLOAT48EQ		299
#define	F_FLOAT48NE		300
#define	F_FLOAT48LT		301
#define	F_FLOAT48LE		302
#define	F_FLOAT48GT		303
#define	F_FLOAT48GE		304
#define	F_FLOAT84EQ		305
#define	F_FLOAT84NE		306
#define	F_FLOAT84LT		307
#define	F_FLOAT84LE		308
#define	F_FLOAT84GT		309
#define	F_FLOAT84GE		310
#endif /* FMGR_MATH */

#define	F_F4TOF8		311
#define	F_F8TOF4		312
#define	F_I2TOI4		313
#define	F_I4TOI2		314
#define F_KEYFIRSTEQ		315

/*
 *  more access method interface routines (no room for them above)
 */
#define F_BTBEGINSCAN		319

#define F_RTINSERT		320
#define	F_RTDELETE		321
#define	F_RTGETTUPLE		322
#define	F_RTBUILD		323
#define	F_RTBEGINSCAN		324
#define	F_RTENDSCAN		325
#define	F_RTMARKPOS		326
#define	F_RTRESTRPOS		327
#define	F_RTRESCAN		328

#define F_NBTGETTUPLE		330
#define F_NBTINSERT		331
#define F_NBTDELETE		332
#define F_NBTBEGINSCAN		333
#define F_NBTRESCAN		334
#define F_NBTENDSCAN		335
#define F_NBTMARKPOS		336
#define F_NBTRESTRPOS		337
#define F_NBTBUILD		338

#ifdef FMGR_ADT
#define	F_POLY_SAME	       	339
#define	F_POLY_CONTAIN	    340
#define	F_POLY_LEFT	       	341
#define	F_POLY_OVERLEFT	    342
#define	F_POLY_OVERRIGHT	343
#define	F_POLY_RIGHT	    344
#define	F_POLY_CONTAINED	345
#define	F_POLY_OVERLAP		346
#define F_POLY_IN			347
#define F_POLY_OUT			348
#endif /* FMGR_ADT */

/*
 *  pg_amproc entries for new btrees -- per-opclass comparison functions.
 */

#define F_BTINT2CMP		350
#define F_BTINT4CMP		351
#define F_BTINT42CMP		352
#define F_BTINT24CMP		353
#define F_BTFLOAT4CMP		354
#define F_BTFLOAT8CMP		355
#define F_BTOIDCMP		356
#define F_BTABSTIMECMP		357
#define F_BTCHARCMP		358
#define F_BTCHAR16CMP		359
#define F_BTTEXTCMP		360

#ifdef FMGR_ADT
#define	F_FTREEINSERT		612
#define	F_FTREEDELETE		613
#define	F_FTREEGETNEXT		614
#define	F_FTREEBUILD		615
#define	F_KW_IN			616
#define	F_KW_OUT		617
#define	F_KW_EQ			618
#define	F_KW_LT			619
#define	F_KW_LE			620
#define	F_KW_GT			621
#define	F_KW_GE			622
#define	F_KWLIST_IN		623
#define	F_KWLIST_OUT		624
#define	F_KWLIST_EXTRACT	626
#define	F_KWLIST_COUNT		627
#define	F_KWLIST_ELEMENT	628
#define	F_KWLIST_LISTIFY	629
#define	F_KWLISTSEL		630
#define	F_KWLISTNPAGES		631

#endif /* FMGR_ADT */

#define F_INT4NOTIN		650
#define F_OIDNOTIN		651
#define F_INT44IN		652
#define F_INT44OUT		653

#define F_GETATTRIBUTE		654

#define F_CHAR16LT		655
#define F_CHAR16LE		656
#define F_CHAR16GT		657
#define F_CHAR16GE		658
#define F_CHAR16NE		659

#define F_LOCKADD		700
#define F_LOCKRM		701

/*
 * General miscellaneous routines.
 */

#define F_PG_USERNAME		710
#define F_USERFNTEST		711
/*
 * routines for the 'bytea' type.
 */
#define F_BYTEASIZE		720
#define F_BYTEAGETBYTE		721
#define F_BYTEASETBYTE		722
#define F_BYTEAGETBIT		723
#define F_BYTEASETBIT		724

/* ----------------
 *	test routine for backend-pq functions
 * ----------------
 */
#define F_PQTEST		730

/* ----------------
 *	text comparison functions
 * ----------------
 */

#define F_TEXTLT		740
#define F_TEXTLE		741
#define F_TEXTGT		742
#define F_TEXTGE		743

/*
 * special array input and output routines
 */

#define F_ARRAY_IN		750
#define F_ARRAY_OUT		751

#define F_FILENAME_IN   752
#define F_FILENAME_OUT  753

#define F_SMGRIN		760
#define F_SMGROUT		761
#define F_SMGREQ		762
#define F_SMGRNE		763

#define F_LO_FILEIN		764
#define F_LO_FILEOUT	765

#define F_INT4INC		766
#define F_INT2INC		767
#define F_INT4LARGER		768
#define F_INT4SMALLER		769
#define F_INT2LARGER		770
#define F_INT2SMALLER		771

#define F_NOBTGETTUPLE		800
#define F_NOBTINSERT		801
#define F_NOBTDELETE		802
#define F_NOBTBEGINSCAN		803
#define F_NOBTRESCAN		804
#define F_NOBTENDSCAN		805
#define F_NOBTMARKPOS		806
#define F_NOBTRESTRPOS		807
#define F_NOBTBUILD		808

#define F_FIMPORT		900
#define F_FEXPORT		901
#define F_FABSTRACT		902

#define F_OIDSEQIN		920
#define F_OIDSEQOUT		921
#define F_OIDSEQLT		922
#define F_OIDSEQLE		923
#define F_OIDSEQEQ		924
#define F_OIDSEQGE		925
#define F_OIDSEQGT		926
#define F_OIDSEQNE		927
#define F_OIDSEQCMP		928
#define F_MKOIDSEQ		929

#define F_FILETOOID             950
#define F_LOCREATOID            951
#define F_LOOPEN                952
#define F_LOCLOSE               953
#define F_LOREAD                954
#define F_LOWRITE               955
#define F_LOLSEEK               956
#define F_LOCREAT               957
#define F_LOTELL                958
#define F_LOFTRUNCATE           959
#define F_LOSTAT                960
#define F_LORENAME              961
#define F_LOMKDIR               962
#define F_LORMDIR               963
#define F_LOUNLINK              964

#endif	/* !defined(FMgrIncluded) */
