/*
 * xid.h --
 *	POSTGRES transaction identifier definitions.
 */

#ifndef	XIdIncluded		/* Include this file only once */
#define XIdIncluded	1

/*
 * Identification:
 */
#define XID_H	"$Header: RCS/xid.h,v 1.8 90/08/17 08:55:04 cimarron Exp $"

#include "tmp/c.h"

/* ----------------------------------------------------------------
 *	TransactionId definition
 * ----------------------------------------------------------------
 */

typedef struct TransactionIdData {
	uint8	data[5];
} TransactionIdData;

#define TransactionIdDataSize	5

typedef TransactionIdData	*TransactionId;

#define InvalidTransactionId	NULL
#define NullTransactionIdValue	0.0

typedef double			TransactionIdValueData;
typedef TransactionIdValueData	*TransactionIdValue;

typedef uint8	CommandId;

#define FirstCommandId	0

#define TransactionMultiplierPerByte	(1 << BitsPerByte)
#define TransactionsPerSecondAdjustment	TransactionMultiplierPerByte	

extern TransactionId	NullTransactionId;
extern TransactionId	AmiTransactionId;
extern TransactionId	FirstTransactionId;

/* ----------------------------------------------------------------
 * TransactionIdIsValid --
 *	True iff transaction identifier is valid.
 * ----------------------------------------------------------------
 */
extern
bool
TransactionIdIsValid ARGS((
	TransactionId	transactionId
));

/* ----------------------------------------------------------------
 * GetNewTransactionId --
 *	Returns a new transaction identifier.
 * ----------------------------------------------------------------
 */
extern
void
GetNewTransactionId ARGS((
	TransactionId   xid
));

/* ----------------------------------------------------------------
 * StringFormTransactionId --
 *	Returns transaction identifier associated with a string.
 * ----------------------------------------------------------------
 */
extern
TransactionId
StringFormTransactionId ARGS((
	String	representation
));

/* ----------------------------------------------------------------
 * TransactionIdValueFormString --
 *	Returns string representation for a transaction identifier.
 * ----------------------------------------------------------------
 */
extern
String
TransactionIdFormString ARGS((
	TransactionId	transactionId
));

/* ----------------------------------------------------------------
 * TransactionIdStore --
 *	Stores the transaction identifier in external form.
 *
 * Note:
 *	Assumes transaction identifier is valid.
 *	Assumes destination pointer is valid.
 * ----------------------------------------------------------------
 */
extern
void
TransactionIdStore ARGS((
	TransactionId	transactionId,
	Pointer		destination
));

/* ----------------------------------------------------------------
 * PointerStoreInvalidTransactionId --
 *	Stores an invalid transaction identifier (in external form).
 *
 * Note:
 *	Assumes destination pointer is valid.
 * ----------------------------------------------------------------
 */
extern
void
PointerStoreInvalidTransactionId ARGS((
	Pointer		destination
));

/* ----------------------------------------------------------------
 * TransactionIdEquals --
 *	True iff transaction identifiers are equal.
 *
 * Note:
 *	Assumes transaction identifiers are valid.
 * ----------------------------------------------------------------
 */
extern
bool
TransactionIdEquals ARGS((
	TransactionId	id1,
	TransactionId	id2
));

/* ----------------------------------------------------------------
 * TransactionIdIsLessThan --
 *	True iff first transaction identifier is less than the second.
 *
 * Note:
 *	Assumes transaction identifiers are valid.
 * ----------------------------------------------------------------
 */
extern
bool
TransactionIdIsLessThan ARGS((
	TransactionId	id1,
	TransactionId	id2
));
/* ----------------------------------------------------------------
 * TransactionIdValueIsValid --
 *	True iff transaction identifier value is valid.
 * ----------------------------------------------------------------
 */
extern
bool
TransactionIdValueIsValid ARGS((
	TransactionIdValue	value
));

/* ----------------------------------------------------------------
 * StringGetTransactionIdValue --
 *	Returns transaction identifier value associated with a string.
 * ----------------------------------------------------------------
 */
extern
void
StringSetTransactionIdValue ARGS((
	String			representation,
	TransactionIdValue	value
));

/* ----------------------------------------------------------------
 * TransactionIdValueFormString --
 *	Returns string representation for a transaction identifier value.
 * ----------------------------------------------------------------
 */
extern
String
TransactionIdValueFormString ARGS((
	TransactionIdValue	value
));

/* ----------------------------------------------------------------
 * TransactionIdValueSetTransactionId --
 *	Sets transaction identifier to a transaction identifier value.
 * ----------------------------------------------------------------
 */
extern
void
TransactionIdValueSetTransactionId ARGS((
	TransactionIdValue	idValue,
	TransactionId		id
));

/* ----------------------------------------------------------------
 * TransactionIdSetTransactionIdValue --
 *	Sets transaction identifier value for a transaction identifier.
 * ----------------------------------------------------------------
 */
extern
void
TransactionIdSetTransactionIdValue ARGS((
	TransactionId		id,
	TransactionIdValue	idValue
));

/* ----------------------------------------------------------------
 * TransactionIdIncrement --
 *	Increments transaction identifier.
 * ----------------------------------------------------------------
 */
extern
void
TransactionIdIncrement ARGS((
	TransactionId	transactionId
));


#endif	/* !defined(XIdIncluded) */
