/*
 * status.h --
 *	POSTGRES library function return status.
 * 	$Header: RCS/status.h,v 1.5 90/08/17 08:54:57 cimarron Exp $
 */

#ifndef	StatusIncluded	/* Include this file only once. */
#define StatusIncluded	1

#include "tmp/c.h"

/*
 * ReturnStatus --
 *	Return status from POSTGRES library functions.
 *
 * Note:
 *	Most POSTGRES functions will not return a status.
 *	In the future, there should be a global variable
 *	which indicates the reason for the failure--the
 *	identifier of an error message in the ERROR relation.
 */
typedef int	ReturnStatus;

/*
 * ReturnStatusIsValid --
 *	True iff return status is valid.
 *
 * Note:
 *	Assumes that a library function can only indicate
 *	sucess or failure.
 */
#define ReturnStatusIsValid(status) \
	((-1) <= (status) && (status) <= 0)

/*
 * ReturnStatusIsSucess --
 *	True iff return status indicates a sucessful call.
 */
#define SucessfulReturnStatus(status) \
	((status) >= 0)

#endif	/* !defined(StatusIncluded) */
