/*
 * bit.h --
 *	Standard bit array definitions.
 *
 * Identification:
 *	$Header: RCS/bit.h,v 1.5 90/08/17 08:54:35 cimarron Exp $
 */

#ifndef	BitIncluded	/* Include this file only once. */
#define BitIncluded	1

#include "tmp/c.h"

typedef bits8	*BitArray;
typedef uint32	BitIndex;

#define BitsPerByte	8

/*
 * NumberOfBitsPerByte --
 *	Returns the number of bits per byte.
 */
int
NumberOfBitsPerByte ARGS((
	void
));

/*
 * BitArraySetBit --
 *	Sets (to 1) the value of a bit in a bit array.
 */
void
BitArraySetBit ARGS((
	BitArray	bitArray,
	BitIndex	bitIndex
));

/*
 * BitArrayClearBit --
 *	Clears (to 0) the value of a bit in a bit array.
 */
void
BitArrayClearBit ARGS((
	BitArray	bitArray,
	BitIndex	bitIndex
));

/*
 * BitArrayBitIsSet --
 *	True iff the bit is set (1) in a bit array.
 */
bool
BitArrayBitIsSet ARGS((
	BitArray	bitArray,
	BitIndex	bitIndex
));

/*
 * BitArrayCopy --
 *	Copys the contents of one bit array into another.
 */
void
BitArrayCopy ARGS((
	BitArray	fromBitArray,
	BitArray	toBitArray,
	BitIndex	fromBitIndex,
	BitIndex	toBitIndex,
	BitIndex	numberOfBits
));

/*
 * BitArrayZero --
 *	Zeros the contents of a bit array.
 */
void
BitArrayZero ARGS((
	BitArray	bitArray,
	BitIndex	bitIndex,
	BitIndex	numberOfBits
));

#endif	/* !defined(BitIncluded) */
