/***********************************************************************
 ** *   Recursive (node) Header (recursive.h)                       * **
 ** *           Jimmy Bell                                          * **
 ** *                                                               * **
 ***********************************************************************
 *
 */

/* $Header: RCS/recursive.h,v 1.4 90/08/17 08:52:32 cimarron Exp $ */

#ifndef RecursiveIncluded
#define RecursiveIncluded

#include "tmp/postgres.h"		/* for pg_eval */

#include "planner/recurplanner.h"	/* for GeneralPlanFunctions */
#include "access/xact.h"		/* for GetCurrentTransactionId() */

#define totalSequences 3	/* viz. initPlans, loopPlans, cleanupPlans */

/* Number of times to loop thru Loop Plans */
extern
int
GetLoopLimit ARGS((
));

/* plan sequence indicated by index */
extern
List
GetPlanSequence ARGS((
	Recursive	node,
	int		sequenceIndex
));

/* name which is okay to use for temp relation */
extern
String
GetUniqueTempRelationName ARGS((
	int	whichTemp
));

#define GetTempRelationDataA() 111
#define GetTempRelationDataB() 112
#define GetResultRelationData() 113

extern
void
TempRelationSwitch ARGS((
	bool	*areTempsSwitchedP
));

extern
void
TempRelationResetSwitch ARGS((
	bool	*areTempsSwitchedP
));

/* ----------------------------------------------------------------
 *	exec-recursive-initialize-next
 *    
 *    	Sets up the recursive node state (i.e. the recursive state node)
 *	for the "next" scan.
 *    
 *    	Returns t iff there is a "next" scan to process.  (See note at end)
 * ----------------------------------------------------------------
 *	Currently does nothing useful.  -- JRB
 */

extern
List
exec_recursive_initialize_next ARGS((
    Recursive	node,
    int	   level
));

/* ----------------------------------------------------------------
 *	ExecInitRecursive
 *    
 *    	Begins all of the subscans of the recursive node.
 *
 *    	Returns the scan result of the first scan.
 * ----------------------------------------------------------------
 */

extern
List
ExecInitRecursive ARGS((
    Recursive	node,
    EState	estate,
    int		level
));

/* ----------------------------------------------------------------
 *     ActionAffectedResultRelation
 *
 *      Returns true iff a unique action was successfully executed.
 *	E.g. an append was successful since the new tuple was not
 *	a duplicate of one already in the relation.
 *
 * ----------------------------------------------------------------
 */

extern
bool
ActionAffectedResultRelation ARGS((
	List	actionResult
));

/* ----------------------------------------------------------------
 *     ExecProcRecursive
 *    
 *    	Handles the iteration over the multiple scans.
 *    
 * ----------------------------------------------------------------
 */

extern
List
ExecProcRecursive ARGS((
    List node
));

/* ----------------------------------------------------------------
 *	ExecEndRecursive
 *    
 *    	Shuts down the subscans of the recursive node.
 *    
 *    	Returns nothing of interest.
 * ----------------------------------------------------------------
 */

extern
void
ExecEndRecursive ARGS((
    List node
));

#endif
