/* ----------------------------------------------------------------
 *   FILE
 *	catalog/catmacros.h
 *
 *   DESCRIPTION
 *	macros used by src/lib/H/catalog/pg_*.h files.  The
 *	genbki.sh script scans those files and generates .bki
 *	files which are used to generate the postgres template
 *	database.  These macros are used to make those files
 *	interpretable as C structure definitions.  Since the
 *	structure definitions and the databases are generated
 *	from the same file, they are guaranteed to correspond.
 *
 *	This file will be going away soon when postgres.h 
 *	actually provides support for the system types and the
 *	system catalog macros.  -cim 8/6/90
 * ----------------------------------------------------------------
 * $Header: RCS/catmacros.h,v 1.6 91/07/03 00:45:58 mao Exp $
 */
#ifndef CatmacrosHIncluded		/* include only once */
#define CatmacrosHIncluded

#include "tmp/postgres.h"

#if 0
/* ----------------------------------------------------------------
 *	THIS FILE IS OBSOLETE.  postgres.h now contains the
 *	proper type definitions.
 * ----------------------------------------------------------------
 */
/* ----------------
 *	system catalog macros
 * ----------------
 */
#define CATALOG(x) \
    typedef struct CppConcat(FormData_,x)

#define DATA(x)
#define BOOTSTRAP

/* ----------------
 *	system type mappings.  these will go away when we start using
 *	a single type scheme.
 *
 *		system type	C type
 *		--------------------------------
 *		bool		Boolean
 *		bytea		struct varlena
 *		char		char
 *		char16		char[16] (NameData)
 *		dt		ABSTIME / RELTIME
 *		int2		int16
 *		int28		int16[8] 
 *		int4		int32
 *		oid		ObjectId
 *		oid8		ObjectId[8]
 *		regproc		ObjectId
 *		text		struct varlena
 * ----------------
 */
#define bool	Boolean
#define bytea	struct varlena
#define char16	NameData
#define dt	ABSTIME
#define int2	int16
#define int28	Int28
#define int4	int32
#define oid	ObjectId
#define oid8	Oid8
#define regproc	ObjectId
#define text	struct varlena
#define stub 	struct varlena
#define smgr 	int2

/* ----------------
 *	temporary types
 * ----------------
 */
#endif

#endif CatmacrosHIncluded
