#
#	$Header: RCS/test.mk,v 1.13 91/02/24 09:13:42 mao Exp Locker: sp $
#


POSTGRES_OBJS = $(OD)/ACCESS.o $(OD)/COMMANDS.o $(OD)/EXECUTOR.o \
		$(OD)/LIB.o $(OD)/PARSER.o $(OD)/PLANNER.o \
		$(OD)/PORT.o $(OD)/REWRITE.o $(OD)/RULES.o \
		$(OD)/STORAGE.o $(OD)/TCOP.o $(OD)/UTIL.o $(OD)/INH.o

# test: pprint teststubs testrules testbtree dumpbpages
test: pprint teststubs testrules rtdump

libpq: $(OD)/libpq.a

$(OD)/libpq.a: $(LIBPQ)
	@echo ar rvu libpq.a ...
	@ar rvu $(OD)/libpq.a $(LIBPQ)
	ranlib $(OD)/libpq.a

rtdump: $(OD)/test/rtdump

$(OD)/test/rtdump: $(RTDUMP) $(OD)/cinterface.a
	$(CC) $(CFLAGS) -o $(OD)/test/rtdump \
		$(RTDUMP) $(OD)/cinterface.a -lm -ll -lc

testbtree: $(OD)/test/testbtree

$(OD)/test/testbtree: $(TESTBTREE) $(OD)/cinterface.a
	$(CC) $(CFLAGS) -o $(OD)/test/testbtree \
		$(TESTBTREE) $(OD)/cinterface.a -lm -ll -lc

dumpbpages: $(OD)/test/dumpbpages

$(OD)/test/dumpbpages: $(OD)/cinterface.a $(DUMPBPAGES)
	$(CC) $(CFLAGS) -o $(OD)/test/dumpbpages \
		$(DUMPBPAGES) $(OD)/cinterface.a -lm -ll -lc

testrules:	$(OD)/test/testrules
$(OD)/test/testrules:	$(TESTRULES) $(POSTGRES_OBJS)
	$(CC) $(CFLAGS) -o $(OD)/test/testrules \
		$(TESTRULES) $(POSTGRES_OBJS) -lm -ll -lc

teststubs:	$(OD)/test/teststubs
$(OD)/test/teststubs:	$(TESTSTUBS) $(POSTGRES_OBJS)
	$(CC) $(CFLAGS) -o $(OD)/test/teststubs \
		$(TESTSTUBS) $(POSTGRES_OBJS) -lm -ll -lc

pprint:		$(OD)/test/pprint
$(OD)/test/pprint:	$(OD)/test/pprint.o
	$(CC) $(CFLAGS) -o $(OD)/test/pprint $(OD)/test/pprint.o
