# ----------------
#	support.mk	- postgres support program makefile
#
# Note:	if $STRIPOBJS is 't' then targets are stripped after compilation.
#	This defaults to 'f' by Make.
#
## $Header: RCS/support.mk,v 1.32 91/05/22 21:38:49 kemnitz Exp $
# ----------------

#include "config.mk"
#include "defaults.mk"
#include "FILES/support.mkf"

.SUFFIXES: .c .o .lex .y
DFLAGS= -DPG_STANDALONE

support: bkifiles libpq monitor vacuum pg_version pg_id

# ----------------
#    libpq.a
# ----------------
libpq: $(OD)/libpq.a

$(OD)/libpq.a: $(LIBPQ)
	@echo ar rvu libpq.a ...
	@ar rvu $(OD)/libpq.a $(LIBPQ)
	ranlib $(OD)/libpq.a

# ----------------
#    bkifiles
# ----------------
bkifiles: $(OD)/support/dbdb.bki $(OD)/support/local.bki

$(OD)/support/dbdb.bki: $(DBDB_SRC)
	@ echo "creating dbdb.bki" ; \
	cd $(SD)/lib/H/catalog ; \
	TREE=$(TREE);export TREE; \
	OD=`basename $(OD)`;export OD; \
	SD=`basename $(SD)`;export SD; \
	$(GENBKI) $(DBDB_SRC) > $(OD)/support/dbdb.bki

$(OD)/support/local.bki: $(LOCAL_SRC)
	@ echo "creating local.bki" ; \
	cd $(SD)/lib/H/catalog ; \
	TREE=$(TREE);export TREE; \
	OD=`basename $(OD)`;export OD;\
	SD=`basename $(SD)`;export SD; \
	$(GENBKI) $(LOCAL_SRC) > $(OD)/support/local.bki

# ----------------
#    rmbkifiles
# ----------------
rmbkifiles:
	@ echo "removing bki files" ; \
	rm -f $(OD)/support/dbdb.bki $(OD)/support/local.bki

# ----------------
#    pg_version
# ----------------
pg_version: $(OD)/support/pg_version

$(OD)/support/pg_version: $(PG_VERSION)
	@ echo "linking pg_version"
	@ $(CC) $(CFLAGS) -o $(OD)/support/pg_version $(PG_VERSION)
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/pg_version ; \
		 else true ; fi'


# ----------------
#    pg_id
# ----------------
pg_id: $(OD)/support/pg_id

$(OD)/support/pg_id: $(PG_ID)
	@ echo "linking pg_id"
	@ $(CC) $(CFLAGS) -o $(OD)/support/pg_id $(PG_ID)

# ----------------
#    monitor
# ----------------
monitor: $(OD)/support/monitor 

$(OD)/support/monitor: $(OD)/libpq.a $(MONITOR)
	@ echo "linking monitor"
	@ $(CC) $(CFLAGS) -o $(OD)/support/monitor \
		$(MONITOR) $(OD)/libpq.a $(LIBS)
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/monitor ; \
		 else true ; fi'

# ----------------
#    vacuum
# ----------------
vacuum: $(SD)/scripts/vacuum

$(SD)/scripts/vacuum: $(SD)/scripts/vacuum.sh
	@ echo "sed'ing vacuum"
	@ sed -e s%_POSTGRESBIN_%$(POSTGRESBIN)% $(SD)/scripts/vacuum.sh > \
					       $(SD)/scripts/vacuum
	@ chmod 555 $(SD)/scripts/vacuum

# ----------------
#    xexemon
# ----------------
XLIBS = $(OD)/libXs.a -lXaw -lXmu -lXt -lX11 -lm

xexemon: $(OD)/support/xexemon 

$(OD)/libXs.a: $(OD)/support/Tree.o
	ar ruv $(OD)/libXs.a $(OD)/support/Tree.o
	ranlib $(OD)/libXs.a 

$(OD)/support/xexemon: $(OD)/support/xexemon.o $(OD)/libXs.a
	$(CC) $(CFLAGS) -o $@ $@.o  $(XLIBS)
