#---------------
#  main postgres makefile.
#  - this should be kept real clean as it is in the critical
#    path for compilation and the smaller it is, the faster compiles
#    will run.
#
#  Note: if $DEVELOPMENT is 't' then intermediate .o and .d files are not 
#  	 automatically removed when the target is finished.  
#
#	 if not set by the user, $DEVELOPMENT is set by Make to 'f'.
#        if the -development option is specified on the Make command line,
#	 then $DEVELOPMENT is set to 't' 
#
#  	 if $STRIPOBJS is 't' then targets are stripped after compilation.
#	 This defaults to 'f' by Make.
#
# $Header: RCS/postgres.mk,v 1.28 91/05/14 14:31:52 kemnitz Exp $
#---------------

#include "config.mk"
#include "port.mk"
#include "FILES/$*"
#include "defaults.mk"
#include "DEPS/$*"

.SUFFIXES: .d .c .o .lex .y

# ----------------
# targets
# ----------------
ALLMODS = $(OD)/ACCESS.o $(OD)/COMMANDS.o $(OD)/EXECUTOR.o $(OD)/LIB.o \
	$(OD)/BEPQ.o $(OD)/MAIN.o $(OD)/PARSER.o $(OD)/PLANNER.o \
	$(OD)/PORT.o $(OD)/REWRITE.o $(OD)/RULES.o $(OD)/STORAGE.o \
	$(OD)/TCOP.o $(OD)/UTIL.o $(OD)/BOOTSTRAP.o $(OD)/INH.o 

ALLDEPS = ACCESS.d COMMANDS.d EXECUTOR.d LIB.d BEPQ.d MAIN.d PARSER.d \
	PLANNER.d PORT.d REWRITE.d RULES.d STORAGE.d BOOTSTRAP.d TCOP.d UTIL.d 

# ----------------
# access methods
# ----------------
ACCESS.o:	$(OD)/ACCESS.o

$(OD)/ACCESS.o: $(AMOBJS)
	@ ld -r -o $(OD)/ACCESS.o $(AMOBJS)
	@ echo Module ACCESS done

ACCESS.d: $(AMDEPS)
	@ cat $(AMDEPS) > ACCESS.d
	@ mv ACCESS.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(AMDEPS); \
		 else true; fi'
	@ echo ACCESS dependencies done

# ----------------
# special commands
# ----------------
COMMANDS.o:	$(OD)/COMMANDS.o

$(OD)/COMMANDS.o: $(COMMANDS)
	@ ld -r -o $(OD)/COMMANDS.o $(COMMANDS)
	@ echo Module COMMANDS done

COMMANDS.d: $(COMMANDSDEPS)
	@ cat $(COMMANDSDEPS) > COMMANDS.d
	@ mv COMMANDS.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(COMMANDSDEPS); \
		 else true ; fi'
	@ echo COMMANDS dependencies done

# ----------------
# run time executor
# ----------------
EXECUTOR.o:	$(OD)/EXECUTOR.o

$(OD)/EXECUTOR.o: $(EXECOBJS)
	@ ld -r -o $(OD)/EXECUTOR.o $(EXECOBJS)
	@ echo Module EXECUTOR done

EXECUTOR.d: $(EXECDEPS)
	@ cat $(EXECDEPS) > EXECUTOR.d
	@ mv EXECUTOR.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(EXECDEPS); \
		 else true ; fi'
	@ echo EXECUTOR dependencies done

# ----------------
# library routines
# ----------------
LIB.o:	$(OD)/LIB.o

$(OD)/LIB.o: $(LIBOBJS)
	@ ld -r -o $(OD)/LIB.o $(LIBOBJS)
	@ echo Module LIB done

LIB.d: $(LIBDEPS)
	@ cat $(LIBDEPS) > LIB.d
	@ mv LIB.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(LIBDEPS); \
		 else true ; fi'
	@ echo LIB dependencies done

# ----------------
# backend libpq routines
# ----------------
BEPQ.o:	$(OD)/BEPQ.o

$(OD)/BEPQ.o: $(BEPQOBJS)
	@ ld -r -o $(OD)/BEPQ.o $(BEPQOBJS)
	@ echo Module BEPQ done

BEPQ.d: $(BEPQDEPS)
	@ cat $(BEPQDEPS) > BEPQ.d
	@ mv BEPQ.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(BEPQDEPS); \
		 else true ; fi'
	@ echo BEPQ dependencies done

# ----------------
# main() module
# ----------------
MAIN.o:	$(OD)/MAIN.o

$(OD)/MAIN.o:	$(MAINOBJS)
	@ ld -r -o $(OD)/MAIN.o $(MAINOBJS)
	@ echo Module MAIN done

MAIN.d:	$(MAINDEPS)
	@ cat $(MAINDEPS) > MAIN.d
	@ mv MAIN.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(MAINDEPS); \
		 else true ; fi'
	@ echo MAIN dependencies done

# ----------------
# query parser
# ----------------
PARSER.o:	$(OD)/PARSER.o

$(OD)/PARSER.o: $(PARSEROBJS)
	@ ld -r -o $(OD)/PARSER.o $(PARSEROBJS)
	@ echo Module PARSER done

PARSER.d: $(PARSERDEPS)
	@ cat $(PARSERDEPS) > PARSER.d
	@ mv PARSER.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(PARSERDEPS); \
		 else true ; fi'
	@ echo PARSER dependencies done

# ----------------
# query planner
# ----------------
PLANNER.o:	$(OD)/PLANNER.o

$(OD)/PLANNER.o: $(PLANNEROBJS)
	@ ld -r -o $(OD)/PLANNER.o $(PLANNEROBJS)
	@ echo Module PLANNER done

PLANNER.d: $(PLANNERDEPS)
	@ cat $(PLANNERDEPS) > PLANNER.d
	@ mv PLANNER.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(PLANNERDEPS); \
		 else true ; fi'
	@ echo PLANNER dependencies done

# ----------------
# port specific stuff
# ----------------
PORT.o:	$(OD)/PORT.o
$(OD)/PORT.o: $(PORTOBJS)
	@ ld -r -o $(OD)/PORT.o $(PORTOBJS)
	@ echo Module PORT done

PORT.d: $(PORTDEPS)
	@ cat $(PORTDEPS) > PORT.d
	@ mv PORT.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(PORTDEPS); \
		 else true ; fi'
	@ echo PORT dependencies done

# ----------------
# rewrite rule manager
# ----------------
REWRITE.o:	$(OD)/REWRITE.o

$(OD)/REWRITE.o: $(REWRITEOBJS)
	@ ld -r -o $(OD)/REWRITE.o $(REWRITEOBJS)
	@ echo Module REWRITE done

REWRITE.d: $(REWRITEDEPS)
	@ cat $(REWRITEDEPS) > REWRITE.d
	@ mv REWRITE.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(REWRITEDEPS); \
		 else true ; fi'
	@ echo REWRITE dependencies done

# ----------------
# tuple rule manager
# ----------------
RULES.o:	$(OD)/RULES.o

$(OD)/RULES.o: $(RULEOBJS)
	@ ld -r -o $(OD)/RULES.o $(RULEOBJS)
	@ echo Module RULES done

RULES.d: $(RULEDEPS)
	@ cat $(RULEDEPS) > RULES.d
	@ mv RULES.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(RULEDEPS); \
		 else true ; fi'
	@ echo RULES dependencies done

# ----------------
# storage manager
# ----------------
STORAGE.o:	$(OD)/STORAGE.o

$(OD)/STORAGE.o: $(STORAGEOBJS)
	@ ld -r -o $(OD)/STORAGE.o $(STORAGEOBJS)
	@ echo Module STORAGE done

STORAGE.d: $(STORAGEDEPS)
	@ cat $(STORAGEDEPS) > STORAGE.d
	@ mv STORAGE.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(STORAGEDEPS); \
		 else true ; fi'
	@ echo STORAGE dependencies done

# ----------------
# traffic cop
# ----------------
TCOP.o:	$(OD)/TCOP.o

$(OD)/TCOP.o: $(TCOPOBJS)
	@ ld -r -o $(OD)/TCOP.o $(TCOPOBJS)
	@ echo Module TCOP done

TCOP.d: $(TCOPDEPS)
	@ cat $(TCOPDEPS) > TCOP.d
	@ mv TCOP.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(TCOPDEPS); \
		 else true ; fi'
	@ echo TCOP dependencies done

# ----------------
# The Bootstrapper
# ----------------
BOOTSTRAP.o: $(OD)/BOOTSTRAP.o

$(OD)/BOOTSTRAP.o: $(BOOTSTRAPOBJS)
	@ ld -r -o $(OD)/BOOTSTRAP.o $(BOOTSTRAPOBJS)
	@ echo Module BOOTSTRAP done

# ----------------
# system utilities
# ----------------
UTIL.o:	$(OD)/UTIL.o

$(OD)/UTIL.o: $(UTILOBJS)
	@ ld -r -o $(OD)/UTIL.o $(UTILOBJS)
	@ echo Module UTIL done

UTIL.d: $(UTILDEPS)
	@ cat $(UTILDEPS) > UTIL.d
	@ mv UTIL.d $(TREE)/newconf/DEPS
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(UTILDEPS); \
		 else true ; fi'
	@ echo UTIL dependencies done

# ----------------
# node inheritance support stuff.
# note: dependencies for these are hard coded.
# ----------------
INH.o:	$(OD)/INH.o

$(OD)/INH.o: $(INH_OBJ)
	@ ld -r -o $(OD)/INH.o $(INH_OBJ)
	@ echo Module INH done

# ----------------
# the final product.. $(OD)/support/postgres
# ----------------
POSTGRES.o: $(ALLMODS)
	@ echo linking postgres
	@ $(CC) $(PORTLDFLAGS) $(LDFLAGS) -o $(OD)/support/postgres $(ALLMODS) $(LIBS)
	@ sh -c 'if (test $$DEVELOPMENT = "f" ) then \
		    rm -f $(ALLMODS); \
		 else true ; fi'
	@ sh -c 'if (test $$STRIPOBJS = "t" ) then \
		    strip $(OD)/support/postgres ; \
		 else true ; fi'
	@ echo linking postgres completed

POSTGRES.d: $(ALLDEPS)
	@ echo postgres dependencies complete
