#include <stdio.h>
#include "utils/geo-decls.h"

typedef struct {
	POINT	center;
	double	radius;
} CIRCLE;

CIRCLE	*circle_in();
char	*circle_out();
int	pt_in_circle();

#define LDELIM	'('
#define RDELIM	')'
#define NARGS	3

CIRCLE *
circle_in(str)
char	*str;
{
	double	atof(), tmp;
	char	*strcpy(), *p,
		*coord[NARGS], buf2[1000];
	int	i, fd;
	CIRCLE	*result;

	if (str == NULL)
		return(NULL);
	for (i = 0, p = str; *p && i < NARGS && *p != RDELIM; p++)
		if (*p == ',' || (*p == LDELIM && !i))
			coord[i++] = p + 1;
	if (i < NARGS - 1)
		return(NULL);
	result = (CIRCLE *) palloc(sizeof(CIRCLE));
	result->center.x = atof(coord[0]);
	result->center.y = atof(coord[1]);
	result->radius = atof(coord[2]);

	sprintf(buf2, "circle_in: read (%f, %f, %f)\n", result->center.x,
	result->center.y,result->radius);
	return(result);
}

char *
circle_out(circle)
CIRCLE	*circle;
{
	char	*result;

	if (circle == NULL)
		return(NULL);

	result = (char *) palloc(60);
	(void) sprintf(result, "(%g,%g,%g)",
		       circle->center.x, circle->center.y, circle->radius);
	return(result);
}

int
pt_in_circle(point, circle)
	POINT	*point;
	CIRCLE	*circle;
{
	extern double	point_dt();

	return( point_dt(point, &circle->center) < circle->radius );
}
