SCCS(1)                    UNIX Reference Manual                    SCCS(1)

NAME
     sccs - front end for the SCCS subsystem

SYNOPSIS
     sccs [-r] [-d _p_a_t_h] [-p _p_a_t_h] _c_o_m_m_a_n_d [flags] [[_f_i_l_e ...]]

DESCRIPTION
     Sccs is a front end to the SCCS programs that helps them mesh more
     cleanly with the rest of UNIX.  It also includes the capability to run
     ``set user id'' to another user to provide additional protection.

     Basically, sccs runs the command with the specified _f_l_a_g_s and _a_r_g_s.
     Each argument is normally modified to be prepended with ``SCCS/s.''.

     Flags to be interpreted by the sccs program must be before the _c_o_m_m_a_n_d
     argument.  Flags to be passed to the actual SCCS program must come
     after the _c_o_m_m_a_n_d argument.  These flags are specific to the command
     and are discussed in the documentation for that command.

     Besides the usual SCCS commands, several ``pseudo-commands'' can be
     issued.  These are: Equivalent to ``get -e''.  Perform a delta on the
     named files and then get new versions.  The new versions will have id
     keywords expanded, and will not be editable.  The -m, -p, -r, -s, and
     -y flags will be passed to delta, and the -b, -c, -e, -i, -k, -l, -s,
     and -x flags will be passed to get.  Equivalent to delget except that
     the get phase includes the -e flag.  This option is useful for making
     a _c_h_e_c_k_p_o_i_n_t of your current editing phase.  The same flags will be
     passed to delta as described above, and all the flags listed for above
     except -e and -k are passed to edit.  Creates an SCCS file , taking
     the initial contents from the file of the same name.  Any flags to
     admin are accepted.  If the creation is successful, the files are
     renamed with a comma on the front.  These should be removed when you
     are convinced that the SCCS files have been created successfully.
     Must be followed by a -r flag.  This command essentially removes the
     named delta, but leaves you with a copy of the delta with the changes
     that were in it.  It is useful for fixing small compiler bugs, etc.
     Since it doesn't leave audit trails, it should be used carefully.
     This routine removes everything from the current directory that can be
     recreated from SCCS files.  It will not remove any files being edited.
     If the -b flag is given, branches are ignored in the determination of
     whether they are being edited; this is dangerous if you are keeping
     the branches in the same directory.  This is the opposite of an edit
     or a ``get -e''.  It should be used with extreme caution, since any
     changes you made since the get will be irretrievably lost.  Gives a
     listing of all files being edited.  If the -b flag is given, branches
     (i.e., SID Ns 's with two or fewer components) are ignored.  If the -u
     flag is given (with an optional argument) then only files being edited
     by you (or the named user) are listed.  Like info except that nothing
     is printed if nothing is being edited, and a non-zero exit status is
     returned if anything is being edited.  The intent is to have this in-
     cluded in an _i_n_s_t_a_l_l entry in a makefile to insure that everything is
     included into the SCCS file before a version is installed.  Gives a
     newline-separated list of the files being edited on the standard out-
     put.  Takes the -b and -u flags like info and check.  Gives a diff
     listing between the current version of the program(s) you have out for
     editing and the versions in SCCS format.  The -r, -c, -i, -x, and -t
     flags are passed to
     get; the -l, -s, -e, -f, -h, and -b options are passed to
     diff.  The -C flag is passed to diff as -c.  This command prints out
     verbose information about the named files.

     Runs sccs as the real user rather than as whatever effective user sccs
     is ``set user id'' to.  Specifies a root directory for the SCCS files.
     The default is the current directory.  If environment variable PROJECT
     is set, it will be used to determine the -d flag.  Defines the path-
     name of the directory in which the SCCS files will be found; ``SCCS''
     is the default.  The -p flag differs from the -d flag in that the -d
     argument is prepended to the entire pathname and the -p argument is
     inserted before the final component of the pathname.  For example,
     ``sccs -d/x -py get a/b'' will convert to ``get /x/a/y/s.b''.  The in-
     tent here is to create aliases such as ``alias syssccs sccs -
     d/usr/src'' which will be used as ``syssccs get cmd/who.c''.

     Certain commands (such as admin) cannot be run ``set user id'' by all
     users, since this would allow anyone to change the authorizations.
     These commands are always run as the real user.

EXAMPLES
     To get a file for editing, edit it, and produce a new delta:

           sccs get -e file.c
           ex file.c
           sccs delta file.c

     To get a file from another directory:

           sccs -p/usr/src/sccs/s. get cc.c

     or

           sccs get /usr/src/sccs/s.cc.c

     To make a delta of a large number of files in the current directory:

           sccs delta *.c

     To get a list of files being edited that are not on branches:

           sccs info -b

     To delta everything being edited by you:

           sccs delta `sccs tell -u`

     In a makefile, to get source files from an SCCS file if it does not
     already exist:

           SRCS = <list of source files>
           $(SRCS):
                sccs get $(REL) $@

ENVIRONMENT
     The PROJECT environment variable is checked by the -d flag.  If it be-
     gins with a slash, it is taken directly; otherwise, the home directory
     of a user of that name is examined for a subdirectory ``src'' or
     ``source''.  If such a directory is found, it is used.

SEE ALSO
     admin(SCCS), chghist(SCCS), comb(SCCS), delta(SCCS), get(SCCS),
     help(SCCS), prt(SCCS), rmdel(SCCS), sccsdiff(SCCS),

HISTORY
     The sccs command appeared in

BUGS
     It should be able to take directory arguments on pseudo-commands like
     the SCCS commands do.
