
#include <sys/types.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <net/if_arp.h>
#include <netinet/if_ether.h>
#include <string.h>

extern int  errno;

main ()
{

    int			    s;
    struct  in_addr	    netmask;
    struct  ifreq	    ifr;

    strncpy (ifr.ifr_name, "ex0", sizeof (ifr.ifr_name));
    
    if ((s = socket (AF_INET, SOCK_DGRAM, 0)) < 0) {
	perror ("koe (socket)");
	exit (1);
    }

    if (ioctl (s, SIOCGIFFLAGS, &ifr)) {
	perror ("ioctl (SIOCGIFFLAGS)");
	exit (1);
    }
    printf ("0x%08lx\n", ifr.ifr_flags);

    if (ioctl (s, SIOCGIFMETRIC, &ifr)) {
	perror ("ioctl (SIOCGIFMETRIC)");
	exit (1);
    }
    printf ("0x%08lx\n", ifr.ifr_metric);

    if (ioctl (s, SIOCGIFADDR, &ifr)) {
	perror ("ioctl (SIOCGIFADDR)");
	exit (1);
    }

    netmask.s_addr =
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

    printf ("0x%08lx\n", ntohl(netmask.s_addr));

    if (ioctl (s, SIOCGIFNETMASK, &ifr)) {
	perror ("ioctl (SIOCGIFNETMASK)");
	exit (1);
    }

    netmask.s_addr =
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

    printf ("0x%08lx\n", ntohl(netmask.s_addr));

    if (ioctl (s, SIOCGIFBRDADDR, &ifr)) {
	perror ("ioctl (SIOCGIFBRDADDR)");
	exit (1);
    }

    netmask.s_addr =
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr;

    printf ("0x%08lx\n", ntohl(netmask.s_addr));

/*
    ((struct sockaddr_in *) &ifr.ifr_addr)->sin_addr.s_addr =
	htonl (0xffffff00);
    if (ioctl (s, SIOCSIFNETMASK, &ifr)) {
	perror ("ioctl (SIOCSIFNETMASK)");
	exit (1);
    }
 */

    exit (0);
}

