#ifndef lint
static char *RCSid = "$Header: /usr/src/ecn/getethers/RCS/sniffer.c,v 1.1 92/05/08 09:27:49 davy Exp $";
#endif
/*
 * sniffer.c - routines to write Network General Sniffer files.
 *
 * Ric Anderson
 * University of Arizona
 * ric@cs.arizona.edu
 *
 * $Log:	sniffer.c,v $
 * Revision 1.1  92/05/08  09:27:49  davy
 * Initial revision
 * 
 */
#include <sys/param.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <net/if_arp.h>
#include <netinet/if_ether.h>
#include <stdio.h>
#include <string.h>
#include "defs.h"

#define PADDING_SIZE 18

/*
 * sniffer_header - put out the constant stuff at top of file.
 */
sniffer_header(fp)
FILE *fp;
{
    int i;

    fprintf(fp,"station \"Broadcast\"     = addrtype \"DLC\" FFFFFFFFFFFF\n");
    fprintf(fp,"station \"Broadcast\"     = addrtype \"XNS\" FFFFFFFFFFFF\n");
    fprintf(fp,"station \"MOP Download\"  = addrtype \"DLC\" AB0000010000\n");
    fprintf(fp,"station \"DEC Rem Cons\"  = addrtype \"DLC\" AB0000020000\n");
    fprintf(fp,"station \"DEC Endnode\"   = addrtype \"DLC\" AB0000040000\n");
    fprintf(fp,"station \"DEC Routers\"   = addrtype \"DLC\" AB0000030000\n");
    fprintf(fp,"station \"LTM listnrs\"   = addrtype \"DLC\" 09002B000003\n");
    fprintf(fp,"station \"LAT units\"     = addrtype \"DLC\" 09002B00000F\n");
    fprintf(fp,"station \"NetBIOS\"       = addrtype \"DLC\" 030000000001\n");
}

/*
 * sniffer_entry - write out an ethernet address/hostname pair.
 */
sniffer_entry(h, fp)
HostInfo *h;
FILE *fp;
{
    int i;
    extern char *format_hn(), *format_enet();

    fprintf(fp,"station %s = addrtype\"DLC\" %s\n",
      format_hn(h->hl_name),format_enet(h->hl_ether));
}

/*
 * sniffer_footer - dummy routine.
 */
sniffer_footer(fp)
FILE *fp;
{
	return; /* no trailer for sniffer */
}

/*
 * format_enet - format ethernet number for printing.
 *
 *	Entry	ether = string of the form aa:bb:cc:dd:ee:ff:gg
 *			(leading zeros optional).
 *
 *	Exit	returns a string of the form aabbccddeeff
 *			with leading zeros added to each octet
 *			as needed.
 */
char *
format_enet(ether)
char *ether;
{
    int n1, n2, n3, n4, n5, n6;
    static char buf[16];

    sscanf(ether,"%x:%x:%x:%x:%x:%x:",&n1,&n2,&n3,&n4,&n5,&n6);
    sprintf(buf,"%02x%02x%02x%02x%02x%02x",n1,n2,n3,n4,n5,n6);
    return(buf);
}

/*
 * format_hn - format hostname for printing.
 */
char *
format_hn(host)
char *host;
{
    char *p;
    int i, len;
    static char buf[128];

    memset(buf,'\0',sizeof(buf));
    (void) strcpy(buf,"\"");	/* start with a " */
    p = strchr(host,'.');
    if(p != NULL)
	len = p - &host[0];
    else
	len = strlen(host);
    (void) strncat(buf,host,len);
    (void) strcat(buf,"\"");	/* and end with a " */
    for(i = strlen(buf); i < PADDING_SIZE; i++)
	buf[i] = ' ';
    return(buf);
}
