#ifndef lint
static char *RCSid = "$Header: /usr/src/ecn/getethers/RCS/excelan.c,v 1.1 91/11/27 10:56:30 davy Exp $";
#endif

/*
 * excelan.c - routines to write lanalyzer files.
 *
 * David A. Curry
 * Purdue University
 * Engineering Computer Network
 * davy@ecn.purdue.edu
 * November, 1991
 *
 * $Log:	excelan.c,v $
 * Revision 1.1  91/11/27  10:56:30  davy
 * Initial revision
 * 
 */
#include <sys/param.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <net/if_arp.h>
#include <netinet/if_ether.h>
#include <stdio.h>
#include "defs.h"

int nbytes;				/* number of bytes written	*/

/*
 * excelan_header - put out the mysterious crap at the top of the file.
 */
excelan_header(fp)
FILE *fp;
{
	int i;

	fwrite(" \20L\0\01\01", 1, 6, fp);
	fwrite("Excelan host name file", 1, 22, fp);

	for (i = 0; i < 52; i++)
		fputc('\0', fp);

	fwrite("!\20\304\t", 1, 4, fp);

	nbytes = 84;
}

/*
 * excelan_entry - write out an ethernet address/hostname pair.
 */
excelan_entry(h, fp)
HostInfo *h;
FILE *fp;
{
	int i;
	register char *p;
	struct ether_addr *ea, *ether_aton();

	/*
	 * Magic.
	 */
	fputc('\31', fp);

	/*
	 * Write the ethernet address.
	 */
	ea = ether_aton(h->hl_ether);
	fwrite(ea, 1, 6, fp);

	/*
	 * Put the hostname.
	 */
	for (i=0, p=h->hl_name; (i < 18) && (*p != '.'); i++, p++)
		fputc(*p, fp);

	/*
	 * Pad with nulls.
	 */
	for (; i < 18; i++)
		fputc('\0', fp);

	nbytes += 25;
}

/*
 * excelan_footer - pad the file to FILESIZE bytes.
 */
excelan_footer(fp)
FILE *fp;
{
	/*
	 * Put out the broadcast address.
	 */
	fputc('\31', fp);
	fwrite("\377\377\377\377\377\377", 1, 6, fp);
	fwrite("BROADCAST\0", 1, 10, fp);

	nbytes += 17;

	/*
	 * Pad the file.
	 */
	for (; nbytes < FILESIZE; nbytes++)
		fputc('\0', fp);
}
