/*  Last edited: Mar 31 19:51 1992 (mieg) */

  /*     FILE mystdlib.h
   *     Full definitions for system functions.  Adapted from Turbo C.
   *     Needed for the Sun, which is missing ANSI prototypes.
   */

#ifndef DEF_MYSTDLIB_H
#define DEF_MYSTDLIB_H

#if defined(ALLIANT) || defined (DEC)
  typedef unsigned int mysize_t ;
#else
#if defined(SGI)
  typedef unsigned mysize_t ;
#else
#if defined(NEXT) || defined(IBM)
  typedef unsigned long mysize_t ;
#else
  typedef int mysize_t ;
#endif
#endif
#endif

#ifdef DEC
typedef int mytime_t;
typedef int myFile_t;
#else
typedef long mytime_t;
typedef mysize_t myFile_t;
#endif

/* Definition of the file position type */
#if defined(SUN) 
typedef long    fpos_t;
#endif

#if defined(ALLIANT) || defined(__convex__)
  typedef long myoff_t ;
#else
  typedef fpos_t myoff_t ;
#endif

/* Constants to be used as 3rd argument for "fseek" function */
#if !defined(SGI) && !defined(ALLIANT)
#define SEEK_CUR        1
#define SEEK_END        2
#define SEEK_SET        0
#endif

/* stdio function prototypes */
int       fclose   (FILE *stream);
int       fflush   (FILE *stream);
int       fgetc    (FILE *stream);
int       ungetc   (int c, FILE *stream) ;
int       _filbuf  (FILE *stream) ;

#if  defined (DEC) || defined (SUN)
int       _flsbuf  (unsigned char x, FILE *stream) ;
#endif

int       fgetpos  (FILE *stream, fpos_t *pos);
char    * fgets    (char *s, int n, FILE *stream);
FILE    * fopen    (const char *path, const char *mode);
int       fprintf  (FILE *stream, const char *format, ...);
int       fputc    (int c, FILE *stream);
int       fputs    (const char *s, FILE *stream);

int       fscanf   (FILE *stream, const char *format, ...);
int       fseek    (FILE *stream, long offset, int whence);
int       fsetpos  (FILE *stream, const fpos_t *pos);
long      ftell    (FILE *stream);

#if !defined(__convex__) && !defined(IBM)
mysize_t  fread    (void *ptr, mysize_t size, mysize_t n, FILE *stream);
mysize_t  fwrite   (const void *ptr, mysize_t size, mysize_t n,
                          FILE *stream);
int       setvbuf  (FILE *stream, char *buf, int type, mysize_t size);
#endif

char    * gets     (char *s);
void      perror   (const char *s);
int       printf   (const char *format, ...);
int       puts     (const char *s);
void      rewind   (FILE *stream);
int       scanf    (const char *format, ...);
void      setbuf   (FILE *stream, char *buf);

/* JTM june 5, my sparc declares char * sprintf(char *s,..) and returns s */
/* RMD 4/10 mine says char* in 3S, int in 3V  -  I don't like to trust it! */
/* I cannot compile this, it conflicts with stdio.h,
     but of course we should use sprintf as returning a void 
void      sprintf  (char *buffer, const char *format, ...);
*/
int       sscanf   (const char *buffer, const char *format, ...);
char    * strerror (int errnum);

/* io.h definitions and prototypes */
#if defined(SUN) || defined(IBM)
  #define O_RDONLY 0
  #define O_WRONLY 1
  #define O_RDWR   2
  #define O_BINARY 0
#endif
#if defined(DEC) || defined(NEXT) || defined(SGI) || defined(ALLIANT)
  #define O_BINARY 0
#endif

/* #else if defined __MSDOS__ is compiled on the DEC ? */
#ifdef MSDOS 
  #define O_RDONLY 1
  #define O_WRONLY 2
  #define O_RDWR   4
  #define O_BINARY 0x8000
#endif

#ifndef OLD_STYLE_C
/* allocation prototypes */
void   * malloc    (mysize_t size);
void   * calloc    (mysize_t nitems, mysize_t size);
void     free      (void *block);
#else
char   * malloc    (mysize_t size);
char   * calloc    (mysize_t nitems, mysize_t size);
void     free      (void *block);
#endif

#if !defined(__convex__) && !defined(SGI)
/*
 *  Silicon graph declares as does Convex too...
 *  int	open(const char *, int, ...);
 */
int       open     (char *fname, int spec) ;
#endif

int       close    (int desc) ;
myFile_t  read     (int desc, void *ptr, myFile_t size) ;
myFile_t  write    (int desc, void *ptr, myFile_t size) ;
myoff_t   lseek    (int desc, myoff_t fpos, int spec) ;

/* string.h prototypes that we might use */

#if defined(DEC)
     /* missing on my DEC */
int     strcasecmp (char *a, char *b) ;  /* unix case unsensitive */
#endif

#if defined(SGI) || defined(ALLIANT) || defined(IBM) || defined(DEC) || defined(NEXT) \
       || defined (THINK_C) || defined(__convex__)
#include <string.h>
#else
char    * strcpy   (char *dest, const char *src);
char    * strncpy  (char *dest, const char *src, mysize_t maxlen);
char    * strchr   (char *str, char c) ;  
mysize_t  strlen   (const char *s);
int     strcasecmp (char *a, char *b) ;  /* unix case unsensitive */

char    * strcat   (char *dest, const char *src);
char    * strncat  (char *dest, const char *src, mysize_t maxlen);
int       strcmp   (const char *s1, const char *s2);
int       strncmp  (const char *s1, const char *s2, mysize_t maxlen);
char    * strerror (int errnum);
#endif


/* system functions and sorts */
int      system    (const char *command);
void     exit      (int status);
char   * getenv    (const char *name);
void     qsort     (void *base, mysize_t nelem, mysize_t width,
                    int  (*fcmp)(const void *, const void *));
void   * bsearch   (const void *key, const void *base,
                    mysize_t nelem, mysize_t width,
                    int  (*fcmp)(const void *, const void *));
void   * lsearch   (const void *key, void *base,
                    mysize_t *num, mysize_t width,
                    int  (*fcmp)(const void *, const void *));
void     usleep    (unsigned microseconds) ;

/* memory.h functions */

#if !defined(__convex__) && !defined(SGI) && !defined(IBM) && !defined(DEC)  
   /* SGI etc has the mem functions in string.h */
void    * memccpy  (void *dest, const void *src, int c, mysize_t n);
void    * memchr   (const void *s, int c, mysize_t n);
int       memcmp   (const void *s1, const void *s2, mysize_t n);
void    * memcpy   (void *dest, const void *src, mysize_t n);
int       memicmp  (const void *s1, const void *s2, mysize_t n);
void    * memmove  (void *dest, const void *src, mysize_t n);
void    * memset   (void *s, int c, mysize_t n);
void      movmem   (void *src, void *dest, unsigned length);
void      setmem   (void *dest, unsigned length, char value);
void      swab     (char *from, char *to, int nbytes);
#endif

/* math stuff */
#ifndef ALLIANT
double    sqrt (double x) ;
double    log (double x) ;
double    log2 (double x) ;
double    log10 (double x) ;
double    exp (double x) ;
double    pow (double x, double y) ;
#endif


#ifndef THINK_C
extern double atof(char*cp) ; /* I hope ! */
#endif


#endif


















