/*  Last edited: Feb  6 15:46 1992 (mieg) */

 
             /*********************************************/
             /* lex_bl_.h                                 */
             /* lex and block subs common structures      */
             /*********************************************/
 
/***************************************************************************/

#ifndef DEF_LEX_BL__H
#define DEF_LEX_BL__H
 
#include "disk__.h"   /* defines BP and DISK */

typedef struct alloc *ALLOCP;    /*control structure of the cache*/
struct alloc        { BP p;
                      int ispinned;
                      int ismodified;
                      ALLOCP up,next,right ;
                    }
                      ; 
 
typedef unsigned int LEXOFFST;    /*offset in the vocabulary */
 
typedef struct lexalpha 
        {KEY key;       /*a provision if we want to shift*/
                        /*some of the vocabulary to disk */
        } LEXA, *LEXAP;
 
typedef struct lexique    
        {LEXOFFST nameoffset;  /*name of the object*/
	 DISK diskaddr;        /* its disk address, also used to keep the alias key*/
	 ALLOCP addr;      /* addr->p is its memory address*/
	 void * cache;       /* address in the secondary cache */
	 unsigned char lock;   /* flow control */
       } LEXI, *LEXP;
 
#define lexiFormat "i3vc"
#define SIZELEX sizeof(struct lexique)
 
 
void lexmark(int table);
DISK lexDisk(KEY key) ;
LEXP KEY2LEX(KEY kk); /* returns q if(iskey(kk)), 0 otherwise */

#endif
 


