/*  Last edited: Feb 20 19:38 1992 (mieg) */



                    /*lex.h                             */
                    /* public functions in lexsubs.c    */
                    /* dealing with the lexique*/

int lexMax(int t) ;  /* Numbers of entries in the t lexique */
int vocMax(int t) ;
int  iskey(KEY kk);
                      /* Returns 0 if kk is unknown,
                       * 1 if kk is just a vocabulary entry
                       * 2 if kk corresponds to a full object
                       */
BOOL  iskeyold(KEY kk);
                      /* TRUE if key is on disk or in first cache */
BOOL  lexReClass(KEY key,KEY *kp, int t);
BOOL  lexClassKey(char *cp,KEY *kp) ; /* Recognises class:name */
BOOL  lexword2key(char *cp,KEY *kp, int t);
                           /*given a word *cp, sets its key *kp */
                           /* search done in t lexique */
                           /*returns TRUE if found, FALSE if not */

BOOL nextName(KEY key, char **cpp)  ;
                           /* Runs along tha aliases of key,
			    * on first call *cpp should be null
			    */  
BOOL lexAlias(KEY key, char *newName, BOOL doAsk, BOOL keepBothNames) ;
                 /* lexCleanUp newName and modify the lexique
		    return TRUE if newName is accepted
		    FALSE if error or newName corresponds to some
		    other object
		    */


BOOL   lexaddkey(char *cp,KEY *kp, int t);
                  /*add to the t lexique the word *cp */
               /*returns TRUE if added, FALSE if known, crashes if Full */

int  lexstrcmp(char *a,char *b);
   /*returns 1 if *a>*b  or 0 or -1 as strcmp but is case unsensitive*/
   /*This is used to better the presentation, yet avoid doubles*/
BOOL lexNext(int n,KEY *p); /*gives the next KEY in table n*/
KEY lexLastKey(int class) ;
/* KEY lexrandomkey(KEY); gives a random allocated key in same voc*/
  /* renamed blockfriend */
  /* JTM oct 30, lex continuation key system obsolete and discarded */

void lexkill(KEY key);      /*deallocates a key*/
void lexshow (void) ;   /* RMD 6/19/90 */
void lexInit(void);            /*Called at beginning of program*/
void lexRead(void);            /*Called at beginning of program*/
BOOL lexSave(void) ;
int lexavail(unsigned long *keynum,
             unsigned long *vocspace,unsigned long *vocnum);

#define LOCKSTATUS  (unsigned char)1      /* bits 1 and 2 are reset to 0 by lexiread */
#define CALCULSTATUS  (unsigned char)2    /* all bits are reset by lexAlias */
#define EMPTYSTATUS (unsigned char)4
#define ALIASSTATUS (unsigned char)8

#define LEXPRIVATESTATUS (unsigned char) 9  /* bits 1 8 are protected in lexsetstatus */

void lexSetStatus(KEY key, unsigned char c) ;
void lexUnsetStatus(KEY key, unsigned char c) ;
unsigned char lexGetStatus(KEY key) ;
void lexunlock(KEY key) ; /* these 2 check for double locking */
BOOL lexlock(KEY key) ;
#define lexiskeylocked(key) (lexGetStatus(key) & LOCKSTATUS)


/***/




