/*  Last edited: Feb  5 17:11 1992 (mieg) */

/* wh/ibmdir.h
    copied from /usr/include/sys/dir.h on an ibm risc 6000
    and simplified, the original failing to compile
    with acedb
    
     adaptation, mieg, 4 fev 1992
  */


#define _D_NAME_MAX 255

typedef unsigned char   uchar_t;
typedef unsigned short  ushort_t;
typedef unsigned int    uint_t;
typedef unsigned long   ulong_t;

typedef struct { int r[1]; } *  physadr_t;
typedef long            level_t;
typedef long            daddr_t;        /* disk address */
typedef char *          caddr_t;        /* "core" (i.e. memory) address */
typedef ulong_t         ino_t;          /* inode number (filesystem) */
typedef short           cnt_t;
typedef ulong_t         dev_t;          /* device number (major+minor) */
typedef long            chan_t;         /* channel number (minor's minor) */
typedef long            off_t;          /* file offset */
typedef long            paddr_t;
typedef long            key_t;

struct	dirent {
	ulong_t		d_offset;	/* real off after this entry */
	ino_t		d_ino;		/* inode number of entry */
					/* make ino_t when it's ulong */
	ushort_t	d_reclen;	/* length of this record */
	ushort_t	d_namlen;	/* length of string in d_name */
	char	        d_name[_D_NAME_MAX+1];	/* name must be no longer than this */
					/* redefine w/#define when name decided */
};

/*
 * Definitions for library routines operating on directories.
 */
typedef struct _dirdesc {
	int	dd_fd;		/* file descriptor of directory */
	int	dd_blksize;	/* this filesystem's block size */
	char	*dd_buf;	/* malloc'd buffer depending of fs bsize */
	long	dd_size;	/* size of buffer */
	long	dd_flag;	/* private flags for readdir, unused */
	long	dd_loc;		/* logical(dirent) offset in  directory */
	long	dd_curoff;	/* real offset in directory corresponding
				 * to dd_loc */
} DIR;

extern  DIR *opendir(char *dirname);
extern  struct dirent *readdir(DIR *dirp);
extern  int closedir(DIR *dirp);
extern  void rewinddir(DIR *dirp);


extern void seekdir(DIR *dirp, long loc);
extern long telldir(DIR *dirp);



#define	DEV_BSIZE	512
#define	DIRBLKSIZ	512

#define DIRSIZ(dp) \
    ((sizeof (struct dirent) - (_D_NAME_MAX+1)) + (((dp)->d_namlen+1 + 3) &~ 3))

#ifdef _KERNEL

#ifdef    _AIXFS
# include	"aixfs/dir.h"
#else  /* _AIXFS */
# include	"jfs/dir.h"
#endif /* _AIXFS */

#endif  /* _KERNEL */


#define direct dirent

#ifdef	_SUN
#define dd_bsize	dd_blksize	/* ala sun */
#define d_fileno	d_ino		/* ala sun */
#endif	/* _SUN */

