/*  File: grid.h
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: header file for griddisp functions
 * Exported functions: gridCluster(), GRIDMAP structure
 * HISTORY:
 * Last edited: Mar 10 20:34 1992 (mieg)
 * Created: Mon Jan  6 18:58:11 1992 (rd)
 *-------------------------------------------------------------------
 */

#include "array.h"

typedef struct
  { KEY ctg ;
    float x ;
    int clump ;	   /* pos->clump filled with map index */
  } GRIDMAP ;

void gridCluster (Array pos, Array map) ; 
BOOL gridClusterKey (KEY key, Array map) ;

/********* end of file ********/
