/* graphxt_.h
   version of graph.h for inclusion within graphics package in
     files that use X11 (Athena Widgets and Intrinsics) calls.
   contains device dependent private information and then 
     includes graph_.h, which declares device independent private 
     information and includes graph.h (public information).
*/

#include<X11/Intrinsic.h>
#include<X11/StringDefs.h>
#include<X11/Shell.h>

struct DevStruct
  { BOOL   isExposed ;  /* do not draw until exposed */
    Widget popup ;	/* outer parent */
    Widget simple ;	/* basic graph */
    Widget viewport ;	/* viewport onto simple for scrolling */
    Widget menuWidget ;
    void  (*menuProc)(KEY) ;
    void*  message ;	/* actually a Graph */
  } ;

extern XtAppContext app_con;	/* application context */
extern Widget root_widget;	/* parent of all */
extern void promptReturn (Widget w, XEvent* ev, String *params, Cardinal *num_params) ;

#define DEV_DEFINED

#include "graph_.h"
 
/****** end of file ******/
