/*  Last edited: Mar  3 20:00 1992 (mieg) */

/* graph_.h
   version of graph.h for inclusion within graphics package
   contains device independent private information and then 
     includes graph.h (public information).
   use graphx_.h, graphsun_.h etc to get at device dependent stuff
*/

#ifndef DEF_GRAPH__H
#define DEF_GRAPH__H

#include "array.h"

#define GRAPH_MAGIC     17864

#ifdef DEV_DEFINED
  typedef struct DevStruct *Dev ;
  #define DEV_SIZE        sizeof(struct DevStruct)
#else
  typedef void *Dev ;
#endif

#define NEVENTS 14

typedef struct GraphStruct
  { int           magic ;         /* check for is a graph */
    char          *name ;
    int           id ;            /* unique graph number for process */
    int           type ;          /* from enum GraphType */

    float         ux,uy,uw,uh ;   /* user boundaries */
    float         aspect ;        /* x units per inch / y units per inch */
    int           xWin,yWin ;     /* userToWin offsets */
    float         xFac,yFac ;     /*  and scale factors */
    int           h,w ;           /* device coords (0,0) to (w-1,h-1) */
    void          (*func[NEVENTS])() ;
    float         pointsize ;
    float         linewidth ;
    float         textheight ;
    int           color ;
    Dev           dev ;           /* windows system specific stuff */
    Array         boxes ;
    Stack         stack ;
    int           nbox ;
    int           currbox ;
    BOOL          isClear ;
    Stack         boxstack ;
    Associator    assoc ;
    char*         help ;
    Associator    buttonAss ;
    struct GraphStruct
                  *nxt ;
  } *Graph_ ;

#define GRAPH_SIZE      sizeof(struct GraphStruct)

#include "graph.h" /* public externals: must come after Graph definition */

typedef struct BoxStruct
        { float     x1,y1,x2,y2 ;
          int       mark ;
          float     linewidth ;
          float     textheight ;
          float     pointsize ;
          unsigned char   fcol,bcol ;
	  unsigned char   flag ;
        } *Box ;
enum GraphAction
        { LINE, RECTANGLE, FILL_RECTANGLE, CIRCLE, POINT, TEXT, TEXT_PTR,
          COLOR, TEXT_HEIGHT, LINE_WIDTH, POINT_SIZE,
          BOX_START, BOX_END
        } ;
 
#define GRAPH_BOX_NOPICK_FLAG 0x01

        /* externals only for use within graph package: gXxxx */

extern Graph_   gActive ;       /* active graph */
extern Dev      gDev ;          /* gActive->dev */
extern Box      gBox ;          /* active box from gActive */
extern Stack    gStk ;          /* gActive->stack */
extern float    gPixAspect ;    /* device x:y pixel ratio */
extern int      gIsCreating ;   /* for Activate control during Creation */

#define uToXrel(x) (int)(gActive->xFac*(x))
#define uToYrel(x) (int)(gActive->yFac*(x))
#define uToXabs(x) (-gActive->xWin + uToXrel(x))
#define uToYabs(x) (-gActive->yWin + uToYrel(x))
#define XtoUrel(x) ((x)/gActive->xFac)
#define YtoUrel(x) ((x)/gActive->yFac)
#define XtoUabs(x) XtoUrel((x)+gActive->xWin)
#define YtoUabs(x) YtoUrel((x)+gActive->yWin)

void graphFacMake (void) ;
void graphDevInit (int *argcptr, char **argv) ;
void graphDevFinish (void) ;
void graphDevActivate (int flag) ;
void graphDevCreate (Graph_ g, float x, float y, float w, float h) ;
void graphDevDestroy (void) ;
void devMenuDestroy (void) ;
void graphClipDraw (int xmin, int ymin, int xmax, int ymax) ;
void graphWhiteOut (void) ;	/* used to clear screen */

Box  gBoxGet (int k) ;             /* gets Box pointer for index k */
void gLeftDown (float x, float y) ;
void gBoxClear (Box box) ;
BOOL gFontInfo (int height, int* w, int* h) ;
void gUpdateBox0 (void) ;

void graphDevTextFacSet (void) ;   /* sets fac according to text */

#endif

/***** end of file ********/
