/*  Last edited: Apr  2 14:32 1992 (mieg) */

/* Public header file for the graph package of acedb.
   The private header file for internal use is graph_.h.
   This package requires the array and messubs packages.
   Richard Durbin plus Jean Thierry-Mieg, Christopher Lee
*/

#ifndef DEF_GRAPH_H
#define DEF_GRAPH_H
 
typedef int Graph ;             /* really graph->id, hide  data structure */
  /* These colors match those declared in systags, they must appear in the same order */	
enum Colour    {WHITE, BLACK, LIGHTGRAY, DARKGRAY,
                RED, GREEN, BLUE,
                YELLOW, CYAN, MAGENTA,
		LIGHTRED, LIGHTGREEN, LIGHTBLUE,
		DARKRED, DARKGREEN, DARKBLUE,
		NUM_TRUECOLORS,
                TRANSPARENT  /* TRANSPARENT pseudocolour only for background */
               } ;
#define BACK_COLOR WHITE
#define FORE_COLOR BLACK
	/* max 256 colours (box->fcol, bcol are unsigend char) */

/* GraphEvent note the mouse events are required to be continuous in
   this way. Can't touch the order */
enum GraphEvent {LEFT_DOWN, LEFT_DRAG, LEFT_UP,
		 MIDDLE_DOWN, MIDDLE_DRAG, MIDDLE_UP,
		 RIGHT_DOWN, RIGHT_DRAG, RIGHT_UP,
		 PICK, KEYBOARD, RESIZE, 
		 MESSAGE_DESTROY,
		 DESTROY	       	/* DESTROY must be last */
		} ;
typedef void (*GraphFunc)() ;
typedef void (*GraphCompletionFunc)(char *text, int len) ;

   /* If you chnge the enumeration of graphTypes, 
    * change also the function pickGetGraphTypes
    */

enum GraphType  { PLAIN, TEXT_SCROLL, TEXT_FIT, MAP_SCROLL} ;
 
extern int      intFlag ;
extern int      isGraphics ;            /* global for presence of graphics */
extern FREEOPT  graphColors[] ;         /* defined in graphDevSubs.c */

/************ functions ***********/
 
void    graphInit (int *argcptr, char **argv) ;
void    graphFinish (void) ;
void    graphCleanUp (void) ;
void    graphStart (Graph g) ;          /* starts notifier loop system */
void    graphControl (void) ;           /* freesubs multigraph controller */
BOOL    graphExists (Graph g) ;		/* is g a valid graph? */
 
                    /* interpose in graphPanelCreate  etc */
extern void     (*gCreateRoutine)(Graph g) ;
Graph   graphCreate (int type, 		/* of enum graphType */
		     char *name, 	/* used on title bar */
		     float x, float y, float w, float h) ;
                /* x,y,w,h are in units of screen height = 1.0 */
BOOL    graphActivate (Graph graph) ;	/* returns graphExists() */
Graph   graphActive (void) ;            /* returns active graph */
 
                /* everything from here on acts on active graph */
void    graphDestroy (void) ;
void    graphDump (void) ;              /* for debugging */
int     graphBlock (void) ;		/* local looping */
void    graphUnBlock (int retval) ;	/* causes return from loop */

BOOL    uGraphAssociate (void* in, void* out) ;
#define graphAssociate(xin,xout)   uGraphAssociate((void*)(xin),(void*)(xout))
BOOL    uGraphAssFind (void *in, void* *out) ;
#define graphAssFind(xin,pxout)	uGraphAssFind(xin,(void**)(pxout))
BOOL    graphAssRemove (void *in) ;

void    graphPlainBounds (float ux, float uy, float uw, float uh, float aspect) ;
void    graphMapBounds (float ux, float uy, float uw, float uh, float aspect) ;
void    graphTextBounds (int nx, int ny) ;
void	graphFitBounds (int *nx, int *ny) ;  /* no scroll - in text coords */
       /* JTM 17-3-91 to mix text legends inside a PLAIN graph */
void graphTextInfo(int *nx, int *ny, float *cw, float *ch) ;

void    graphGoto (float x, float y) ;  /* tries to center (x,y) in screen */
void    graphRedraw (void) ;            /* complete redraw */
void    graphClear (void) ;
void    graphRetitle (char *name) ;
void    graphPop (void) ;
void    graphMessage (char *text) ;
void    graphUnMessage (void) ;
void    graphPrint(void);   /* JTM, to simplify the application codes */
void    graphPS (char *basename) ;
void    graphEvent (int action, float x, float y) ;     /* posts an event */
 
int     graphBoxStart(void) ;           /* returns box number */
void    graphBoxEnd (void) ;
void    graphBoxClear(int k) ;
void    graphBoxDim (int k, float *x1, float *y1, float *x2, float *y2) ;
void    graphBoxDraw (int kbox, int fcol, int bcol) ;
void    graphBoxDrag (int k, void (*clientRoutine)(float*,float*,BOOL)) ;
void    graphBoxDragInit (int k, void (*clientRoutine)(float*,float*,BOOL),
		      double x, double y) ;
void    graphBoxShift (int box, float xbase, float ybase) ;
void	graphBoxSetPick (int box, BOOL pick) ;

int	graphTextEntry (char* cp, int len,  float x, float y, void (*fn)()) ;
int     graphCompletionEntry (GraphCompletionFunc f, char* text, int len, float x, float y, void (*fn)()) ;
void	graphEntryDisable (void) ; /* disables TextEntries */
 
void    graphLine (float x0, float y0, float x1, float y1) ;
void    graphRectangle (float x0, float y0, float x1, float y1) ;
void    graphFillRectangle (float x0, float y0, float x1, float y1) ;
void    graphCircle (float xcen, float ycen, float rad) ;
void    graphPoint (float x, float y) ;
void    graphText (char *text, float x0, float y0) ;
void    graphTextPtr (char *text, float x0, float y0, int length) ; 
     	   /* updatable text - length is length to extend the box */
 
	/* the next routines does not add to the box : used for cursors */
void    graphXorLine (float x0, float y0, float x1, float y1) ;
void	graphXorBox (int kbox, float x, float y) ;

      /* The following routines all return the old value, and just return the
         current value if given a negative argument (except graphRegister).
      */
float   graphPointsize (float x) ;
float   graphLinewidth (float x) ;
float   graphTextHeight (float height) ;   /* if 0.0 then standard text */
int     graphColor (int color) ;                /* color is a GraphColor */
GraphFunc
        graphRegister (int k, GraphFunc) ;      /* k is a GraphEvent */
char*   graphHelp (char* item) ;

/* routines from old dev.h.   
   Input/output routines that wait on user response.
   These are graphics system dependent - the sunview versions are
     in sunsubs.c, and the Xt versions are currently in graphxt.c.
   Plus buttons.
*/

typedef struct menuopt
  { void (*f)(void);
    char *text;
  } MENUOPT ;
typedef void (*MenuRoutine)(KEY) ;

void graphOut (char *text) ;
BOOL graphQuery (char *text) ;
BOOL graphPrompt (char *prompt, char *dfault, char *fmt) ;
 /* gets new card for freesubs */
BOOL graphSelect (KEY *kpt, FREEOPT *options) ;
void graphFreeMenu (MenuRoutine proc, FREEOPT *options) ;
void graphMenu (MENUOPT* menu) ;
 
int  graphButton (char* text, VoidRoutine func, float x, float y) ;
void graphButtons (MENUOPT *buttons, float x0, float y0, float xmax) ;
#endif
