/*  Last edited: Apr  2 18:18 1992 (mieg) */

#ifndef DEFINE_DISPLAY_h
#define DEFINE_DISPLAY_h

#include "graph.h"
#include "keyset.h"
#include "disptype.wrm"

typedef BOOL (*DisplayFunc)(KEY key, KEY from, BOOL isOld) ;
extern DisplayFunc displayFunc[] ;
typedef BOOL (*ParseFunc)(int level, KEY key) ;
extern ParseFunc parseFunc[] ;
typedef BOOL (*DumpFunc)(FILE *f, Stack s, Array a) ;
extern DumpFunc dumpFunc[] ;

typedef void (*BlockFunc)(KEY) ;
BOOL	display (KEY key, KEY from, int displaytype) ;
Graph   displayCreate(DISPLAYTYPE d) ; /* in picksubs.c, 
     graphCreate(), importing title and positions from wspec/displays.wrm  */
void	displayPreserve (void) ;

BOOL	displayBlock (BlockFunc func, char * message) ;	/* call func on next picked key */
void    displayUnBlock (void) ;
void    displayRepeatBlock (void) ;
BOOL	isDisplayBlocked (void) ;

void*	keySetShow (KEYSET set, void* handle) ;
KEY	keySetCurrent (void* handle, KEY k) ;

void    externalDisplay (KEY key) ;
#endif




