/*  Last edited: Nov 18 18:38 1991 (rd) */


                     /* disk.h                             */
                     /* public functions of disksubs.c     */
                     /* handling the disk.                 */

#ifndef DEFINE_DISK_H
#define DISK_H

#ifndef DEF_BP
#define DEF_BP
typedef void* BP ;
#endif

#ifndef DEF_DISK
#define DEF_DISK
typedef void* DISK ;
#endif
 
 
void diskPrepare    (void);
                      /*To be called once in the disk lifetime*/
                      /*prepares DISKSIZE blocks of storage and the*/
                      /*corresponding BAT file */
void diskSave(void) ; 
                      /* Rewrites the Block allocation table BAT*/
                      /* of the main database file */
void diskWriteSuperBlock(BP bp) ;
                      /* General database management */
void diskavail(int *free,int *used, int *plus, int *minus) ;
                      /*gives disk statistics*/
void diskalloc      (BP bp);
                      /*modifies the BAT and gives a free block address*/
                      /* in sequence */
void diskfree       (BP bp) ;
                      /* returns d to the BAT */
void diskblockread  (BP p,DISK d); /*writes a block to disk*/
void diskblockwrite (BP p); /*writes a block to disk*/
BOOL saveAll(void) ; 
 
#endif


