/*  Last edited: Mar 10 03:44 1992 (mieg) */
   /* wh/bs.h   Public functions of the bs package */
#ifndef DEFINE_BS_h
#define DEFINE_BS_h

#include "keyset.h"		/* need Array for bsFlatten */

#ifndef DEFINE_OBJ
#define DEFINE_OBJ
  typedef void* OBJ ;
#endif

/***************************************************************/
/*  classType 'B' : BS Trees, public functions.                */
/***************************************************************/

typedef union			/* structure for unknown types */
  { int	  i ;
    float f ;
    KEY   k ;
    char* s ;
  } BSunit ;
 
/* 4 functions to grab or release a BS tree in the object cache */
                                /* read only */
OBJ bsCreate(KEY key) ;
                                /* read write 
				 * If you write priviledged code using bs__.h  
                                 * please call objMark() before touching
                                 * to prevent read only access by another
                                 * window */
OBJ bsUpdate(KEY key) ; 
    
                            /* disregard recent updates */
void  bsDoDestroy(OBJ obj) ;
#define bsDestroy(obj)   (bsDoDestroy(obj) , (obj) = 0 ) 

                                 /* validates the latest update */
                                /* provided a call to objMark was made */
void bsDoSave        (OBJ obj) ;
#define bsSave(obj)    (bsDoSave(obj) , (obj) = 0 ) 

                            /* Zero and object and lexSets EMPTYSTATUS */
                            /* obj must be grabbed bsUpdate() */
void bsDoKill        (OBJ obj) ;
#define bsKill(obj)    (bsDoKill(obj) , (obj) = 0 ) 

     /* Several sorts of dumps */
void bsDump        (OBJ obj) ;             /* dumps on stdout in debug format */

void bsAceDump     (OBJ obj, FILE *fil) ;  /* ace dump a B Tree  */
void bsAsnDump     (OBJ obj, FILE *fil) ;  /*Xsy asn dump a B Tree  */

 
    /* functions for local manipulations of branches and leaves */

/* when you start a series of operations on a BS 
   never start with a _bsDown, _bsRight.
*/
 
BOOL bsFindTag     (OBJ obj, KEY tag) ;                 /* locates curr at tag */
BOOL bsFindKey     (OBJ obj, KEY target, KEY key) ;     /* locates curr at key */
BOOL bsGetKey      (OBJ obj, KEY target, KEY *found) ;  /* Just keys */
BOOL bsGetKeyTags  (OBJ obj, KEY target, KEY *found) ;  /* Also tags */
BOOL bsGetData     (OBJ obj, KEY target, KEY type, void *x) ;
BOOL bsGetObj      (OBJ obj, KEY target, OBJ *objp) ;  /* Gets a #Class sub tree */
BOOL bsFlatten     (OBJ obj, int n, Array units) ; /* flattens tree n deep */
KEYSET bsVisibleKeySet(KEY key) ; 
     /* Collects all visible keys in object bsCreate(key) */

BOOL bsAddTag      (OBJ obj, KEY tag) ;
BOOL bsAddKey      (OBJ obj, KEY target, KEY new) ;
BOOL bsAddData     (OBJ obj, KEY target, KEY type, void *data) ;
BOOL bsAddComment  (OBJ obj, char* text, char type) ;
BOOL bsAddObj      (OBJ obj, KEY target, OBJ *objp) ;
KEY  bsType        (OBJ obj, KEY target) ;  /* what if we add to curr ? */
BOOL bsTypeCheck   (OBJ obj, KEY new) ;	    /* does new fit modCurr ? */

BOOL bsRemove      (OBJ obj) ; /* removes curr and subtree to right */
BOOL bsPrune	   (OBJ obj) ; /* prunes back unique branch to curr */

typedef void*      BSMARK ;	       /* private handle */
BSMARK  bsMark     (OBJ obj, BSMARK mark) ; /* preserve's current tree position */
void    bsGoto     (OBJ obj, BSMARK mark) ; /* returns to mark */
#define bsMarkFree(x)	messfree(x)

int cacheSaveAll(void) ;
int cacheStatus (int *used, int *locked, int*known, int *modified) ;
 
void BSstatus (int *used, int *alloc) ;	/* for status */
void BTstatus (int *used, int *alloc) ;

 #endif
/******************************************************************/
 
 
 




