/*  Last edited: Mar 13 20:44 1992 (mieg) */

  /* The pupose of this stand alone is to resolve the orthograph conflicts
     in author names. It takes as  arguments, a homonym file of the form

correct_name AA =
alias1 posibly with several words =
alias2 no double quotes expected 
dummyentry
newname =
newalias

   and reads from an ace file.
   It will act only on the author entries of the ace file and, on these
   will replace the occurences of alias by the correct name 
   */
#define ARRAY_NO_CHECK
#include "regular.h"
#include "array.h"

static Stack ss = 0 ;
static Array alias = 0 ;
static int line = 0, transfo = 0 ;

typedef struct {int bad; int good; } ALIAS ;

/****************************************************************/

static void scanInput(void)
{  char *cp , cutter ; register int i ;

 fprintf(stderr,"I begin the scan line %d\n", line) ;
  while(line++ , freeread(stdin))
    { cp = freeword() ;
      if(!cp)
	{ printf("\n") ; continue ;}
      if (   strcmp("Author",cp)
          && strcmp("Mapper",cp)
          && strcmp("From_Author",cp)
          && strcmp("Representative",cp)
	  )  /* Just copy the whole line to the output */
	{ freeback() ;
	  printf(freewordcut("\n",&cutter)) ;
	  printf("\n") ;
	  continue ;
	}
          /* Found author, do check */
      printf("%s : \"",cp) ;
      freenext() ; freestep(':') ; freenext() ;
      cp = freeword() ;
      if(cp)
	{ i = arrayMax(alias) ;
	  while(i--)
	    if(!strcmp(cp,stackText(ss,arr(alias,i,ALIAS).bad)))
	      { cp = stackText(ss,arr(alias,i,ALIAS).good) ;
		transfo++ ;
		break ;
	      }
	  printf(cp) ;
	}
      printf("\"\n") ;
    }
}


/****************************************************************/

static BOOL readRules(char *name)
{
  FILE *f = fopen(name,"r") ;
  int nA = 0 , n ;
  char *cp , *cq , cutter ;
  BOOL found = FALSE ;
  int lastnA = 0 ;

  if(!f)
    { fprintf(stdout, "Cannot open the homonym file %s", name) ;
      return FALSE ;
    }

  ss = stackCreate(1000) ;
  alias = arrayCreate(100, ALIAS) ;

  while (freeread(f))
   if(cp = freewordcut("\n",&cutter))
     { cq = cp + strlen(cp) - 1 ;
       while(cq > cp && *cq == ' ') cq--;
       if(*cq == '=')
	 { *cq = ' ' ;
           found = TRUE ;
	   while(cq > cp && *cq == ' ') cq--;
	   *++cq = 0 ;
	   n = stackMark(ss) ;
	   pushText(ss,cp) ;
           array(alias, nA++,ALIAS).bad = n ;
	 }
       else
	 if (found)
	   { found = FALSE ;
	     *++cq = 0 ;
	     n = stackMark(ss) ;
	     pushText(ss,cp) ;
	     for ( ;lastnA <nA; lastnA++)
	       array(alias, lastnA,ALIAS).good = n ;
	   }
     }
  fprintf(stderr,"Found %d alias to eliminate\n",nA) ;
  fclose(f) ;
  return nA > 0 ? TRUE : FALSE ;
}

/****************************************************************/

void main (int argc, char **arg)
{
  if (argc != 2)
    { fprintf (stderr,
	       "Usage : homonym homoFile < input > output \n") ;
      return ;
    }
 
  freeinit() ;
  if(readRules(arg[1]))
    scanInput() ; 

  fprintf(stderr,"\n done, scanned %d lines, did %d transformations\n",
	  line, transfo) ;
}

/****************************************************************/
/****************************************************************/



