/*  Last edited: Nov 18 13:36 1991 (mieg) */
/* acediff.c -- makes a difference file from two ace files
**
** Usage: acediff f1 f2 > f3
**
** Part of the acedb genome database,
** 	R. Durbin and J. Thierry-Mieg, 1991
*/


#include "regular.h"
#include "array.h"

extern char* freepos(void) ;

#define Text(z) (stackText(z,0))

void oneLine (FILE *in, FILE *out)
{
  BOOL  inObject = FALSE ;
  Stack obName ;
  char  *word ;
  int   line = 0 ;

  obName = stackCreate(128) ;

  while (freeread (in))
    { ++line ;
      if (inObject)
	if (*freepos())
	  fprintf (out,"%8d %s %s\n", line, Text(obName), freepos()) ;
	else
	  inObject = FALSE ;
      else if (word = freeword())
	{ stackClear (obName) ;
	  catText (obName, word) ;
	  freestep (':') ;
	  if (!(word = freeword()))
	    messcrash ("Error with object name line %d",line) ;
	  catText (obName," ") ;
	  catText (obName,word) ;
	  inObject = TRUE ;
	}
    }

  fprintf (stderr, "%d lines read",line) ;
  stackDestroy (obName) ;
  fclose (in) ;
  fclose (out) ;
}

BOOL getLine (FILE *in, int *line, Stack obName, Stack data)
{
  char* cp ;
  int len ;

  stackClear (obName) ;
  stackClear (data) ;
  if (!freeread (in))
    return FALSE ;
  freeint (line) ;
  catText (obName, freeword()) ;
  catText (obName, " ") ;
  catText (obName, freeword()) ;
  cp = freepos() ;
  if ((len = strlen(cp) > 1) 
      && cp[len-1] == '\"' && cp[len-2] != '\\')
    cp[len-1] = 0 ;
  catText (data, cp) ;
  return TRUE ;
}

void processDiff (FILE *inA, FILE *inB, FILE *out)
{
  int	lineA, lineB, cmpClass, cmpData ;
  Stack	obNameA, obNameB, dataA, dataB ;

  obNameA = stackCreate (64) ;
  dataA = stackCreate (64) ;
  obNameB = stackCreate (64) ;
  dataB = stackCreate (64) ;

  getLine (inA, &lineA, obNameA, dataA) ;
  getLine (inB, &lineB, obNameB, dataB) ;

  while (!feof (inA) || !feof (inB))
    { if (feof(inB))
	cmpClass = -1 ;
      else if (feof(inA))
	cmpClass = 1 ;
      else
	{ cmpClass = strcmp (Text(obNameA), Text(obNameB)) ;
	  cmpData = strcmp (Text(dataA), Text(dataB)) ;
	}

      if (cmpClass < 0 || (cmpClass == 0  &&  cmpData < 0))
	{ fprintf (out, "%8d %s -D %s\n", 
		   lineA, Text(obNameA), Text(dataA)) ;
	  getLine (inA, &lineA, obNameA, dataA) ;
	}
      else if (cmpClass > 0 || (cmpClass == 0  &&  cmpData > 0))
	{ fprintf (out, "%8d %s %s\n", 
		   50000000+lineB, Text(obNameB), Text(dataB)) ;
	  getLine (inB, &lineB, obNameB, dataB) ;
	}
      else
	{ getLine (inA, &lineA, obNameA, dataA) ;
	  getLine (inB, &lineB, obNameB, dataB) ;
	}
    }

  stackDestroy (obNameA) ;
  stackDestroy (dataA) ;
  stackDestroy (obNameB) ;
  stackDestroy (dataB) ;
  fclose (inA) ;
  fclose (inB) ;
  fclose (out) ;
}

void diff2ace (FILE *in, FILE *out)
{
  int line ;
  Stack obName, obCurr, data ;

  obName = stackCreate (64) ;
  obCurr = stackCreate (64) ;
  data = stackCreate (64) ;

  while (getLine (in, &line, obName, data))
    { if (strcmp (Text(obName),Text(obCurr)))
	{ fprintf (out,"\n%s\n", Text(obName)) ;
	  stackClear (obCurr) ;
	  catText (obCurr, Text(obName)) ;
	}
      fprintf (out,"%s\n", Text(data)) ;
    }

  stackDestroy (obName) ;
  stackDestroy (obCurr) ;
  stackDestroy (data) ;
  fclose (in) ;
  fclose (out) ;
}

void main (int argc, char **argv)
{
  FILE *inA, *inB, *tmpA, *tmpB, *tmpC ;

  if (argc != 3)
    { fprintf (stderr, "Usage: acediff oldfile newfile > diff\n") ;
      return ;
    }

  freeinit () ;

  inA = fopen (argv[1],"r") ;
  inB = fopen (argv[2],"r") ;
  tmpA = fopen ("tempA1","w") ;
  tmpB = fopen ("tempB1","w") ;
  if (!inA || !inB || !tmpA || !tmpB)
    { fprintf (stderr, "problems opening files - aborting\n") ;
      return ;
    }

  fprintf (stderr,"reading file 1 - ") ;
  fflush (stderr) ;
  oneLine (inA,tmpA) ;
  fprintf (stderr," - sorting file 1\n") ;
  system ("sort -T . +1 tempA1 -o tempA2") ;

  fprintf (stderr,"reading file 2 - ") ;
  fflush (stderr) ;
  oneLine (inB,tmpB) ;
  fprintf (stderr," - sorting file 2\n") ;
  system ("sort -T . +1 tempB1 -o tempB2") ;

  fprintf (stderr,"performing diff\n") ;
  tmpA = fopen ("tempA2","r") ;
  tmpB = fopen ("tempB2","r") ;
  tmpC = fopen ("tempC1","w") ;
  processDiff (tmpA, tmpB, tmpC) ;
  system ("sort -T . +1 -3 +0 -1 tempC1 -o tempC2") ;

  tmpC = fopen ("tempC2","r") ;

  fprintf (stdout,"// acediff difference from %s to %s\n",
	   argv[1],argv[2]) ;

  diff2ace (tmpC, stdout) ;

  fprintf (stdout,"\n// end of file\n") ;
}
