/*  File: nmer.c
 *  Author: Richard Durbin (rd@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: freesubs based package to explore 6mer frequency 
 		tables.
 * Exported functions:
 * HISTORY:
 * Last edited: Mar  4 01:58 1992 (rd)
 * Created: Sat Oct 12 22:26:53 1991 (rd)
 *-------------------------------------------------------------------
 */

#include "regular.h"
#include "heap.h"
#include "array.h"
#include "bs.h"

/**************************************************/
/****************** Table package *****************/

static BOOL isHex = TRUE ;

static int TableWidth = 6 ;
static int TableLength = 4096 ;	/* 4^TableWidth */
static unsigned int TableMask ;
static char tableOff[16] ;

/***************/

void tableInit (void)
{ 
  int i ; 

  TableMask = 0 ;
  for (i = TableWidth ; i-- ;)
    TableMask = (TableMask << 2) | 3 ;

  tableOff[1] = 0 ;
  tableOff[2] = 1 ;
  tableOff[4] = 2 ;
  tableOff[8] = 3 ;
}

/***************/

Array tableSmear (Array table)
{
  int Width4 = 4*tableWidth ;
  Array new = arrayCreate (TableLength, float) ;
  int i, i1, j, k ;
  int part[32] ;		/* max for Width4 */
  float bit ;

  for (i = 0 ; i < Width4 ; i+= 4)
    { j = i/2 ;
      part[i] = 0 ;
      part[i+1] = 1 << j ;
      part[i+2] = 2 << j ;
      part[i+3] = 3 << j ;
    }

  for (i = 0 ; i < TableLength ; ++i)
    { bit = table[i] ;
      for (j = 0 ; j < Width4 ; j += 4)
	{ i1 = i & ~part[j + 3] ;
	  for (k = 4 ; k-- ;)
	    new[i1 | part[j + k]] += bit ;
	}
      new[i] -= TableWidth*bit ;	/* the stuff added on to self */
    }
  
  for (i = 0 ; i < TableLength ; ++i)
    new[i] /= (3 * TableWidth) ;
  
  return new ;
}

/*******************************/

static Array minMaxPos = 0 ;
static Array minMaxDiff = 0 ;

/* minMaxPos holds the positions of minima and maxima of partial 
   sums of the table entries.  We start with an implicit max at 0, 
   so the first entry is a min, after which they alternate.
   minMaxDiff keeps the difference between the partial sums at the
   current and last extremum.  
*/

static void makeMinMax (Array seq, int s1, int sn, Array table)
{
  int i, j ;
  unsigned int code ;
  float sum, bit ;
  char *base ;
  BOOL isUp ;

  if (minMaxPos)
    { arrayMax(minMax) = 0 ;
      arrayMax(minMaxDiff) = 0 ;
    }
  else
    { minMaxPos = arrayCreate (1000, int) ;
      minMaxDiff = arrayCreate (1000, float) ;
    }

  base = arrp(seq, s1, char) ;
  code = 0 ;
  for (i = TableWidth ; i-- ;)
    { code <<= 2 ;
      code |= tableOff[*base++] ;
    }

  sum = 0.0 ;
  isUp = FALSE ;
  j = 0 ;
  for (i = s1+TableWidth ; i <= sn ; ++i)
    { bit = table[code] ;
      if (isUp)
	if (bit < 0.0)
	  { array(minMaxPos, j, int) = i ;
	    array(minMaxDiff, j++, float) = sum ;
	    sum = bit ;
	    isUp = FALSE ;
	  }
	else
	  sum += bit ;
      else
	if (bit > 0.0)
	  { array(minMaxPos, j, int) = i ;
	    array(minMaxDiff, j++, float) = sum ;
	    sum = bit ;
	    isUp = TRUE ;
	  }
	else
	  sum += bit ;
      code <<= 2 ;
      code |= tableOff[*base++] ;
    }
}

static void maximaliseMinMax (void)
      /* acts on minMax to only leave maximal segments
	 take current min - go right keeping track of max while
	 partial > 0.  When it drops < 0 then start a new min.
     */
{
  int i, j, imax ;
  float partial, max ;
  float max ;

  j = 0 ;			/* current min */
  max = partial = 0.0 ;
  for (i = 1 ; i < arrayMax(minMaxPos) ; ++i)
    { partial += arr(minMaxDiff, i, float) ;
      if (partial > max)
	{ max = partial ;
	  imax = i ;
	}
      else if (partial < 0)
	{ arr(minMaxDiff, j++, float) = partial - max ;
	  arr(minMaxPos, j, int) = arr(minMaxPos, imax, int) ;
	  arr(minMaxDiff, j++, float) = max ;
	  arr(minMaxPos, j, int) = i ;
	  max = partial = 0 ;
	}
    }
  arrayMax(minMaxPos) = j ;
  arrayMax(minMaxDiff) = j ;
}


/**************** control ****************/

/* Only allow one nmer window, so use statics */

static KEY segSet ;
static OBJ SegSet ;
static KEY table ;

void nmerControl (void)
{
  
}

/************************/

typedef struct seqSegStruct
  { KEY   seq ;
    int   start ;
    int   end ;
  } SeqSegStruct, *SeqSeg ;

static void newMaxSegs (OBJ segs, Array table)
     /* makes a new object if the user wants */
{
  int  nheap, i, j, k ;
  KEY  newSegs, dnaKey ;
  OBJ  NewSegs ;
  Array flat, segInfo, table, dna ;
  Heap heap ;
  SeqSeg seqSeg ;

  if (!graphPrompt ("Give the number of new segs: "))
    return ;
  freeint (&nheap) ;
  if (nheap <= 0) 
    { messout ("number must be positive") ; return ; }
  
  flat = arrayCreate (32, BSunit) ;
  heap = heapCreate (nheap) ;
  segInfo = arrayCreate (nheap, SeqSegStruct) ;

  if (bsFindTag (Segs, _Sequence) && bsFlatten (Segs, 3, flat))
    for (i = 0 ; i < arrayMax(flat) ; i += 3)
      if (lexReClass(arr(flat,i,BSunit).k, &dnaKey, _VDNA) &&
	  (dna = dnaGet(dnaKey)))
	{ makeMinMax (dna, 
		      arr(flat,i+1,BSunit).i, 
		      arr(flat,i+1,BSunit).i) ;
	  maximaliseMinMax () ;
	  for (j = 0 ; j < arrayMax(minMaxPos) ; ++j)
	    { if (k = heapInsert (heap, score))
		{ seqSeg = arrp(segInfo, k, SeqSegStruct) ;
		  seqSeg->seq = arr(flat,i,BSunit).k ;
		  seqSeg->start = ;
		  seqSeg->end = ;
		}
	    }
	}
      
}
