/*  Last edited: Nov 28 15:42 1991 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File regression.c :                                      **/
      /**  Computes and Plots the linear regression                 **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  routines are  public :  linearRegression,                  */
      /*                          plotLinearRegression               */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified 15/4/91  by JTM.           */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "regression.h"
#include "graph.h"

/*************************************************************************/
    /* returns 1 , 2 , 5 ,10 , 20, 50 ,100 etc */
/*
static double regularDouble(double p)
{
 register double i=1,j=1;
 if(p<0) {j=-1; p=-p;}
 if (!p) return 0.;
 i = (double) exp10((double)(1 + (int)(log10((double)p)))) ;
 if(8*i<10*p) return i*j;
 i /= 2;
 if(4*i<5*p) return i*j;
 i = (2*i)/5;
 if(16*i<20*p) return i*j;
 i = i/2;
 return i*j;
}
*/

/*************************************************************************/
static void localDestroy(void)
{
 Array a ;
 if (graphAssFind(plotLinearRegression, &a))
   arrayDestroy(a) ;
}
/*************************************************************************/

static MENUOPT regressionMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        graphPrint,"Print",
        0,0 };

/*************************************************************************/
/* Solves, y = a x + b , in a and b   a defaults to *ap  if too few data given */
void linearRegression(Array xy, double *ap, double *bp, double *rp, double *wp)
{
  int i, max ;
  double r, w, xm,ym,xym , x2m, y2m ,b, a;

  if(!xy || !(max = arrayMax(xy)))
    {
      messout("linearRegression received a null array") ;
      *ap = * bp = *rp = *wp  = 0 ;
      return;
    }
  if(xy->size != sizeof(POINT))
    messcrash(
  "linearRegression received a wrong type of Array, should be  a pair of doubles ") ;

  i = max ;
  xm = ym = xym = 0 ;
  while (i--)
    {
      xm += arr(xy,i,POINT).x ; ym += arr(xy,i,POINT).y;
    }
  xm /= max ; ym /= max;
  x2m = y2m =xym =0;
  i = max ;
  while (i--)
    {
      xym += (arr(xy,i,POINT).x-xm) *( arr(xy,i,POINT).y-ym) ;
      x2m +=  (arr(xy,i,POINT).x-xm) *( arr(xy,i,POINT).x-xm) ;
      y2m +=  (arr(xy,i,POINT).y-ym) *( arr(xy,i,POINT).y-ym) ;
    }
  if(max >3 && x2m>0 && y2m >0)
    { r = xym / sqrt((double)x2m * y2m) ;
      
      w = r;
      i = max - 3 ;
      w = .5 * log((1+w) / (1-w)) * sqrt((double) i) ;
    }
  else
    r = w = 0 ;

  i = max ;
  a = 0 ;
  while (i--)
      a += (arr(xy,i,POINT).x - xm) * arr(xy,i,POINT).y ;

  if (x2m)
    a /= x2m ;
  else
    a = *ap ;  /* default */

  b = ym - a*xm ;
  
  *ap = a ;
  *bp = b ;
  *rp = r ;
  *wp = w ;
}



/*************************************************************************/

void plotLinearRegression(char *title, Array xy) 
{
  int i, max ;
  Graph graph ;
  double r, w, xm,ym,xym, xmin, xmax, ymin, ymax , x2m, y2m ,a, b;

  if(!xy || !(max = arrayMax(xy)))
    {
      messerror("plotLinearRegression(%s,array) received a null array", title);
      return;
    }
  if(xy->size != sizeof(POINT))
    messcrash(
  "plotLinearregression received a wrong type of Array, should be  a pair of doublse ") ;
  linearRegression(xy,&a, &b, &r,&w) ;
  xmin = ymin = 1e60;
  ymax = xmax = -ymin ;
  i = arrayMax(xy) ;
  while (i--)
    {
      if( arr(xy,i,POINT).x> xmax)
	xmax = arr(xy,i,POINT).x ;
      if( arr(xy,i,POINT).y> ymax)
	ymax = arr(xy,i,POINT).y ;
      if( arr(xy,i,POINT).x< xmin)
	xmin = arr(xy,i,POINT).x ;
      if( arr(xy,i,POINT).y< ymin)
	ymin = arr(xy,i,POINT).y ;
    }
  
  graph = graphCreate (PLAIN,title,0.01,0.05,0.7,0.7) ;
  graphHelp("Linear_regressionation");
  graphRegister(DESTROY,localDestroy) ;
  graphPlainBounds( xmin - .2 * (xmax - xmin),
		 ymin - .2 * (ymax - ymin),
		 1.4 * (xmax - xmin),
		 1.4 * (ymax - ymin), 1.);
  graphBoxStart () ;
  i = arrayMax(xy) ;
  while(i--)
    graphCircle((float)arr(xy,i,POINT).x,(float) arr(xy,i,POINT).y,5.) ;
  
  graphLine(xmin,a*xmin+b,xmax,a*xmax+b) ;  
  graphText(messprintf(" r = %6.3lf  n= %d w=%6.3lf, y =  %6.3lf x  +  %6.3lf",
		         r, arrayMax(xy), w, a , b), 5,2) ;
  graphText(messprintf(" xm = %6.3lf ym = %6.3lf xym = %6.3lf  x2m = %6.3lf y2m = %6.3lf",
		         xm,     ym,       xym,         x2m,        y2m), 5,12) ;
  
  /*  Coordinates 
  graphLine(0., h, 1.1*max, h);
  graphLine(0.,h-miny,0., h-1.1*maxy);

  dx = regular(max * 1.1 / 10);
  for(i=1;i<11;i++)
    graphText(messprintf("%d",i*dx),i*dx,h+2);
  dy = regular(2.6*(maxy - miny)*1.1/10.);
  for(i=1;(i<11) && (miny + i*dy < maxy);i++)
    graphText(messprintf("%5d",miny + i*dy),-6,
                              h- (miny + i* dy) );
  */
  graphBoxEnd () ;
  graphMenu(regressionMenu);
  graphRedraw() ;

  graphAssociate(plotLinearRegression,xy) ;
}

/*************************************************************************/
/*************************************************************************/



