/*  Last edited: Nov 28 15:42 1991 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File correl.c :                                          **/
      /**  Plots the r correlation coefficient                      **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  1 routines is  public :  plotCorrel()                       */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified 12/12/90  by JTM.           */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "array.h"
#include "graph.h"

void plotCorrel(char *title, Array a) ;

/*************************************************************************/
    /* returns 1 , 2 , 5 ,10 , 20, 50 ,100 etc */
/*
static double regularDouble(double p)
{
 register double i=1,j=1;
 if(p<0) {j=-1; p=-p;}
 if (!p) return 0.;
 i = (double) exp10((double)(1 + (int)(log10((double)p)))) ;
 if(8*i<10*p) return i*j;
 i /= 2;
 if(4*i<5*p) return i*j;
 i = (2*i)/5;
 if(16*i<20*p) return i*j;
 i = i/2;
 return i*j;
}
*/

/*************************************************************************/
static void localDestroy(void)
{
 Array a ;
 if (graphAssFind(plotCorrel, &a))
   arrayDestroy(a) ;
}
/*************************************************************************/

static MENUOPT correlMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        graphPrint,"Print",
        0,0 };

/*************************************************************************/

typedef struct point {double x, y ;} Point ;
void plotCorrel(char *title, Array a)
{
  int i, max ;
  Graph graph ;
  double r, w, xm,ym,xym, xmin, xmax, ymin, ymax , x2m, y2m ,aa, b;

  if(!a || !(max = arrayMax(a)))
    {
      messerror("plotcorrel(%s,array) received a null array", title);
      return;
    }
  if(a->size != sizeof(Point))
    messcrash(
  "plotCorrel received a wrong type of Array, should be  a pair of doublse ") ;
  xmin = ymin = 1e60;
  ymax = xmax = -ymin ;
  i = arrayMax(a) ;
  while (i--)
    {
      if( arr(a,i,Point).x> xmax)
	xmax = arr(a,i,Point).x ;
      if( arr(a,i,Point).y> ymax)
	ymax = arr(a,i,Point).y ;
      if( arr(a,i,Point).x< xmin)
	xmin = arr(a,i,Point).x ;
      if( arr(a,i,Point).y< ymin)
	ymin = arr(a,i,Point).y ;
    }
  
  i = arrayMax(a) ;
  xm = ym = xym = 0 ;
  while (i--)
    {
      xm += arr(a,i,Point).x ; ym += arr(a,i,Point).y;
    }
  i = arrayMax(a) ; xm /= i ; ym /= i;
  x2m = y2m =xym =0;
  i = arrayMax(a) ;
  while (i--)
    {
      xym += (arr(a,i,Point).x-xm) *( arr(a,i,Point).y-ym) ;
      x2m +=  (arr(a,i,Point).x-xm) *( arr(a,i,Point).x-xm) ;
      y2m +=  (arr(a,i,Point).y-ym) *( arr(a,i,Point).y-ym) ;
    }
  r = xym / sqrt((double)x2m * y2m) ;
  
  w = r;
  w = .5 * log((1+w) / (1-w)) * sqrt((double)(arrayMax(a) -3)) ;
    
  graph = graphCreate (PLAIN,title,0.01,0.05,0.7,0.7) ;
  graphHelp("Linear_correlation");
  graphRegister(DESTROY,localDestroy) ;
  graphPlainBounds( xmin - .2 * (xmax - xmin),
		 ymin - .2 * (ymax - ymin),
		 1.4 * (xmax - xmin),
		 1.4 * (ymax - ymin), 1.);
  graphBoxStart () ;
  i = arrayMax(a) ;
  while(i--)
    graphCircle((float)arr(a,i,Point).x,(float) arr(a,i,Point).y,5.) ;
  
  i = arrayMax(a) ;
  b = 0 ;
  
  while (i--)
    {
      b += (arr(a,i,Point).x - xm) * arr(a,i,Point).y ;
    }
  b /= x2m ;
  aa = ym - b*xm ;

  graphLine(xmin,b*xmin+aa,xmax,b*xmax+aa) ;  
  graphText(messprintf(" r = %6.3lf  n= %d w=%6.3lf, y =  %6.3lf x  +  %6.3lf",
		         r, arrayMax(a), w, b , aa), 5,2) ;
  graphText(messprintf(" xm = %6.3lf ym = %6.3lf xym = %6.3lf  x2m = %6.3lf y2m = %6.3lf",
		         xm,     ym,       xym,         x2m,        y2m), 5,12) ;
  
  /*  Coordinates 
  graphLine(0., h, 1.1*max, h);
  graphLine(0.,h-miny,0., h-1.1*maxy);

  dx = regular(max * 1.1 / 10);
  for(i=1;i<11;i++)
    graphText(messprintf("%d",i*dx),i*dx,h+2);
  dy = regular(2.6*(maxy - miny)*1.1/10.);
  for(i=1;(i<11) && (miny + i*dy < maxy);i++)
    graphText(messprintf("%5d",miny + i*dy),-6,
                              h- (miny + i* dy) );
  */
  graphBoxEnd () ;
  graphMenu(correlMenu);
  graphRedraw() ;

  graphAssociate(plotCorrel,a) ;
}

/*************************************************************************/
/*************************************************************************/


