/*  Last edited: Apr  2 17:39 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File biblio.c :                                          **/
      /**  Displays any biblio for current object.                  **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*  2 routines is  public :  biblioKey(), biblioKeySet         */
      /*                                                             */
      /*         R.Durbin & J.Thierry-Mieg.                          */
      /*                    last modified 21/3/91  by JTM.           */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "lex.h"
#include "keyset.h"
#include "graph.h"
#include "sysclass.wrm"
#include "classes.wrm"
#include "systags.wrm"
#include "tags.wrm"
#include "query.h"
#include "bs.h"
#include "biblio.h"
#include "display.h"

typedef struct bibStruct
  { KEYSET bibSet ;
    int    curr ; 
    char*  cp ; 
  } *BIB ;

/*************************************************************************/

static MENUOPT biblioMenu[]={
        graphDestroy,"Quit",
        help,"Help",
        graphPrint,"Print",
        0,0 };

/*************************************************************************/

static void biblioDestroy(void)
{
  BIB biblio ;

  if (graphAssFind (biblioDestroy,&biblio))
    { keySetDestroy (biblio->bibSet) ;
      messfree (biblio->cp) ;
      messfree (biblio) ;
      graphAssRemove (biblioDestroy) ;
    }
}

/**********************************************************/

static void biblioPick (int k)
{
  BIB biblio ;

  if (!graphAssFind (biblioDestroy, &biblio))
    messcrash ("graph find error in biblioPick") ;
  
  if (k > 1 && k == biblio->curr)
    display (keySet(biblio->bibSet, biblio->curr - 2), 0, 0) ;
  else if (k > 1)
    { if (biblio->curr)
	graphBoxDraw (biblio->curr, BLACK, WHITE) ;
      biblio->curr = k ;
      graphBoxDraw (biblio->curr, WHITE, BLACK) ;
    }
}

/*************************************************************************/

static void biblioCreate (char *title, KEYSET bibSet)
{
  int i, j, max, line, ix ;
  char *cp,*cq ;
  KEY text ,kk;
  OBJ Ref ;
  KEY ref ;
  static KEYSET aut = 0 ;
  Stack  buf = stackCreate(300) ;
  BIB biblio ;

  if (!aut)
    aut = keySetCreate() ;

  if (!bibSet || !(max = keySetMax(bibSet)))
    {
      messout("Sorry, no related bibliography") ;
      keySetDestroy(bibSet) ;
      return;
    }

  if (!title || !*title)
    messcrash("biblioCreate needs a title") ;

  biblio = (BIB) messalloc (sizeof(struct bibStruct)) ;
  biblio->bibSet = bibSet ;
  biblio->curr = 0 ;
  biblio->cp = messalloc(70) ;
  strncpy(biblio->cp, title,69); /* *(cp+70) == 0 by messalloc */
  
  displayCreate(BIBLIO) ;
  graphRetitle (title) ;
  graphMenu (biblioMenu) ;
  graphRegister (DESTROY,biblioDestroy) ;
  graphRegister (PICK,(GraphFunc)biblioPick) ;

  graphAssociate (biblioDestroy,biblio) ;

  graphTextBounds(80,10) ;
  graphText("Topic : ",1.,1.) ;
  graphTextEntry(biblio->cp,68, 9.,1.,0) ;
  graphText(messprintf("found %d ref", max),6.,2.);

  for(i=0, line=4 ; i < max ; i++)
    {
      graphBoxStart () ;
      graphText(name(ref=arr(bibSet,i,KEY)),0,line);
      graphBoxEnd () ;
      graphColor (BLACK) ;
      if (Ref = bsCreate(ref))
        {
	  if(bsGetKey (Ref,_Title,&text))
	    {
	      uLinesText(cp=name(text),80);
	      while(cq=uNextLine(cp))
		graphText(cq,14,line++);
	    }
	  stackClear(buf) ; catText (buf,"") ;
	  if (bsFindTag (Ref, _Author) &&
	      bsFlatten (Ref, 1, aut))
	    {
              for (j=0;j<arrayMax(aut);j++)
		{ if(j)
		    catText(buf,", ") ;
		  catText(buf,name(keySet(aut,j))) ;
		}
	      catText(buf,".");
              uLinesText(stackText(buf,0),80) ;
	      while (cp = uNextLine(stackText(buf,0)))
		graphText(cp,16,line++);
	    }
	  stackClear(buf) ; catText(buf,"") ;
	  if (bsGetKey (Ref,_Journal,&kk))
	    catText (buf,name(kk));
	  if (bsGetData (Ref,_Volume,_Int,&ix))
	    { catText (buf, messprintf (" %d",ix)) ;
	      if (bsGetData (Ref,_bsRight,_Text,&cp))
		catText (buf, cp) ;
	    }

	  if (bsGetData (Ref,_Page,_Int,&ix))
	    { catText (buf, messprintf (", %d",ix)) ;
	      if (bsGetData (Ref,_bsRight,_Int,&ix))
		catText (buf, messprintf ("-%d",ix)) ;
	    }

	  if (bsGetData (Ref,_Year,_Int,&ix))
	    catText (buf, messprintf (" (%d)",ix)) ;

	  uLinesText (stackText(buf,0),80) ;
	  while (cp = uNextLine(stackText(buf,0)))
	    graphText(cp,16,line++);
	  bsDestroy(Ref);
	}
    }

  graphTextBounds (80, line) ;
  graphRedraw () ;
  arrayDestroy (aut);
  stackDestroy (buf) ;
}

/*************************************************************************/

void biblioKeySet (char *title, KEYSET s)
{
   /* We need to declare all bib... to be able to destroy them */

  KEYSET bib1, bib2, bib3, bib4, bib ;

  bib1 = query(s,"?Paper") ; /* Class Paper members of s */
  bib2 = query(s,">Paper") ; /* Follow tag Paper */
  bib3 = query(s,">Reference") ; /* Follow tag Reference */

  bib4 = keySetOR(bib2,bib3) ;
  bib  = keySetOR(bib1,bib4) ;

  keySetDestroy(bib1) ;
  keySetDestroy(bib2) ;
  keySetDestroy(bib3) ;
  keySetDestroy(bib4) ;

  biblioCreate(title,bib) ;
}

/***********************************************************/

void biblioKey(KEY key)
{
 KEYSET set = keySetCreate() ;
 
 keySet(set,0) = key ;
 biblioKeySet (messprintf("Bibliography attached to %s",
			 name(key)), set) ;
}


/*************************************************************************/
/*************************************************************************/


