/*  File: querydisp.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 **  Constructs general queries.                              **
 * Exported functions:
 **  queryCreate
 * HISTORY:
 * Last edited: Apr  2 18:34 1992 (mieg)
 * Created: Mon Dec 30 19:05:47 1991 (mieg)
 *-------------------------------------------------------------------
 */

#include <ctype.h>
#include "acedb.h"
#include "array.h"
#include "keyset.h"
#include "graph.h"
#include "query.h"

typedef struct QUERSTUFF
  { int   magic;        /* == MAGIC*/
    Graph graph ;
    char *fileName ;
    char *dirName ;
    int pgmBox ;
    KEYSET undoSet ;
    int curr ;
    FILE *fil ;
    BOOL modif ;
    Array pgm ; /* array of Stack, each one a program line */
  } *QUER ;


#define MAGIC  926535
static Graph querGraph = 0 ;

#include "display.h"	/* must come after QUER definition */

static void querDisplay(void) ;
void queryCreate (void) ;

#define QUERGET(name)     QUER quer ;\
                                       \
                          if (!graphAssFind (queryCreate,&quer)) \
		            messcrash ("(name) can't find graph") ; \
			  if (!quer) \
                            messcrash ("(name) received a null pointer") ; \
                          if (quer->magic != MAGIC) \
                            messcrash ("(name) received a wrong pointer")  ;\
                          displayPreserve()  

                 /* in quer2.c */
static void querPick (int k) ;

/*********** stuff local to the quer routine and initialiser **********/
/************************************************************************/

static Array dirMarks = 0 ;
static Stack dirStack = 0 ;

/*****************************************/
/*********** action routines ***********/

static void querEdit (void)
{ Array a ;
  int box , i ;
  KEYSET oldSet, newSet ;
  void *look ;
  char * querText ;

  QUERGET(querEdit) ;
  
  quer->modif = TRUE ;
  box = quer->curr ;
  i = (box - quer->pgmBox - 1) / 2 ;

    /* One empty entry for a new instruction */ 
  if(i == arrayMax(quer->pgm) - 1)
    {
      array(quer->pgm,i+1,Array) = a  = arrayCreate(80, char) ;
      array(a,0,char) = 0 ;
      querDisplay() ;
      /* Reactivate box  */
      querPick(box) ; 
    }

  /* Execute */
  if (arrayExists(array(quer->pgm,i,Array)))
    { querText = arrp(arr(quer->pgm,i,Array), 0, char) ;
      if(keySetActive(&oldSet, &look))
	{ 
	  mainActivity("Searching") ;
	  newSet = query(oldSet, querText) ;
	  if (newSet != oldSet )
	    { if(keySetExists(quer->undoSet) &&
		 quer->undoSet != oldSet )
		keySetDestroy(quer->undoSet) ;
	      quer->undoSet = oldSet ;
	    }
	  mainActivity(0) ;
	  keySetShow(newSet,look) ;
	}
      else
	messout("First select a keySet, thank you") ;
    }
}

/*********** action routines ***********/

static void querParseFile(void)
{ Array a ;
  int i, j ; 
  char c ;
  Array s ;
  Array pgm ;
  FILE *fil ;
  QUERGET(querGetFile) ;

  fil = filqueryopen (quer->dirName,quer->fileName,"qry","r") ;
  if (!fil || !graphExists (quer->graph))
    return ;

  pgm = quer->pgm ;
  if(!pgm)
    pgm = quer->pgm = arrayCreate(5,Stack) ;
  else
    for (i=0; i<arrayMax(pgm); i++)
      arrayDestroy(arr(pgm,i,Array)) ;
  i =  arrayMax(pgm)  = 0 ;
       
  s = 0 ;
  j = 0 ;
  while (c = fgetc(fil), c!= EOF)
    {
      if (c == '\n' || !s)
	{ if (s && j)
	    array(s,j,char) = 0 ;
	  s = array(pgm,i,Array) ;
	  if (s)
	    arrayMax(s) = 0 ;
	  else
	    s = array(pgm,i,Array) = arrayCreate(80, char) ;
	  j = 0 ;
	  i++ ;
	}
      if(isspace(c))
	{ if(j) array(s,j++,char) =  ' ' ; }
      else
	if (c!='\n' && isprint(c))
	  array(s,j++,char) = c ;
    }
  if (s)
    if (j)
      array(s,j,char) = 0 ;
    else
      { arrayDestroy(s) ;
	array(pgm,--i,Array) = 0 ;
	arrayMax(pgm) = i ;
      }
  fclose(fil) ;
    /* One empty entry for a new instruction */ 
  array (pgm,i,Array) = a = arrayCreate(80, char) ;
  array(a,0,char) = 0 ;
  querDisplay () ;
}

/**********************/

static void querSaveFile(void)
{
  int i ;
  Array s ;
  Array pgm ;
  FILE *fil ;
  QUERGET(querSaveFile) ;

  pgm = quer->pgm ;
  if(!pgm || arrayMax(pgm) <= 1)
    { messout("No program to save") ;
      return ;
    }
  
  fil = filqueryopen (quer->dirName,quer->fileName,"qry","w") ;
  if (!fil || !graphExists (quer->graph))
    return ;

  pgm = quer->pgm ;

  for(i=0; i < arrayMax(pgm) - 1; i++)
    { s = array(pgm,i,Array) ;
      if (s)
	fprintf (fil,"%s\n", arrp(s,0,char)) ;
    }

  fclose(fil) ;
}

/*****************************************/

static void querDestroy (void)
{    
  Array pgm ;
  int i ;
  char * cp ; 
  QUER quer ;
  
  if (  graphAssFind (queryCreate,&quer)
      && quer
      && (quer->magic == MAGIC) 
      )
    {
      cp =  quer->fileName ;
      if(   quer->pgm 
	 && quer->modif
	 && *quer->fileName
	 && strlen(quer->fileName)
	 && graphQuery (messprintf("%s not saved, Save ?",
				  cp ? cp : "No name")))
	querSaveFile() ;
      
      quer->magic = 0 ;
      if (pgm = quer->pgm)
	{ i = arrayMax(pgm) ;
	  while(i--) 
	    arrayDestroy(arr(pgm,i,Array)) ;
	  arrayDestroy(pgm) ;
	}
      arrayDestroy(quer->undoSet) ;
      messfree (quer) ;
      graphDestroy() ;
      stackDestroy(dirStack) ;
      arrayDestroy(dirMarks) ;

      querGraph = 0 ;
    }
}

/**********************************************************/

static void querUndo (void)
{
  KEYSET oldSet ;
  void   *look ;
  QUERGET(querUndo) ;

  if (keySetExists(quer->undoSet) &&
      keySetActive(&oldSet,&look) 
      )
    { keySetDestroy (oldSet) ;
      keySetShow (keySetCopy(quer->undoSet),look) ;
    }
}

static void querPick (int k)
{    
  int i ;
  QUERGET(querPick) ;
  
  if (!k)
    return ;

  if (k > quer->pgmBox )
    { 
      i = (k - quer->pgmBox - 1)/ 2 ;
      if (i < arrayMax(quer->pgm))
	{
	  quer->curr = k ;
	  graphTextEntry (arrp(arr(quer->pgm, i,Array), 0, char),
			  0,0,0,0) ;
	}
    }

  graphActivate(quer->graph) ;
}

/*************************************************************/

static void newKeySet (void)
{
  KEYSET k = keySetCreate () ;
  Graph  g = graphActive () ;

  displayCreate(DtKeySet) ;
  graphRetitle("New keyset") ;
  keySetShow (k,0) ;
  keySetSelect () ;
  graphActivate (g) ;
}

/**********************************************************/

static MENUOPT querMenu[] =
  {
   querDestroy, "Quit",
   help, "Help",
   querParseFile, "Load",
   querSaveFile, "Save",
   newKeySet, "New",
   querUndo, "Undo",
   0, 0 
   } ;

/*****************/

static void querDisplay(void)
{
  int i = 0 ;
  QUERGET(querDisplay) ;
 
  graphActivate(quer->graph) ;
  graphClear() ;

  graphButtons (querMenu, 1, 1, 55) ;

  graphText ("Commands :", 0.5, 5.5) ;
  graphText ("Example : >?Paper  Author = S* && Year > 1989 ;",
	     6.0, 3.5) ;
  quer->pgmBox = graphBoxStart() ;
  if(quer->pgm)
    { for(i=0; i<arrayMax(quer->pgm); i++)
	quer->curr =
	  graphTextEntry(arrp(arr(quer->pgm,i,Array),0, char),
		       80, 3, i*1.5 + 7, querEdit) ;
    }
  graphBoxEnd() ;
  graphTextBounds (60,9 + 1.5*i) ; /* only do this now, but see queryCreate */
  graphRegister (PICK,(GraphFunc)querPick) ;
  graphRedraw() ;
}

/*********************************************************************/
/********************  public routines   *****************************/

void queryCreate (void)
{ Array a ;
  QUER quer ;

  if(graphActivate(querGraph))
    { 
      graphPop() ;
      return ;
    }

  querGraph = displayCreate(DtQuery) ;
  if (!querGraph)
      return ;

  quer=(QUER)messalloc(sizeof(struct QUERSTUFF));
  quer->magic = MAGIC;
  quer->graph = querGraph ; /* provision for multi windows */


  graphTextBounds (80,40) ;   /* needed to for text box sizing */
  graphRegister (DESTROY,querDestroy) ;
  graphRegister (PICK,(GraphFunc)querPick) ;
 
  graphMenu(querMenu) ;  
  graphAssociate(queryCreate, quer);

  quer->dirName = (char*)  messalloc (80) ;
  strcpy(quer->dirName,"./wquery") ;

  quer->fileName = (char*)  messalloc (24) ;
  strcpy(quer->fileName,"") ;

  quer->pgm = arrayCreate(6,Array) ;
  array(quer->pgm,0,Array) = a = arrayCreate(80,char) ;
  array(a,0,char) = 0 ;
  querDisplay() ;
}

/*************************************************************/
/*************************************************************/
