/*  File: longtext.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Apr 22 16:17 1992 (mieg)
 * Created: Fri Mar 13 15:06:53 1992 (mieg)
 *-------------------------------------------------------------------
 */



#include "acedb.h"
#include "keyset.h"

#include "lex.h"  /* needed in keysetdump and keysetorder */
#include "display.h"
#include "pick.h"  /* needed in keysetdump */
#include "a.h"  /* needed in keySetParse */
#include "sysclass.wrm"

typedef struct LOOKSTUFF
  { int   magic;        /* == MAGIC */
    KEY   key ;
    int   activeBox ;
    Stack textStack ;
    int myTextStack ;
    Array segs,      	/* array of SEG's from the obj */
          boxIndex ;    /* if >256 a SEG, else something special */
  } *LOOK ;

typedef struct
  { KEY key ;
    float x, dx ;
    unsigned int flag ; /* I use shift right operators */
  } SEG ;
#define segFormat "k2fi"

static void longTextDestroy (void) ;
BOOL longTextDisplay (KEY key, KEY from, BOOL isOldGraph) ;

static MENUOPT longTextMenu[] =
            { graphDestroy, "Quit",
		help,"Help",
		graphPrint,"Print",
		displayPreserve,"Preserve",
		0, 0
            } ;

#define MAGIC  464565
#define LOOKGET(name)     LOOK look ; \
                          if (!graphAssFind (longTextDisplay,&look)) \
		            messcrash ("graph not found in %s",name) ; \
			  if (!look) \
                            messcrash ("%s received a null pointer",name) ; \
                          if (look->magic != MAGIC) \
                            messcrash ("%s received a wrong pointer",name)


/**************************************************************/

static void longTextDraw (LOOK look, BOOL reuse)
{ int x = 1 , y = 1, maxx = 0  ;
  char *cp ;
  Stack s = look->textStack ;
  
  graphClear() ;

  if (stackExists(s) != look->myTextStack)
    { messout("longTextDraw lost its stack, sorry") ;
      return ;
    }
  stackCursor(s, 0) ;
  while (cp = stackNextText(s))
    {
      graphText (cp, x, y) ;
      x += strlen(cp) + 1 ;
      if (x > maxx)
	maxx = x ;
      x = 1 ;
      y++;
    }
  graphTextBounds( maxx + 2 , y+3) ;
  graphRedraw() ;
}

/**********************************/

static void longTextResize (void)
{
  LOOKGET("longTextResize") ;

  longTextDraw (look, 0) ;
}

/**********************************/

BOOL longTextDisplay (KEY key, KEY from, BOOL isOldGraph)
{
  LOOK look=(LOOK)messalloc(sizeof(struct LOOKSTUFF)) ;
  KEY  curr = 0 ;
  
  look->magic = MAGIC;

  if (key && class(key) != _VLongText)
    goto abort ;

  look->key = key ;

  look->boxIndex = arrayCreate (64,SEG*) ;
  look->activeBox = 0 ;

  if (isOldGraph)
    { 
      graphRetitle (name (key)) ;
      longTextDestroy () ;
      graphAssRemove (longTextDisplay) ;
    }
  else 
    { if (!displayCreate(DtLongText)) 
	goto abort ;
      
      graphRetitle(name(key)) ;
      graphRegister (RESIZE,(GraphFunc)longTextResize) ;
      graphRegister (DESTROY, longTextDestroy) ;
/*
      graphRegister (PICK, (GraphFunc)longTextPick) ;
      graphRegister (MIDDLE_DOWN, (GraphFunc)longTextMiddleDown) ;
      graphRegister (KEYBOARD, (GraphFunc)longTextKbd) ;
 */
     graphMenu (longTextMenu) ;
    }

  if (! (look->textStack = stackGet(key)))
    goto abort ;
  look->myTextStack = stackExists(look->textStack) ;
  graphAssociate (longTextDisplay,look) ;
  longTextDraw (look, curr) ;

  return TRUE ;

abort :
  messfree (look) ;
  return FALSE ;
}

/************************************************************/
/***************** Registered routines *********************/

static void longTextDestroy (void)
{
  LOOKGET("longTextDestroy") ;

  arrayDestroy(look->segs) ;
  arrayDestroy(look->boxIndex) ;
  stackDestroy(look->textStack) ;

  look->magic = 0 ;
  messfree (look) ;
}

/**************************************************************/

BOOL longTextDump(FILE *f, Stack buffer, Array a)
{ char  *cp ;
  Stack s ;
  extern Stack arrayToStack (Array a) ;

  if( ! arrayExists(a) || !arrayMax(a))
    return FALSE ;

  s = arrayToStack(a) ;
  if (!s)
    return FALSE ;
  stackCursor(s,0) ;
  if (f)
    while (cp = stackNextText(s))
      fprintf(f, "%s\n", cp) ;
  else
    {
      messout("longTextDump into stack not coded yet") ;
    }

  fprintf(f, "\n***LongTextEnd***\n") ;
  stackDestroy(s) ;
  return 
    TRUE ;
}  

/************************************/

BOOL longTextParse (int level, KEY key)
{
  char *cp = 0 ;
  Stack s = stackCreate(500) ;

  while (freecard(level))
    { cp = freepos() ;
      if (!strcmp(cp,"***LongTextEnd***"))
	break ; 
      else
	pushText(s, cp) ;
    }

  if (stackMax(s))
    { stackStore(key,s) ;
      stackDestroy(s) ;
      return TRUE ;
    }
  else
    {
      stackDestroy(s) ;
      return FALSE ;
    }
}

/**************************************************************/
/**************************************************************/

