/*  File: external.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1992
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 **    Calls an external application.
 * Exported functions:
 * HISTORY:
 * Last edited: Mar  4 01:58 1992 (rd)
 * Created: Fri Jan 10 23:40:16 1992 (mieg)
 *-------------------------------------------------------------------
 */

#include "acedb.h"
#include "bs.h"
#include "lex.h"
#include "display.h"   /* self declaration */
#include "systags.wrm"

void externalDisplay (KEY key)  
{
  OBJ obj = bsCreate(key) ;
  char *cp , *cq ;
  Stack s = stackCreate(50) ;
  int fName , cmd ;
  FILE *f ;

  if(!obj)
    messcrash("Image display called on unkown obj %s",
	      name(key)) ;
  if(!bsGetData(obj,_Pick_me_to_call,_Text,&cp))
    { messout ("Sorry, a program and a file name are expected here") ;
      goto abort ;
    }
  pushText(s, cp) ;
 
  if(!bsGetData(obj,_bsRight,_Text,&cp))    
    { messout ("Sorry, a file name is expected here") ;
      goto abort ;
    }
 
  if(!(f = filopen(messprintf("externalFiles/%s",cp),"","r")))
    { messout("Sorry, i cannot find the external file") ;
      goto abort ;
    }
  fclose(f) ;

  fName = stackMark(s) ;
  pushText(s, filsetdir(0)) ;
  catText(s, "/externalFiles/") ;
  catText(s, cp) ;
 
  cp = cq = stackText(s, fName) ;
  cq += strlen(cp) ;
  while (--cq > cp && *cq != '/') ; /* cannot fail, i just did put a /  */
  *cq++ = 0 ;

  cmd = stackMark(s) ;

  system (messprintf("cd %s ; %s %s &", cp, stackText(s, 0), cq)) ;
  messout (messprintf("cd %s ; %s %s &", cp, stackText(s, 0), cq)) ;

 abort:
  bsDestroy(obj) ;
  stackDestroy(s) ;
}
  
/**************************************************************/
/**************************************************************/
