/*  Last edited: Mar 10 04:57 1992 (mieg) */

      /***************************************************************/
      /***************************************************************/
      /**  File Bsubs.c :                                           **/
      /**  Handles the B blocks of  the ACeDB program.              **/
      /***************************************************************/
      /***************************************************************/
      /*                                                             */
      /*     14xs routines are public :                              */
      /*     init, get, dump, prune,                                 */
      /*     Bnode2str/str2node,                                     */
      /*     Bnextkey,                                               */
      /*     Bbranchlen, freelen, newnode.                           */
      /*          .Durbin & J.Thierry-Mieg.                          */
      /*                    last modified  4/1/1991 by JTM.          */
      /*                                                             */
      /***************************************************************/

#include "acedb.h"
#include "bs_.h"   /* Defines BS */
#include "bs.h"  /* bsCreate in Bdump */
#include "b_.h"
#include "lex.h"
#include "pick.h"
#include "block.h"
#include "graph.h"

static void Bprune2(BP bp, NODE nn);

/**************************************************************/
                          /*initialise a new B */
                          /*called by B2BSstore2 */
     /* must not touch the block header */
void Binit(BP bp)
{
 NODEP r;
 static struct bblock Bnull;
 register char *cp;
 register int i;
 static int firstpass=1;

 if (firstpass) {     /*initialise Bnull*/
                 i=BLOC_SIZE;
                 cp=(char*) &Bnull;
                 while(i--)*cp++=0;
                 Bnull.hat.free=1;
                 Bnull.hat.h.type = 'B';
                 r=Bnull.n;
                 for(i=1;i<BNODEMAX-1;i++)(r+i)->d1=i+1;
                 firstpass=0;
                 }
  *bp=Bnull;
}

/**************************************************************/

                  /*given a key
                  * finds the origin of the correct branch
                  *  public; called by Bshow in BSsubs
                  */


void Bget(BP *bp, NODE *nn,KEY key)
{
  NODEP r;
  if (iskeyold(key))
    {

      blockpinn(key,bp) ;
      *nn=(*bp)->hat.top;
      
      while(*nn) {r=(*bp)->n+*nn;
		  if(r->ck.key==key) break;

		  *nn=r->d1;
		}
      
      /* if (*nn==0) on n a pas trouve alors que l on avait le bloc*/
      if (!*nn)
	messcrash("Block error in Bget(%s)",
		  name(key)) ;
    }
  else
    messcrash("Bget called on not old key %s",
		  name(key)) ;
}

/**************************************************************/

void Bdump (KEY key)
{
  int line,j ;
  BP bp;
  NODEP r;
  NODE i;
  int nblocks ;

  bp=0;
  if(!iskeyold(key))
    { messout("key %lu=%s never saved",key,name(key)) ;
      return ;
    }
  nblocks = blockpinn(key,&bp) ;

  do
    {
      graphColor(GREEN);
      graphCreate(TEXT_SCROLL,"Block Dump",.1,.4,0.8,.4);
      graphText(name(key), 1,1);
      graphText(messprintf( " disk : %d   session : %d",
			   bp->hat.h.disk,bp->hat.h.session),
		1,2);
      if (bp->hat.h.type == 'A')
	graphText(messprintf("Array"), 1, line = 5) ;
      else if (bp->hat.h.type == 'B')
	{
	  graphText(messprintf(
	       "Bdump    bp=%ld, top=%d,free=%d, freelen=%d  searching %lu : ",
			       bp,bp->hat.top,bp->hat.free,Bfreelen(bp),
			       key),
		    1,3);
	  for (i=1,line=5 ; i<BNODEMAX ;line++,i++)
	    { r=bp->n+i;
	      graphText(messprintf ("%3d l=%3d r=%3d  ",i,r->d1,r->d2),
			1,line);
	      for(j=0;j<NODEX;j++)
		graphText(messprintf("%02x ",r->ck.c[j]),20+3*j,line);
	      graphText(messprintf("k=%lu ",r->ck.key),40,line);
	      graphText(messprintf(" cp=%6s  ",r->ck.c),52,line);
	      graphText(name(r->ck.key),63,line);
	    }
	}
      graphTextBounds(100, line + 2) ;
      graphRedraw () ;
    }
  while (blockNext(&bp)) ;  /* do-while construction */
  blockunpinn(key) ;
  if(pickType(key) == 'B')
    { OBJ obj=bsCreate(key) ;
      if(obj) 
	bsDump (obj) ;
      bsDestroy(obj) ;
    }
}

/**************************************************************/

void Bnode2str(char *cq, BP bp, NODEP *r)
{
  register char *cp;
  register int i ;

  /*    ((*r)->ck.key <=_LastC) Must be garanteed in the call */

  while ((*r)->d2)
    { 
      *r=bp->n+(*r)->d2 ;
      cp=(*r)->ck.c;
      i=NODEX;
      while (i--) if(*cp)  *cq++=*cp++;
    }
  *cq = 0;    /*finishes the cq string*/
}

/**************************************************************/
      /* Called only from BSsubs*/


void Bstr2node(BS bs, BP bp, NODEP *r)
{
  NODEP rnew ;
  register char *cp, *cq;
  register int i=0 ;
  char nulChar = 0;
  
  if(bs->bt && bs->bt->cp)
    cp = bs->bt->cp ;
  else
    cp = &nulChar ;

     /* This is not while (*cp) because i want to
	go thru once on an empty string */
  while (TRUE)  
   {
     rnew = Bnewnode(bp)  ;
     (*r)->d2 = (NODE) (rnew - bp->n) ;
     *r = rnew ;
     cq=(*r)->ck.c;

/*     if ((*r)->ck.x.i)   
         invokeDebugger() ;  This check fails many times
*/     
     i=NODEX;
     while (*cp && i--) 
       *cq++=*cp++;
      /* recall that Bnewnode memset *cq to 0 */
     if (!*cp)
       break ;
   }
  
  if (i > 0)
    *cq = 0 ;
}

/***************************************************************************/
void Bprune(BP bp, NODE nn,BOOL  bothsides)
{
  NODEP r=bp->n+nn;
  NODE n=bp->hat.top, nright = r->d1, n1 ;
  
  if(bothsides)
      nright = 0 ;
  else
      r->d1=0;

  if(n==nn) 
    bp->hat.top = nright ;
  else
    {
      while(n && (nn != (n1 = (bp->n+n)->d1 )))
	n  = n1 ;
      if (!n)
	messcrash ("Link list error in Bprune") ;
      (bp->n + n)->d1 = nright ;
    }

  Bprune2(bp,nn) ;
}

/***************************************************************************/

static void Bprune2(BP bp, NODE nn)
{
 NODEP r=bp->n+nn;

 if(r->d2)Bprune2(bp,r->d2);
 if(r->d1)Bprune2(bp,r->d1);
 r->d2=0;
 r->d1=bp->hat.free;
 bp->hat.free=nn;
 }

/**************************************************************/
NODEP Bnewnode(BP bp)
{
  NODEP r;
  BHAT b=&(bp->hat);
  
  if (!b->free)
    messcrash("Bnew node : block overflow");
  r = bp->n + b->free ;
  b->free=r->d1;
  memset ((char *) r, 0, sizeof (NODE)) ;  
  return r ;
}

/***************************************************************************/
int Bbranchlen(BP bp,NODE nn)
{
 NODEP r=bp->n+nn;
 return( nn ?

       ( ( r->d1 ? Bbranchlen(bp,r->d1) : 0 )
        +( r->d2 ? Bbranchlen(bp,r->d2) : 0 )
        + 1
        )
              : 0   );
}
/***************************************************************************/
int Bfreelen(BP bp)
{
 register int i=0;
 register NODE nn=bp->hat.free;
 while(nn)
         {i++;
          nn=(bp->n+nn)->d1;
          }

return(i);
}
/***************************************************************************/
                   /* Gives, one by one the list of the
                    * keys of p, de la branche ainee.
                    * probably, the objects in p.
                    */

BOOL Bnextkey(BP p,KEY *kp)
{
 static BP bp;
 static NODE nn;
 NODEP r;
 
 if(*kp)
   { if(bp != p)
       messcrash("WARNING : bad call to Bnextkey /n %s",
		 name(*kp));
   }
 else
   { bp = p ;
     nn=bp->hat.top;
   }

 if(nn)
   { r=bp->n+nn;
     nn=r->d1;

     *kp=r->ck.key;
     return TRUE;
   }
 *kp=0;
 return FALSE;
}

/***************************************************************************/
                   /* Gives, one by one the list of the
                    * keys of p, de la branche ainee.
                    * probably, the objects in p.
                    */

void Balias(BP bp,KEY key, KEY newKey)
{
  NODE nn;
  NODEP r;
 
  nn=bp->hat.top;
  while(nn)
    { r=bp->n+nn;
      nn=r->d1;
      
      if (r->ck.key == key)
	{ r->ck.key = newKey ;
	  return ;
	}
    }
  messcrash("Balias failed") ;
}

/*********************************************/
/*********************************************/




