/*  File: acdbtest.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description:
 * Exported functions:
 * HISTORY:
 * Last edited: Mar  4 01:58 1992 (rd)
 * Created: Sat Nov  2 19:53:29 1991 (mieg)
 *-------------------------------------------------------------------
 */

#include "acedb.h"
#include "classes.wrm"
#include "sysclass.wrm"
#include "lex.h"
#include "systags.wrm"
#include "tags.wrm"

#include "bs.h"
#include "plot.h"
#include "pick.h"
#include "graph.h"



static void try2On(int class)
{
 KEY k = 0, k1 ;
 
 mainActivity(messprintf("Lexaddkey %s", pickClass2Word(class))) ;

 while(lexNext(-class, &k))
   lexaddkey(name(k),&k1,_VCalcul) ;

 mainActivity(0) ;
 messout(" done %d ", lexMax(_VCalcul)) ;
}

extern unsigned int hashText(char *cp, int n, int rotate) ;
static void tryOn(int class)
{
 int i ;
 
 mainActivity(messprintf("Hash Test %s", pickClass2Word(class))) ;
 
for(i = 0 ; i<lexMax(class); i++)
  printf("%d   %d  %d  %d  %s\n", 
	 i, 
	 hashText(name(KEYMAKE(class,i)),8,5),
		  hashText(name(KEYMAKE(class,i)),8,4),
			   hashText(name(KEYMAKE(class,i)),8,3),
				    name(KEYMAKE(class,i))) ;
/*
 KEY k = 0; int h ; int i ;
 Array  hh, histo ;

 hashTest(class) ;

 hh = arrayCreate(2*lexMax(class), int) ;
 histo = arrayCreate(2*lexMax(class), int) ;
 while(lexNext(class, &k))
   { h = lexHash(k) ;
     array(hh,h,int)++ ;
   }
 i = arrayMax(hh) ;
 while(i--)
   array(histo,arr(hh,i,int),int)++ ;
 mainActivity(0) ;
 messout(" %d entries unused", array(histo,0,int)) ;
 arr(histo,0,int) = 0 ;
 plotHisto(messprintf("Hash distribution, class %d", class), histo) ;
 plotHisto(messprintf("Hash usage, class %d", class), hh) ;
*/

}

void acedbtest (void)
{ int i ;

  if(graphPrompt("Check hasher on table ?","0","i"))
    if (freeint(&i))
      if(i>=0)
	tryOn(i) ;
      else
	try2On(i) ;
}
