/*  File: keysetdump.c
 *  Author: Jean Thierry-Mieg (mieg@mrc-lmba.cam.ac.uk)
 *  Copyright (C) J Thierry-Mieg and R Durbin, 1991
 *-------------------------------------------------------------------
 * This file is part of the ACEDB genome database package, written by
 * 	Richard Durbin (MRC LMB, UK) rd@mrc-lmba.cam.ac.uk, and
 *	Jean Thierry-Mieg (CRBM du CNRS, France) mieg@frmop11.bitnet
 *
 * Description: Needed in acequery and xace
 * Exported functions:
 * HISTORY:
 * Last edited: Mar  5 19:53 1992 (mieg)
 * * Nov 12 14:23 1991 (mieg): added heap system
 * * Oct 23 18:12 1991 (mieg): added keySetParse
 * Created: Mon Oct 21 19:55:34 1991 (mieg)
 *-------------------------------------------------------------------
 */


#include "acedb.h"
#include "keyset.h"

#include "lex.h"  /* needed in keysetdump and keysetorder */
#include "pick.h"  /* needed in keysetdump */
#include "a.h"  /* needed in keySetParse */

  
  /* Heap sort
   * source is an array to be partially sorted,
   * nn is the desired number of sorted objects,
   * order is the order function
   * min and max are extrema of the sorting functions
   */

/**************************************************************/
/************ Dedicated heap function *************************/

KEYSET  keySetHeap(KEYSET source, int nn, int (*order)(KEY *, KEY *))
{ KEYSET h, result ;
  int i , k = 1 , max , pos ;
  KEY  new ;
    
  if(!source || !arrayMax(source))
    return keySetCreate() ;
  
  if(!arrayExists(source))
    messcrash("keySetHeap received a non-magic source keySet") ;

  mainActivity ("Heaping") ;
    /* Note that KEY 0 is used as maximal element */
  if(nn > arrayMax(source))
    nn = arrayMax(source) ;
  while( ( 1 << ++k) <= nn) ;
  max = 1 << k ;
  h = arrayCreate(max, KEY) ;
  arrayMax(h) = max ; 
  
  i = arrayMax(source) ;
  while (i --)
    { new = keySet(source, i) ;

        /*  HEAP_PUSH(new) */
      { pos = 1 ;
	while( ! arr(h, pos, KEY) ||
	      (order(&new,arrp(h, pos, KEY)) == -1 ) )
	  { if (pos>>1)
	      arr(h, pos>>1, KEY) = arr(h, pos, KEY) ;
	    arr(h, pos, KEY) = new ;
	    if ( (pos <<= 1) >= max )
	      break ;
	    if( ! arr(h, pos + 1, KEY) ||
	       ( order( arrp(h, pos, KEY), arrp(h, pos + 1 ,KEY)) == -1) )
	      pos++ ;
	  }
      }
    }

/* Test print out 
  for(i=0 ; i < arrayMax(h) ; i++)
    printf("%d %s \n", i, name(arr(h,i,KEY))) ;
*/  
              /* To dump,
	       * Create a minimal key
	       * and push it repeatedly
	       * collecting the top key 
	       */
  result = arrayCreate(max, KEY) ;
  arrayMax(result) = max - 1 ;
  
  i = max - 1 ;  /* pos 0 is not filled with any relevant data */
  new = KEYMAKE(0, lexMax(0)) ;
  while(i--)
    { arr(result, i, KEY) = arr(h, 1, KEY) ;
        /*  HEAP_PUSH(minimal key) */
      { pos = 1 ;
	while( TRUE ) /* I pretend to push a minimal key */
	  { if (pos>>1)
	      arr(h, pos>>1, KEY) = arr(h, pos, KEY) ;
	    arr(h, pos, KEY) = new ;
	    if ( (pos <<= 1) >= max )
	      break ;
	    if( arr (h, pos, KEY) == new ||
	       (order( arrp(h, pos, KEY), arrp(h, pos + 1 ,KEY)) == -1))
	      pos++ ;
	  }
      }
    }

  if(arrayMax(source) < arrayMax(result))
    (arrayMax(result) = arrayMax(source)) ;
  
  keySetDestroy(h) ;
  mainActivity (0) ;
  return result ;
}

/**************************************************************/
/**************************************************************/

       /* first order classes */
     /* then compares KEYs acoording to their Word meaning*/

int keySetAlphaOrder(void *a,void *b)
{
  register int i = class(*(KEY*)a) - class(*(KEY*)b) ;

  if (i)   
    return i ;
  else
    return( lexstrcmp(name(*(KEY *)a),
                   name(*(KEY *)b)  ));
}

/**************************************************************/

BOOL keySetDump(FILE *f, Stack buffer, Array s)
{ int i ;

  if(s->size != sizeof(KEY))
    return FALSE ;
  if (f)
    for (i=0; i < keySetMax(s); i++)
      fprintf(f, "%s : \"%s\"\n",
	      className(keySet(s,i)),
	      name(keySet(s,i)) ) ;
  else if (stackExists(buffer))
    for (i=0; i < keySetMax(s); i++)
      catText(buffer,
	      messprintf("%s : \"%s\"\n",
			 className(keySet(s,i)),
			 name(keySet(s,i)) ) ) ;

  return TRUE ;
}
	
/************************************/

BOOL keySetParse (int level, KEY key)
{
  char *cp = 0 , c;
  KEYSET kS = keySetCreate() ;
  int  class ; KEY k ;

  while (freecard(level) && (cp = freewordcut(":-/\" ",&c)))
    {
      class = pickWord2Class(cp) ;
      if(!class)
	goto abort ;
      freenext() ;
      freestep(':') ;
      freenext() ;
      if(cp = freeword())
	{ lexaddkey(cp,&k,class) ;
	  keySetInsert(kS,k) ;
	}
    }
  if (keySetMax(kS))
    arrayStore(key,kS,"k") ;
  keySetDestroy(kS) ;
  return TRUE ;
  
 abort:
  fprintf (stderr, "Line %7d  KeySet %s, bad word %s\n", 
	   freestreamline(level), name(key),  cp ? cp : "void line") ;
  messdump (
	    " keySetParse error at  Line %7d  KeySet %s, bad word %s\n", 
	    freestreamline(level), name(key),  cp ? cp : "void line") ;
  keySetDestroy(kS) ;
  return FALSE ;
}

/**************************************************************/
/**************************************************************/
